/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.orm.persistence;

import ext.base.core.BcInteger;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmSequenceDAO;
import ext.lib.orm.entity.OrmAddition;
import ext.lib.orm.entity.OrmDataId;
import ext.lib.orm.entity.OrmGeneralData;
import ext.lib.orm.persistence.OrmAbstractPersistence;
import ext.lib.orm.persistence.OrmPersistenceProxy;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSetClause;
import ext.lib.sql.model.SqlUpdateSql;
import ext.lib.sql.model.SqlWhereElement;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class OrmPersistenceAddition
extends OrmAbstractPersistence {
    boolean copyFlag = false;

    @Override
    public void setSetClause(SqlContext sqlContext, List<String> setElementList, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        setElementList.add("sy_noid=" + etdmAddition.getNoid());
        setElementList.add("sy_timestamp=" + sqlContext.toSet(etdmAddition.getAddTimestamp()));
        setElementList.add("sy_user_id=" + etdmAddition.getAddUserId());
    }

    @Override
    public void setSetClause(SqlUpdateSql updateSql, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        updateSql.addSetClause(new SqlSetClause("sy_noid", etdmAddition.getNoid()));
        updateSql.addSetClause(new SqlSetClause("sy_timestamp", etdmAddition.getAddTimestamp()));
        updateSql.addSetClause(new SqlSetClause("sy_user_id", etdmAddition.getAddUserId()));
    }

    @Override
    public void setSetClause(List<String> setColumnList, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        setColumnList.add("sy_noid");
        setColumnList.add("sy_timestamp");
        setColumnList.add("sy_user_id");
    }

    @Override
    public void setValueList(List<Object> valueList, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        valueList.add(etdmAddition.getNoid());
        valueList.add(etdmAddition.getAddTimestamp());
        valueList.add(etdmAddition.getAddUserId());
    }

    @Override
    public void getJdbcTypes(List<Integer> sqlTypeList, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        sqlTypeList.add(4);
        sqlTypeList.add(93);
        sqlTypeList.add(4);
    }

    @Override
    public void setPreStmtValue(SqlContext sqlContext, PreparedStatement preStmt, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        sqlContext.setPreStmtValue(preStmt, columnIndex, (Object)etdmAddition.getNoid(), 4);
        sqlContext.setPreStmtValue(preStmt, columnIndex, (Object)etdmAddition.getAddTimestamp(), 93);
        sqlContext.setPreStmtValue(preStmt, columnIndex, (Object)etdmAddition.getAddUserId(), 4);
    }

    @Override
    public void setSetClause(SqlUpdateSql updateSql, OrmGeneralData generalData, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            Object valueObject = generalData.getValue(i);
            if (mmdField.columnName.equals("sy_noid")) {
                updateSql.addSetClause(new SqlSetClause("sy_noid", valueObject));
            } else if (mmdField.columnName.equals("sy_timestamp")) {
                updateSql.addSetClause(new SqlSetClause("sy_timestamp", valueObject));
            } else if (mmdField.columnName.equals("sy_user_id")) {
                updateSql.addSetClause(new SqlSetClause("sy_user_id", valueObject));
            }
            ++i;
        }
    }

    @Override
    public void getSelectColumnName(List<String> columnNameList, String tableAlias, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        String tableAlias2 = SqlUtil.tableAliasToNotNull(tableAlias);
        columnNameList.add(String.valueOf(tableAlias2) + "sy_noid");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_timestamp");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_user_id");
    }

    @Override
    public void setResultSet(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        SqlContext sqlContext = dtsSession.getSqlContext();
        etdmAddition.setNoid(rs.getInt(columnIndex));
        etdmAddition.setAddTimestamp(rs.getCalendar(columnIndex));
        etdmAddition.setAddUserId(rs.getInt(columnIndex));
    }

    public boolean preTrans(DtsSession dtsSession, int userId, String tableName, Object entity) throws Exception {
        OrmDataId etdmDataId;
        long newObjectId;
        String dataName;
        SqlContext sqlContext = dtsSession.getSqlContext();
        Class<?> entityType = entity.getClass();
        OrmAddition etdmAddition = (OrmAddition)entity;
        boolean isInsert = false;
        if (etdmAddition.isAddition()) {
            dataName = MmdUtil.createTableColumnName(tableName, "sy_oid");
            newObjectId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, dataName);
            OrmPersistenceAddition.updateNextObjectId(dtsSession, tableName, etdmAddition.getObjectId(), newObjectId);
            etdmAddition.setObjectId(newObjectId);
            etdmAddition.setNoid(-1L);
            etdmAddition.setAddTimestamp(BcTimeUtil.createCalendar());
            if (userId > 0) {
                etdmAddition.setAddUserId(userId);
            }
            isInsert = true;
        } else if (etdmAddition.getObjectId() <= 0L) {
            dataName = MmdUtil.createTableColumnName(tableName, "sy_oid");
            newObjectId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, dataName);
            etdmAddition.setObjectId(newObjectId);
            etdmAddition.setNoid(-1L);
            isInsert = true;
        }
        etdmAddition.setAddTimestamp(BcTimeUtil.createCalendar());
        if (OrmDataId.class.isAssignableFrom(entityType) && (etdmDataId = (OrmDataId)entity).getDataId() <= 0) {
            int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
            etdmDataId.setDataId(newDataId);
        }
        return isInsert;
    }

    @Override
    public int putEntity(DtsSession dtsSession, OrmPersistenceProxy persistenceProxy, String tableName, List<String> columnList, List<Object> valueList, Object entity, boolean doInsertCheck) throws Exception {
        int updateCount;
        block13: {
            SqlContext sqlContext = dtsSession.getSqlContext();
            Class<?> entityType = entity.getClass();
            OrmAddition etdmAddition = (OrmAddition)entity;
            boolean doInsert = false;
            doInsert = doInsertCheck ? this.preTrans(dtsSession, etdmAddition.getAddUserId(), tableName, entity) : true;
            SqlUpdateSql updateSql = new SqlUpdateSql();
            updateSql.tableName = tableName;
            persistenceProxy.createCommonSetPhrase(updateSql, entity);
            int i = 0;
            while (i < columnList.size()) {
                Object value = valueList.get(i);
                SqlSetClause setClause = new SqlSetClause(columnList.get(i), value);
                updateSql.addSetClause(setClause);
                ++i;
            }
            updateCount = 0;
            if (doInsert) {
                String sql = sqlContext.buildInsertSql(updateSql);
                try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                    try {
                        updateCount = stmt.executeUpdate(sql);
                        break block13;
                    }
                    catch (Exception ex) {
                        BcLogUtil.error("error:sql=" + sql);
                        throw ex;
                    }
                }
            }
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("sy_oid=" + etdmAddition.getObjectId());
            updateSql.getWhereElementList().add(whereElement);
            String sql = sqlContext.buildUpdateSql(updateSql);
            try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                try {
                    updateCount = stmt.executeUpdate(sql);
                    if (updateCount <= 0) {
                        sql = sqlContext.buildInsertSql(updateSql);
                        updateCount = stmt.executeUpdate(sql);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.debug("error:sql=" + sql);
                    throw ex;
                }
            }
        }
        return updateCount;
    }

    public static int updateNextObjectId(DtsSession dtsSession, String tableName, long oid, long noid) throws Exception {
        String query = "UPDATE " + tableName + " SET " + "sy_noid" + "=" + noid + " WHERE " + "sy_oid" + "=" + oid;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int logicalDeleted(BcLogger logger, DtsSession dtsSession, String tableName, long oid, int userid) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlConnection dbCon = dtsSession.getConnection();
        boolean resValue = false;
        MmdModel mmdModel = sqlContext.createModelMetaData(dbCon, tableName);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append(sqlContext.createSelectSql(mmdModel));
        selectSql.append(" WHERE sy_oid=" + oid);
        String insertSql = sqlContext.createInsertSqlForPrepareStatement(mmdModel);
        int dataCount = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(insertSql);
            ResultSetMetaData rsmd = rs.getMetaData();
            try (SqlPreparedStatement ppst = dbCon.prepareStatement(insertSql);){
                try {
                    if (!rs.next()) return dataCount;
                    ++dataCount;
                    String sequenceName = MmdUtil.createTableColumnName(tableName, "sy_oid");
                    long newOid = OrmSequenceDAO.getInstance().generateNumber(dtsSession, sequenceName);
                    int i = 0;
                    while (true) {
                        block23: {
                            String columnName;
                            int colmunIndex;
                            block24: {
                                if (i >= rsmd.getColumnCount()) {
                                    ppst.executeUpdate();
                                    OrmPersistenceAddition.updateNextObjectId(dtsSession, tableName, oid, newOid);
                                    return dataCount;
                                }
                                colmunIndex = i + 1;
                                columnName = rsmd.getColumnName(colmunIndex);
                                if (!BcStringUtil.equalsIgnoreCase(columnName, "sy_oid")) break block24;
                                int sqlType = rsmd.getColumnType(colmunIndex);
                                if (sqlType == -5) {
                                    ppst.setObject(colmunIndex, newOid);
                                    break block23;
                                } else if (sqlType == 4) {
                                    ppst.setObject(colmunIndex, (int)newOid);
                                    break block23;
                                } else {
                                    if (sqlType != 5) {
                                        String msg = "Not supported JDBC Type. " + sqlType;
                                        throw new SQLException(msg);
                                    }
                                    ppst.setObject(colmunIndex, (short)newOid);
                                }
                                break block23;
                            }
                            if (BcStringUtil.equalsIgnoreCase(columnName, "sy_noid")) {
                                ppst.setObject(colmunIndex, -9);
                            } else if (BcStringUtil.equalsIgnoreCase(columnName, "sy_timestamp")) {
                                ppst.setObject(colmunIndex, new Timestamp(System.currentTimeMillis()));
                            } else if (BcStringUtil.equalsIgnoreCase(columnName, "sy_user_id")) {
                                ppst.setObject(colmunIndex, userid);
                            } else {
                                sqlContext.copyRow(rs, colmunIndex, sqlContext, ppst, colmunIndex, logger);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    logger.error("updateSql=" + selectSql);
                    logger.error("insertSql=" + insertSql);
                    throw ex;
                }
            }
        }
    }

    public static int logicalDeleted(BcLogger logger, DtsSession dtsSession, String tableName, long oid) throws Exception {
        return OrmPersistenceAddition.logicalDeleted(logger, dtsSession, tableName, oid, -1);
    }
}

