/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.image;

import ext.base.log.BcLogUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BcImage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3245447093812580598L;
    protected Image image;

    public BcImage() {
    }

    public BcImage(Image image) {
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        if (this.image == null) {
            return;
        }
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        os.writeInt(width);
        os.writeInt(height);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            BcLogUtil.error(ex);
        }
        os.writeObject(pixels);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int width = stream.readInt();
        int height = stream.readInt();
        int[] pixels = (int[])stream.readObject();
        MemoryImageSource memoryImageSource = new MemoryImageSource(width, height, pixels, 0, width);
        this.image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public Object clone() {
        BcImage obj = new BcImage();
        obj.image = this.image;
        return obj;
    }
}

