/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.util;

import ext.base.log.BcLogUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class FxDragAndDropHelper {
    public void setup(Node node) throws Exception {
        node.setOnDragDetected(ev -> {});
        node.setOnDragEntered(ev -> ev.consume());
        node.setOnDragExited(ev -> ev.consume());
        node.setOnDragOver(ev -> {
            ev.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            ev.consume();
        });
        node.setOnDragDropped(ev -> {
            BcLogUtil.debug("setOnDragDropped:ev=" + ev);
            Dragboard dragboard = ev.getDragboard();
            BcLogUtil.debug("setOnDragDropped:dragboard=" + dragboard);
            this.cathFileList(dragboard.getFiles());
            if (dragboard.hasString()) {
                BcLogUtil.debug("setOnDragDropped:dragboard.getString()=" + dragboard.getString());
            }
            Path target = Paths.get("temp", new String[0]);
            Files.exists(target, LinkOption.NOFOLLOW_LINKS);
            ev.setDropCompleted(dragboard.hasString());
            ev.consume();
        });
    }

    protected void cathFileList(List<File> fileList) {
        int i = 0;
        while (i < fileList.size()) {
            File file = fileList.get(i);
            BcLogUtil.debug("file=" + file.getPath());
            ++i;
        }
    }
}

