/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.table;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcConstants;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdRenderingConverter;
import ext.base.mmd.MmdUtil;
import ext.base.table.BcCellAttribute;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCommonUtil;
import ext.base.util.BcCsvUtil;
import ext.lib.awt.AwtFontUtil;
import ext.lib.fx.control.FxNumberField;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.table.FxCellAccessor;
import ext.lib.fx.table.FxTableCellFactory;
import ext.lib.fx.table.FxTableCellValueFactory;
import ext.lib.fx.table.FxTableColumn;
import ext.lib.fx.table.FxTableRow;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxColorUtil;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxUtil;
import ext.lib.html.ruby.HtmlRubyParser;
import ext.lib.html.util.EtcHtmlUtil;
import ext.lib.html.util.HtmlToPlain;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import java.awt.Font;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingNode;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import javax.swing.JComponent;
import javax.swing.table.TableModel;

public final class FxTableUtil {
    static HtmlRubyParser rubyHtmlParser = new HtmlRubyParser();
    static HtmlToPlain htmlToPlain = new HtmlToPlain();
    static double margin = 10.0;
    static double minWidth;

    private FxTableUtil() {
    }

    public static FxTableColumn createTableColumn(Callback<TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>> tableCellValueFactory, boolean isEditable, List<String> textList, Class dataClass) throws Exception {
        FxTableColumn tableColumn = new FxTableColumn();
        if (textList != null) {
            int i = 0;
            while (i < textList.size()) {
                String text = textList.get(i);
                tableColumn.tableColumnHeaderPane.addText(text);
                ++i;
            }
        }
        if (dataClass == Boolean.class && isEditable) {
            tableColumn.setCellFactory(column -> {
                CheckBoxTableCell cell = new CheckBoxTableCell(index -> {
                    Object row = tableColumn.getTableView().getItems().get(index.intValue());
                    Object cellValue = FxTableUtil.getCellValue(row, fxTableColumn.index);
                    Boolean bool = (Boolean)cellValue;
                    SimpleBooleanProperty selected = new SimpleBooleanProperty(bool.booleanValue());
                    selected.addListener((ov, o, n2) -> {
                        FxTableUtil.setCellValue(tableColumn.getTableView(), (int)index, fxTableColumn.index, n2);
                        tableColumn.getTableView().getSelectionModel().select(index.intValue(), (TableColumn)tableColumn);
                        Event.fireEvent((EventTarget)tableColumn.getTableView(), (Event)new MouseEvent(MouseEvent.MOUSE_CLICKED, 0.0, 0.0, 0.0, 0.0, MouseButton.PRIMARY, 1, true, true, true, true, true, true, true, true, true, true, null));
                    });
                    return selected;
                });
                return cell;
            });
        } else {
            FxTableCellFactory tableCellFactory = new FxTableCellFactory();
            tableColumn.setCellFactory(tableCellFactory);
        }
        if (tableCellValueFactory == null) {
            FxTableCellValueFactory tableCellValueFactory2 = new FxTableCellValueFactory();
            tableColumn.setCellValueFactory(tableCellValueFactory2);
        } else {
            tableColumn.setCellValueFactory(tableCellValueFactory);
        }
        tableColumn.setEditable(isEditable);
        return tableColumn;
    }

    public static FxTableColumn createTableColumn(MmdField mmdField, Callback<TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>> tableCellValueFactory, boolean isEditable, Object headerValue) throws Exception {
        List<String> textList = htmlToPlain.toTextList(MmdUtil.getProvisionalHeaderValue(mmdField));
        FxTableColumn tableColumn = FxTableUtil.createTableColumn(tableCellValueFactory, isEditable, textList, mmdField.dataClass);
        tableColumn.mmdField = mmdField;
        javafx.scene.text.Font font = FxFontUtil.getDefaultFont();
        double width = FxTableUtil.calcColumnWidth(mmdField, headerValue, font);
        tableColumn.setPrefWidth(width);
        return tableColumn;
    }

    public static FxTableColumn createTableColumn(BcTableColumn bcTableColumn, Callback<TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>> tableCellValueFactory) throws Exception {
        MmdField mmdField = bcTableColumn.getMmdField();
        FxTableColumn tableColumn = null;
        if (mmdField == null) {
            ArrayList<String> textList = null;
            if (bcTableColumn.getHeaderValue() != null) {
                textList = new ArrayList<String>();
                textList.add(BcStringUtil.toString(bcTableColumn.getHeaderValue()));
            }
            tableColumn = FxTableUtil.createTableColumn(tableCellValueFactory, bcTableColumn.isEditable, textList, null);
        } else {
            tableColumn = FxTableUtil.createTableColumn(mmdField, tableCellValueFactory, bcTableColumn.isEditable, bcTableColumn.getHeaderValue());
        }
        tableColumn.index = bcTableColumn.getModelIndex();
        return tableColumn;
    }

    public static List<FxTableColumn> createTableColumnList(Collection<? extends BcTableColumn> bcTableColumnCollection, Callback<TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>> tableCellValueFactory) throws Exception {
        ArrayList<FxTableColumn> tableColumnList = new ArrayList<FxTableColumn>();
        for (BcTableColumn bcTableColumn : bcTableColumnCollection) {
            FxTableColumn tableColumn = FxTableUtil.createTableColumn(bcTableColumn, tableCellValueFactory);
            tableColumnList.add(tableColumn);
        }
        return tableColumnList;
    }

    public static void createColumn(BcTableColumnModel bcTableColumnModel, FxTableView tableView, Callback<TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>> tableCellValueFactory) throws Exception {
        ArrayList<FxTableColumn> tableColumnList = new ArrayList<FxTableColumn>();
        int i = 0;
        while (i < bcTableColumnModel.getColumnCount()) {
            BcTableColumn bcTableColumn = (BcTableColumn)bcTableColumnModel.getColumn(i);
            FxTableColumn tableColumn = FxTableUtil.createTableColumn(bcTableColumn, tableCellValueFactory);
            tableColumn.index = i++;
            tableColumnList.add(tableColumn);
        }
        int hearderRowCount = 2;
        HashMap<String, TableColumn> groupColumnMap = new HashMap<String, TableColumn>();
        int i2 = 0;
        while (i2 < tableColumnList.size()) {
            FxTableColumn tableColumn = (FxTableColumn)((Object)tableColumnList.get(i2));
            TableColumn groupTableColumnPre = null;
            if (tableColumn.mmdField != null) {
                List<String> groupList = BcCsvUtil.parseCsvRow(tableColumn.mmdField.group, true);
                hearderRowCount = Math.max(hearderRowCount, 2 + groupList.size() * 2);
                int j = 0;
                while (j < groupList.size()) {
                    String group = groupList.get(j);
                    TableColumn groupTableColumnWk = (TableColumn)groupColumnMap.get(group);
                    if (groupTableColumnWk == null) {
                        groupTableColumnWk = new FxTableColumn(group);
                        groupColumnMap.put(group, groupTableColumnWk);
                        if (groupTableColumnPre == null) {
                            tableView.getColumns().add((Object)groupTableColumnWk);
                        } else {
                            groupTableColumnPre.getColumns().add((Object)groupTableColumnWk);
                        }
                    }
                    groupTableColumnPre = groupTableColumnWk;
                    ++j;
                }
            }
            if (groupTableColumnPre == null) {
                tableView.getColumns().add((Object)tableColumn);
            } else {
                groupTableColumnPre.getColumns().add((Object)tableColumn);
            }
            ++i2;
        }
        tableView.headerHeight = FxTableUtil.calcHeaderHeight(hearderRowCount);
    }

    public static void createColumn(BcTableColumnModel bcTableColumnModel, FxTableView tableView) throws Exception {
        FxTableUtil.createColumn(bcTableColumnModel, tableView, null);
    }

    public static void setSortable(TableView tableView, boolean sortable) {
        ObservableList tableColumnList = tableView.getColumns();
        int i = 0;
        while (i < tableColumnList.size()) {
            TableColumn tableColumn = (TableColumn)tableColumnList.get(i);
            tableColumn.setSortable(sortable);
            ++i;
        }
    }

    public static Object getCellValue(Object row, int columnId) {
        if (row == null) {
            return null;
        }
        Object value = null;
        if (row instanceof List) {
            List list = (List)row;
            value = list.get(columnId);
        } else if (row instanceof FxTableRow) {
            FxTableRow tableRow = (FxTableRow)row;
            value = tableRow.getValue(columnId);
        } else if (row instanceof FxCellAccessor) {
            FxCellAccessor cellAccessor = (FxCellAccessor)row;
            value = cellAccessor.getCellValue(columnId);
        } else {
            String msg = "Not supported row type. " + row.getClass().getName();
            throw new RuntimeException(msg);
        }
        return value;
    }

    public static Object getCellValue(ObservableList tableItems, int rowId, int columnId) {
        Object row = tableItems.get(rowId);
        return FxTableUtil.getCellValue(row, columnId);
    }

    public static Object getCellValue(TableView tableView, int rowId, int columnId) {
        return FxTableUtil.getCellValue(tableView.getItems(), rowId, columnId);
    }

    public static Object getCellValue(TableView tableView, int rowId, String tableColumnName) throws Exception {
        FxTableColumn tableColumn = FxTableUtil.getTableColumnByTableColumnName((Collection<? extends TableColumn>)tableView.getColumns(), tableColumnName);
        if (tableColumn == null) {
            String msg = String.format("\u5217 '%s' \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", tableColumnName);
            throw new Exception(msg);
        }
        return FxTableUtil.getCellValue(tableView, rowId, tableColumn.index);
    }

    public static void setCellValue(Object row, int columnId, Object value) {
        if (row instanceof List) {
            List list = (List)row;
            list.set(columnId, value);
        } else if (row instanceof FxTableRow) {
            FxTableRow tableRow = (FxTableRow)row;
            tableRow.setValue(columnId, value);
        } else if (row instanceof FxCellAccessor) {
            FxCellAccessor cellAccessor = (FxCellAccessor)row;
            cellAccessor.setCellValue(columnId, value);
        } else {
            String msg = "Not supported row type. " + row.getClass().getName();
            throw new RuntimeException(msg);
        }
    }

    public static void setCellValue(ObservableList rowList, int rowId, int columnId, Object value) {
        Object row = rowList.get(rowId);
        FxTableUtil.setCellValue(row, columnId, value);
    }

    public static void setCellValue(TableView tableView, int rowId, int columnId, Object value) {
        FxTableUtil.setCellValue(tableView.getItems(), rowId, columnId, value);
    }

    public static FxTableColumn getTableColumnByTableColumnName(Collection<? extends TableColumn> tableColumCollection, String tableColumnName) {
        for (TableColumn tableColumn : tableColumCollection) {
            FxTableColumn fxTableColumn = (FxTableColumn)tableColumn;
            MmdField mmdField = fxTableColumn.mmdField;
            if (mmdField == null || !BcStringUtil.equalsIgnoreCase(mmdField.tableColumnName, tableColumnName)) continue;
            return fxTableColumn;
        }
        return null;
    }

    public static int getColumnIdByTableColumnName(Collection<? extends TableColumn> tableColumCollection, String tableColumnName) {
        FxTableColumn fxTableColumn = FxTableUtil.getTableColumnByTableColumnName(tableColumCollection, tableColumnName);
        if (fxTableColumn != null) {
            return fxTableColumn.index;
        }
        return -1;
    }

    public static int[] getColumnIds(Collection<? extends TableColumn> tableColumCollection, String ... tableColumnNames) {
        int[] columnIds = new int[tableColumnNames.length];
        int i = 0;
        while (i < tableColumnNames.length) {
            String tableColumnName = tableColumnNames[i];
            int columnIndex = FxTableUtil.getColumnIdByTableColumnName(tableColumCollection, tableColumnName);
            if (columnIndex < 0) {
                BcLogUtil.warning("Not found column. name='" + tableColumnName + "'");
            }
            columnIds[i] = columnIndex;
            ++i;
        }
        return columnIds;
    }

    public static List createValueList(Object row, int[] columnIds) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (row instanceof List) {
            List row2 = (List)row;
            int i = 0;
            while (i < columnIds.length) {
                int columnId = columnIds[i];
                Object value = BcCollectionUtil.getElement(row2, columnId);
                valueList.add(value);
                ++i;
            }
        } else if (row instanceof FxTableRow) {
            FxTableRow tableRow = (FxTableRow)row;
            int i = 0;
            while (i < columnIds.length) {
                int columnId = columnIds[i];
                Object value = tableRow.getValue(columnId);
                valueList.add(value);
                ++i;
            }
        } else {
            throw new RuntimeException("row=" + row);
        }
        return valueList;
    }

    public static List<List> createRowList(List rowList, int[] rowIds, int[] columnIds) {
        ArrayList<List> newRowList = new ArrayList<List>();
        int i = 0;
        while (i < rowIds.length) {
            int rowId = rowIds[i];
            Object row = rowList.get(rowId);
            List newRow = FxTableUtil.createValueList(row, columnIds);
            newRowList.add(newRow);
            ++i;
        }
        return newRowList;
    }

    public static List<List> createRowList(FxTableView tableView, int[] rowIds, String ... tableColumnNames) {
        ObservableList tableColumnList = tableView.getColumns();
        int[] columnIds = FxTableUtil.getColumnIds((Collection<? extends TableColumn>)tableColumnList, tableColumnNames);
        ObservableList rowList = tableView.getItems();
        return FxTableUtil.createRowList((List)rowList, rowIds, columnIds);
    }

    public static List<List> createRowList(FxTableView tableView, List<Integer> rowIdist, String ... tableColumnNames) {
        int[] rowIds = rowIdist.stream().mapToInt(Integer::intValue).toArray();
        return FxTableUtil.createRowList(tableView, rowIds, tableColumnNames);
    }

    public static List<List> createSelectedRowList(FxTableView tableView, String ... tableColumnNames) {
        ObservableList rowIdList = tableView.getSelectionModel().getSelectedIndices();
        return FxTableUtil.createRowList(tableView, (List<Integer>)rowIdList, tableColumnNames);
    }

    public static double calcColumnWidth(MmdField mmdField, Object headerValue, javafx.scene.text.Font font) throws Exception {
        if (mmdField != null && mmdField.columnCount >= 0) {
            Dimension2D dim = FxUtil.getTextFieldSize(font, mmdField.columnCount);
            return dim.getWidth() + margin;
        }
        double width1 = -1.0;
        if (headerValue != null && CharSequence.class.isAssignableFrom(headerValue.getClass())) {
            CharSequence charSequence = (CharSequence)headerValue;
            List<String> strList = EtcHtmlUtil.toStringList(charSequence);
            int i = 0;
            while (i < strList.size()) {
                String str = strList.get(i);
                Dimension2D dim = FxUtil.getTextFieldSize(font, str);
                width1 = Math.max(width1, dim.getWidth() + 4.0);
                ++i;
            }
        }
        double width2 = Math.max(width1, FxTableUtil.getMinWidth(font));
        return width2;
    }

    public static double getMinWidth(javafx.scene.text.Font font) {
        if (minWidth <= 0.0) {
            Dimension2D dim = FxUtil.getTextFieldSize(font, 16);
            minWidth = dim.getWidth() + margin;
        }
        return minWidth;
    }

    public static Node getCellNode_Number(MmdField mmdField, Class valueClass, Object cellValue, boolean isEdit, MmdRenderingConverter renderingConverter, Labeled labeled, FxNumberField numberField, BcCellAttribute cellAttribute) throws Exception {
        if (!Number.class.isAssignableFrom(valueClass)) {
            return null;
        }
        Number number = (Number)cellValue;
        if (isEdit) {
            if (BcNumberUtil.isIntegeraClass(valueClass)) {
                numberField.setDecimalDigit(0);
            } else if (BcNumberUtil.isFloatingaPointClass(valueClass)) {
                numberField.setDecimalDigit(-1);
            } else if (valueClass.equals(BigDecimal.class) && cellValue != null) {
                BigDecimal bigDec = (BigDecimal)cellValue;
                if (bigDec.scale() >= 0) {
                    numberField.setDecimalDigit(bigDec.scale());
                } else {
                    throw new Exception("bigDec.scale()=" + bigDec.scale());
                }
            }
            numberField.nullable = mmdField.nullable == BcConstants.Existence.TRUE.value;
            numberField.setValue(number);
            numberField.selectAll();
            return numberField;
        }
        String text = null;
        if (cellValue != null) {
            text = renderingConverter.toString(mmdField, cellValue);
        }
        labeled.setText(text);
        FxTableUtil.setCellAttribute((Node)labeled, cellAttribute);
        return labeled;
    }

    public static Node getCellNode_Calendar(MmdField mmdField, Class valueClass, Object cellValue, boolean isEdit, Labeled labeled, BcCellAttribute cellAttribute) throws Exception {
        Calendar calendar = null;
        if (Calendar.class.isAssignableFrom(valueClass) || Date.class.isAssignableFrom(valueClass)) {
            if (Calendar.class.isAssignableFrom(valueClass)) {
                calendar = (Calendar)cellValue;
            } else if (Date.class.isAssignableFrom(valueClass)) {
                calendar = BcTimeUtil.toCalendar((Date)cellValue);
            }
        }
        if (calendar == null) {
            return null;
        }
        BcCommonUtil.improvement("JavaFX:\u30bb\u30ebCalendar\u578b\u306e\u7de8\u96c6\u30e2\u30fc\u30c9\u672a\u5bfe\u5fdc");
        String str = BcTimeUtil.toString(calendar, mmdField.formatPatternWork);
        labeled.setText(str);
        TextAlignment textAlignment = FxUtil.toTextAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        labeled.setTextAlignment(textAlignment);
        FxTableUtil.setCellAttribute((Node)labeled, cellAttribute);
        return labeled;
    }

    public static Node getCellNode_Boolean(MmdField mmdField, Class valueClass, Object cellValue, boolean isEdit, CheckBox checkBox, Labeled labeled, BcCellAttribute cellAttribute) throws Exception {
        if (!Boolean.class.isAssignableFrom(valueClass)) {
            return null;
        }
        boolean bool = false;
        if (cellValue != null) {
            bool = (Boolean)cellValue;
        }
        checkBox.setSelected(bool);
        if (isEdit) {
            return checkBox;
        }
        labeled.setText(BcBooleanUtil.toYN(bool));
        TextAlignment textAlignment = FxUtil.toTextAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        labeled.setTextAlignment(textAlignment);
        FxTableUtil.setCellAttribute((Node)labeled, cellAttribute);
        return labeled;
    }

    public static Node getCellNode_jComponent(MmdField mmdField, Class valueClass, Object cellValue, boolean isEdit, SwingNode swingNode) throws Exception {
        if (!JComponent.class.isAssignableFrom(valueClass)) {
            return null;
        }
        JComponent jComponent = (JComponent)cellValue;
        swingNode.setContent(jComponent);
        return swingNode;
    }

    public static Node getCellNode_text(MmdField mmdField, Object cellValue, boolean isEdit, Labeled labeled, TextInputControl textInputControl, BcCellAttribute cellAttribute) throws Exception {
        String strValue = null;
        strValue = cellValue instanceof String ? (String)cellValue : BcStringUtil.toString(cellValue);
        if (isEdit) {
            textInputControl.setText(strValue);
            textInputControl.selectAll();
            return textInputControl;
        }
        labeled.setText(strValue);
        if (mmdField.rowCount > 1) {
            labeled.setWrapText(true);
        }
        TextAlignment textAlignment = FxUtil.toTextAlignment(MmdUtil.getHorizonalAlignment(mmdField));
        labeled.setTextAlignment(textAlignment);
        FxTableUtil.setCellAttribute((Node)labeled, cellAttribute);
        return labeled;
    }

    public static double calcHeaderHeight(int rowCount) throws Exception {
        int textHeight = AwtFontUtil.getTextSize((Font)SwgLafManager.getInstance().font).height;
        double headerHeight = SwgTableViewUtil.calcHeaderHeight(textHeight, rowCount);
        return headerHeight;
    }

    public static BcCellAttribute getCellAttribute(TableCell tableCell) throws Exception {
        FxTableView fxTableView;
        TableModel attributeTable;
        TableView tableView = tableCell.getTableView();
        BcCellAttribute cellAttribute = null;
        if (tableView instanceof FxTableView && (attributeTable = (fxTableView = (FxTableView)tableView).getAttributeTable()) != null) {
            TableColumn tableColumn = tableCell.getTableColumn();
            FxTableColumn fxTableColumn = (FxTableColumn)tableColumn;
            Object attribute = attributeTable.getValueAt(tableCell.getIndex(), fxTableColumn.index);
            if (attribute instanceof BcCellAttribute) {
                cellAttribute = (BcCellAttribute)attribute;
                if (cellAttribute.cellBackgroundColor != null) {
                    Color cellBackgroundColor = FxColorUtil.convFromAwt(cellAttribute.cellBackgroundColor);
                    tableCell.setStyle(FxCssUtil.css_BG_FG(cellBackgroundColor, null));
                }
            }
        }
        return cellAttribute;
    }

    public static void setCellAttribute(Node node, BcCellAttribute cellAttribute) throws Exception {
        if (cellAttribute != null) {
            Color textFillColor = null;
            if (cellAttribute.textFillColor != null) {
                textFillColor = FxColorUtil.convFromAwt(cellAttribute.textFillColor);
            }
            node.setStyle(FxCssUtil.css_BG_FG(null, textFillColor));
        }
    }
}

