/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.layout;

import ext.base.core.BcStringUtil;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxControlPane;
import ext.lib.fx.util.FxUtil;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class FxDecoratePane
extends FxBorderPane {
    private double leftRightMargin = 2.0;
    private double lineMargin = 8.0;
    private FxBorderPane bottomPane = new FxBorderPane();
    private FxControlPane controlPane;

    public FxDecoratePane() throws Exception {
        this.setLeft((Node)FxUtil.cretePane(this.leftRightMargin, -1.0));
        this.setRight((Node)FxUtil.cretePane(this.leftRightMargin, -1.0));
        this.setControlPane(new FxControlPane());
        this.setBottom((Node)this.bottomPane);
    }

    public void underLineEnabled() throws Exception {
        BorderPane dummyPane = new BorderPane();
        dummyPane.setLeft((Node)FxUtil.cretePane(this.lineMargin * 2.0, -1.0));
        dummyPane.setRight((Node)FxUtil.cretePane(this.lineMargin * 2.0, -1.0));
        Pane lineBasePane = new Pane();
        Line line = new Line();
        FxUtil.setLine(line, 0.0, 0.0, 0.0, 0.0);
        line.endXProperty().bind((ObservableValue)lineBasePane.widthProperty());
        lineBasePane.getChildren().add((Object)line);
        dummyPane.setCenter((Node)lineBasePane);
        line.setId("under-line");
        this.bottomPane.setTop((Node)dummyPane);
    }

    public FxControlPane getControlPane() {
        return this.controlPane;
    }

    public void setControlPane(FxControlPane controlPane) {
        this.controlPane = controlPane;
        this.bottomPane.setCenter((Node)controlPane);
    }

    public void setDescription(String html, double height) throws Exception {
        WebView webView = new WebView();
        WebEngine webEngine = webView.getEngine();
        webEngine.loadContent(html);
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(this.lineMargin));
        vbox.setSpacing(this.lineMargin);
        vbox.setPrefSize(0.0, height + this.lineMargin);
        vbox.getChildren().add((Object)webView);
        vbox.setStyle("-fx-effect: innershadow( three-pass-box , rgba(0,0,0,0.7) , 3, 0.0 , 0 , 2 )");
        this.setTop((Node)vbox);
    }

    public void setDescription(String html) throws Exception {
        this.setDescription(html, 60.0);
    }

    public void addControlNode(Node node) throws Exception {
        this.controlPane.addControl(node);
    }

    public FxButton createButton() throws Exception {
        FxButton button = new FxButton();
        button.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)button);
        return button;
    }

    public FxButton createButton(String text) throws Exception {
        FxButton button = this.createButton();
        if (!BcStringUtil.isEmpty(text)) {
            button.setText(text);
        }
        return button;
    }
}

