/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx;

import ext.lib.fx.util.FxExceptionHandler;
import ext.lib.swg.SwgUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;

public final class FxPlatform {
    protected static boolean isInitialized;

    static {
        FxExceptionHandler exceptionHandler = new FxExceptionHandler();
        SwgUtil.setExceptionHandler(exceptionHandler);
        Thread.currentThread().setUncaughtExceptionHandler((t, e) -> exceptionHandler.handleException(e, t));
        Platform.setImplicitExit((boolean)false);
        new JFXPanel();
    }

    private FxPlatform() throws Exception {
    }

    public static void init() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
    }

    public static void runLater(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    public static void runAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (Platform.isFxApplicationThread()) {
            throw new Error("Cannot call runAndWait from the FX Application Thread");
        }
        Throwable[] throwable = new Throwable[1];
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    throwableArray[0] = t;
                    latch.countDown();
                }
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (throwable[0] != null) {
            throw new InvocationTargetException(throwable[0]);
        }
    }
}

