/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource.util;

import ext.base.table.BcTableColumn;
import ext.base.table.BcTableModel;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public final class EtcSqlUtil {
    private EtcSqlUtil() {
    }

    public static BcTableModel createTableModel(ResultSet rs) throws Exception {
        BcTableModel tableModel = null;
        try {
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(rs.getMetaData());
            tableModel = SqlUtil.getAsTable(rs, tableColumnList);
            rs.close();
        }
        finally {
            rs.close();
        }
        return tableModel;
    }

    public static BcTableModel createTableModel(DtsSession dtsSession, String sql) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        BcTableModel tableModel = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData());
            tableModel = SqlUtil.getAsTable(rs, tableColumnList);
            rs.close();
        }
        return tableModel;
    }

    public static void getValueList(DtsSession dtsSession, String sql, int columnIndex, List valueList) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            SqlUtil.getValueList(rs, columnIndex, valueList);
            rs.close();
        }
    }

    public static List getValueList(DtsSession dtsSession, String sql, int columnIndex) throws Exception {
        ArrayList valueList = new ArrayList();
        EtcSqlUtil.getValueList(dtsSession, sql, columnIndex, valueList);
        return valueList;
    }
}

