/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource;

import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionOverException;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContextFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Calendar;
import java.util.Properties;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DtsConnectionManagerImpl
extends DtsConnectionManager {
    private int isValidTimeout = 1;
    private ConcurrentLinkedQueue<SqlConnection> availableQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<SqlConnection> lendingQueue = new ConcurrentLinkedQueue();
    private lendingTimeoutCheckTask lendingTimeoutCheckTask;
    public int lendingCountMax;
    public Calendar lendingMaxTime;

    @Override
    public void setup(Driver driver, String dtsUrl, Properties dtsProps) throws Exception {
        this.init();
        this.setDriver(driver);
        if (driver != null) {
            dtsProps.setProperty(SqlConstants.DatasourceProperty.driver.name(), driver.getClass().getName());
        }
        this.setDtsUrl(dtsUrl);
        dtsProps.setProperty(SqlConstants.DatasourceProperty.url.name(), dtsUrl);
        this.setDtsProps(dtsProps);
        if (this.getLendinglTimeout() > 0L) {
            this.lendingTimeoutCheckTask = new lendingTimeoutCheckTask();
            Timer timer = new Timer();
            timer.schedule((TimerTask)this.lendingTimeoutCheckTask, this.getLendinglTimeoutCheckInterval(), this.getLendinglTimeoutCheckInterval());
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.closeAllConnection();
        this.availableQueue.clear();
        this.lendingQueue.clear();
    }

    @Override
    public SqlContext getSqlContext() throws Exception {
        if (super.getSqlContext() == null) {
            this.createConnectionTemp();
        }
        return super.getSqlContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(SqlConnection dbCon) throws Exception {
        ConcurrentLinkedQueue<SqlConnection> concurrentLinkedQueue = this.availableQueue;
        synchronized (concurrentLinkedQueue) {
            this.availableQueue.add(dbCon);
        }
    }

    @Override
    public SqlConnection getConnection() throws Exception {
        SqlConnection dbCon = null;
        while ((dbCon = this.availableQueue.poll()) != null) {
            try {
                if (!dbCon.isValid(this.isValidTimeout)) continue;
                break;
            }
            catch (UnsupportedOperationException ex) {
                try {
                    SqlUtil.execute(dbCon, "SELECT 1");
                    break;
                }
                catch (Exception ex2) {
                }
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        if (dbCon == null) {
            if (this.getConnectionMax() > 0 && this.getConnectionCount() > this.getConnectionMax()) {
                this.getLogger().warning("Datasource connection max over. getConnectionCount()=" + this.getConnectionCount());
                throw new DtsConnectionOverException();
            }
            dbCon = this.createConnection();
        }
        dbCon.setLendingStartTime(System.currentTimeMillis());
        dbCon.setLendinglTimeout(this.getLendinglTimeoutCheckInterval());
        dbCon.setLendinglTimeoutTime(-1L);
        this.lendingQueue.offer(dbCon);
        if (this.lendingQueue.size() > this.lendingCountMax) {
            this.lendingCountMax = this.lendingQueue.size();
            this.lendingMaxTime = BcTimeUtil.createCalendar();
        }
        return dbCon;
    }

    @Override
    public void connectionUsed(SqlConnection dbCon) throws Exception {
        if (dbCon.getAutoCommit()) {
            dbCon.setAutoCommit(false);
        } else {
            dbCon.rollback();
        }
        if (this.lendingQueue.remove(dbCon)) {
            if (this.availableQueue.size() < this.getConnectionMin()) {
                dbCon.clear();
                this.availableQueue.offer(dbCon);
            } else {
                dbCon.clear();
                dbCon.close();
            }
        } else {
            if (this.availableQueue.remove(dbCon)) {
                BcLogUtil.debug("ConnectionManager:connectionUsed E5001");
            }
            throw new Exception("ConnectionManager:connectionUsed E1001");
        }
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws Exception {
        Connection dbCon;
        Object[] dbcons = this.availableQueue.toArray();
        int i = 0;
        while (i < dbcons.length) {
            dbCon = (Connection)dbcons[i];
            dbCon.setAutoCommit(isAutoCommit);
            ++i;
        }
        dbcons = this.lendingQueue.toArray();
        i = 0;
        while (i < dbcons.length) {
            dbCon = (Connection)dbcons[i];
            dbCon.setAutoCommit(isAutoCommit);
            ++i;
        }
    }

    protected SqlConnection createConnection() throws Exception {
        Connection dbConTmp = SqlUtil.connect(this.getDriver(), this.getDtsUrl(), this.getDtsProps());
        SqlContext sqlContext = SqlContextFactory.getSqlContext(dbConTmp);
        this.setSqlContext(sqlContext);
        SqlConnection dbCon = new SqlConnection(dbConTmp, this.getSqlContext());
        dbCon.setLogger(this.getLogger());
        dbCon.setConnectedTime(System.currentTimeMillis());
        dbCon.setAutoCommit(false);
        dbCon.setResponseLogTime(this.getResponseLogTime());
        this.getSqlContext().setTransactionIsolation(dbCon);
        return dbCon;
    }

    protected void createConnectionTemp() throws Exception {
        SqlConnection dbCon = this.createConnection();
        dbCon.close();
    }

    @Override
    public int getConnectionCount() throws Exception {
        int count = 0;
        count += this.availableQueue.size();
        return count += this.lendingQueue.size();
    }

    @Override
    public void closeAllConnection() throws Exception {
        SqlConnection dbCon;
        if (this.availableQueue.size() <= 0 && this.lendingQueue.size() <= 0) {
            return;
        }
        BcLogUtil.info("Closing Datasource Connections..." + this.getDtsUrl());
        BcLogUtil.info("available=" + this.availableQueue.size() + " lending=" + this.lendingQueue.size());
        while (this.availableQueue.size() > 0) {
            dbCon = this.availableQueue.poll();
            try {
                dbCon.rollback();
                dbCon.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        while (this.lendingQueue.size() > 0) {
            dbCon = this.lendingQueue.poll();
            try {
                dbCon.rollback();
                dbCon.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public Queue<SqlConnection> getAvailableQueue() {
        return this.availableQueue;
    }

    public Queue<SqlConnection> getLendingQueue() {
        return this.lendingQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionLendingTimeoutCheck() throws Exception {
        SqlConnection[] dbConArray = this.getLendingQueue().toArray(new SqlConnection[0]);
        int i = 0;
        while (i < dbConArray.length) {
            SqlConnection dbCon = dbConArray[i];
            if (!dbCon.isClosed()) {
                if (dbCon.getLendingStartTime() <= 0L) {
                    this.getLogger().debug("\u8cb8\u51fa\u958b\u59cb\u65e5\u6642\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044");
                } else if (dbCon.getLendinglTimeout() <= 0L) {
                    this.getLogger().debug("\u8cb8\u51fa\u671f\u9650\u8a2d\u5b9a\u3055\u308c\u3066\u306a");
                } else if (dbCon.getLendinglTimeoutTime() > 0L) {
                    this.getLogger().debug("\u8cb8\u51fa\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u6e08:\u65e5\u6642=" + BcTimeUtil.toString(BcTimeUtil.toCalendar(dbCon.getLendinglTimeoutTime()), "yyyyMMddHHmmssSSS"));
                } else {
                    long now = System.currentTimeMillis();
                    long span = now - dbCon.getLendingStartTime();
                    if (span > dbCon.getLendinglTimeout()) {
                        BcLogUtil.info("lending timeout:lendingStartTim=" + BcTimeUtil.toString(dbCon.getLendingStartTime(), "yyyy/MM/dd HH:mm:ss") + " span=" + BcTimeUtil.getTermString(span));
                        try {
                            SqlConnection sqlConnection = dbCon;
                            synchronized (sqlConnection) {
                                dbCon.setLendinglTimeoutTime(now);
                                this.getLogger().debug("dbCon.cancelStatement()...");
                                dbCon.cancelStatement();
                                this.getLogger().debug("dbCon.rollback()...");
                                dbCon.rollback();
                                this.getLogger().debug("dbCon.close()...");
                                dbCon.close();
                            }
                            this.getLendingQueue().remove(dbCon);
                            this.getLogger().info("lending count=" + this.getLendingQueue().size());
                            String dummy2 = "";
                            this.getLogger().warning("<< lending timeout traceId=" + dummy2.hashCode() + " >>");
                            this.logHelper(dbCon, dummy2.hashCode());
                        }
                        catch (Exception ex) {
                            this.getLogger().error("lending timeout check error:dbCon.hashCode()=" + dbCon.hashCode());
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void logHelper(SqlConnection dbCon, int traceId) throws Exception {
        this.getLogger().warning("traceId:" + traceId + " dbCon[" + dbCon.hashCode() + "] + owner=" + dbCon.getOwner());
    }

    public void logHelper(SqlConnection[] dbConArray, int traceId) throws Exception {
        int i = 0;
        while (i < dbConArray.length) {
            SqlConnection dbCon = dbConArray[i];
            this.logHelper(dbCon, traceId);
            ++i;
        }
    }

    class lendingTimeoutCheckTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                DtsConnectionManagerImpl.this.connectionLendingTimeoutCheck();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

