/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.awt;

import ext.base.core.BcNumberUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcMessageCreator;
import it.geosolutions.imageio.plugins.tiff.BaselineTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.TIFFDirectory;
import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.print.attribute.standard.MediaSize;

public class AwtImageUtil {
    private AwtImageUtil() {
    }

    public static Dimension calcPixelDimension(double wInch, double hInch, int dpi) throws Exception {
        long wDot = Math.round(wInch * (double)dpi);
        long hDot = Math.round(hInch * (double)dpi);
        Dimension dim = new Dimension(BcNumberUtil.toIntRoundHalfUp(wDot), BcNumberUtil.toIntRoundHalfUp(hDot));
        return dim;
    }

    public static Dimension calcPixelDimension(MediaSize mediaSize, int dpi) throws Exception {
        double wInch = mediaSize.getX(25400);
        double hInch = mediaSize.getY(25400);
        return AwtImageUtil.calcPixelDimension(wInch, hInch, dpi);
    }

    public static Rectangle toRectangleInt(Rectangle2D.Double rectangle2D) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(BcNumberUtil.toIntRoundHalfUp(rectangle2D.x), BcNumberUtil.toIntRoundHalfUp(rectangle2D.y), BcNumberUtil.toIntRoundHalfUp(rectangle2D.width), BcNumberUtil.toIntRoundHalfUp(rectangle2D.height));
        return rectangle;
    }

    public static Rectangle2D.Double calcKeepRatioSize(double srcWidth, double srcHeight, double targetWidth, double targetHeight) {
        double wRatio = targetWidth / srcWidth;
        double hRatio = targetHeight / srcHeight;
        double ratio = Math.min(wRatio, hRatio);
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.width = srcWidth * ratio;
        rectangle.height = srcHeight * ratio;
        return rectangle;
    }

    public static Rectangle2D.Double calcKeepRatioSize(Rectangle2D.Double srcRect, Rectangle2D.Double targetRect) {
        return AwtImageUtil.calcKeepRatioSize(srcRect.getWidth(), srcRect.getHeight(), targetRect.getWidth(), targetRect.getHeight());
    }

    public static void setRenderingHint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    public static BufferedImage toBufferedImage(Image srcImage, int imageType) {
        ImageObserver imageObserver = null;
        int srcWidth = srcImage.getWidth(imageObserver);
        int srcHeight = srcImage.getHeight(imageObserver);
        BufferedImage bufferedImage = new BufferedImage(srcWidth, srcHeight, imageType);
        Graphics2D g2d = bufferedImage.createGraphics();
        AwtImageUtil.setRenderingHint(g2d);
        g2d.drawImage(srcImage, 0, 0, imageObserver);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image srcImage) {
        int imageType = AwtImageUtil.getImageType(srcImage);
        return AwtImageUtil.toBufferedImage(srcImage, imageType);
    }

    public static int getImageType(Image image) {
        int imageType = 1;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            imageType = bufferedImage.getType();
        }
        return imageType;
    }

    public static BufferedImage resizeImage(Image srcImage, double targetWidth, double targetHeight, boolean isKeepRatio, int imageType) {
        ImageObserver imageObserver = null;
        if (targetWidth <= 0.0) {
            targetWidth = srcImage.getWidth(imageObserver);
        }
        if (targetHeight <= 0.0) {
            targetHeight = srcImage.getHeight(imageObserver);
        }
        Rectangle2D.Double targetRect = null;
        if (isKeepRatio) {
            Rectangle2D.Double srcRectangle = new Rectangle2D.Double();
            srcRectangle.width = srcImage.getWidth(imageObserver);
            srcRectangle.height = srcImage.getHeight(imageObserver);
            targetRect = AwtImageUtil.calcKeepRatioSize(srcRectangle.width, srcRectangle.height, targetWidth, targetHeight);
        } else {
            targetRect = new Rectangle2D.Double();
            targetRect.width = targetWidth;
            targetRect.height = targetHeight;
        }
        Rectangle targetRectInt = AwtImageUtil.toRectangleInt(targetRect);
        Image targetImage = srcImage.getScaledInstance(targetRectInt.width, targetRectInt.height, 4);
        BufferedImage bufferedImage = AwtImageUtil.toBufferedImage(targetImage, imageType);
        return bufferedImage;
    }

    public static BufferedImage resizeImage(Image srcImage, double targetWidth, double targetHeight, boolean isKeepRatio) {
        int imageType = 6;
        if (srcImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)srcImage;
            imageType = bufferedImage.getType();
        }
        return AwtImageUtil.resizeImage(srcImage, targetWidth, targetHeight, isKeepRatio, imageType);
    }

    public static BufferedImage resizeImage(Image srcImage, double targetWidth, double targetHeight) {
        return AwtImageUtil.resizeImage(srcImage, targetWidth, targetHeight, true);
    }

    public static BufferedImage resizeImage(Image srcImage, Rectangle2D.Double targetRect) {
        return AwtImageUtil.resizeImage(srcImage, targetRect.width, targetRect.height, true);
    }

    public static BufferedImage resizeImage(Image srcImage, double ratio) {
        ImageObserver imageObserver = null;
        double targetWidth = (double)srcImage.getWidth(imageObserver) * ratio;
        double targetHeight = (double)srcImage.getHeight(imageObserver) * ratio;
        return AwtImageUtil.resizeImage(srcImage, targetWidth, targetHeight, true);
    }

    public static BufferedImage permeation(BufferedImage bufferedImage, int color) throws Exception {
        int w = bufferedImage.getWidth();
        int h = bufferedImage.getHeight();
        BufferedImage img2 = new BufferedImage(w, h, 2);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                if (bufferedImage.getRGB(x, y) == color) {
                    img2.setRGB(x, y, 0);
                } else {
                    img2.setRGB(x, y, bufferedImage.getRGB(x, y));
                }
                ++x;
            }
            ++y;
        }
        return img2;
    }

    public static BufferedImage permeation(BufferedImage bufferedImage, Color color, int diff) throws Exception {
        int w = bufferedImage.getWidth();
        int h = bufferedImage.getHeight();
        BufferedImage img2 = new BufferedImage(w, h, 2);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int gb;
                int gg;
                Color tmpColor = new Color(bufferedImage.getRGB(x, y));
                int gr = Math.abs(color.getRed() - tmpColor.getRed());
                if (gr + (gg = Math.abs(color.getGreen() - tmpColor.getGreen())) + (gb = Math.abs(color.getBlue() - tmpColor.getBlue())) <= diff) {
                    img2.setRGB(x, y, 0);
                } else {
                    img2.setRGB(x, y, bufferedImage.getRGB(x, y));
                }
                ++x;
            }
            ++y;
        }
        return img2;
    }

    public static BufferedImage extractImage(Image srcImage, double targetWidth, double targetHeight) {
        ImageObserver imageObserver = null;
        double srcWidth = srcImage.getWidth(imageObserver);
        double srcHeight = srcImage.getHeight(imageObserver);
        double wRatio = targetWidth / srcWidth;
        double hRatio = targetHeight / srcHeight;
        double ratio = Math.max(wRatio, hRatio);
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.width = srcWidth * ratio;
        rectangle.height = srcHeight * ratio;
        rectangle.x = (targetWidth - rectangle.width) / 2.0;
        rectangle.y = (targetHeight - rectangle.height) / 2.0;
        Rectangle RectangleInt = AwtImageUtil.toRectangleInt(rectangle);
        Image tempImage = srcImage.getScaledInstance(RectangleInt.width, -1, 4);
        BufferedImage bufferedImage1 = new BufferedImage(BcNumberUtil.toIntRoundHalfUp(targetWidth), BcNumberUtil.toIntRoundHalfUp(targetHeight), 1);
        Graphics2D g2d = bufferedImage1.createGraphics();
        AwtImageUtil.setRenderingHint(g2d);
        g2d.drawImage(tempImage, RectangleInt.x, RectangleInt.y, imageObserver);
        return bufferedImage1;
    }

    public static IIOMetadata createMetadata(ImageWriter imageWriter, ImageWriteParam imageWriteParam, int resolution) throws IIOInvalidTreeException {
        ImageTypeSpecifier imageTypeSpecifier = imageWriteParam.getDestinationType();
        IIOMetadata iioMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        TIFFDirectory tiffDirectory = TIFFDirectory.createFromMetadata((IIOMetadata)iioMetadata);
        BaselineTIFFTagSet baseTagSet = BaselineTIFFTagSet.getInstance();
        TIFFTag tagXRes = baseTagSet.getTag(282);
        TIFFTag tagYRes = baseTagSet.getTag(283);
        TIFFField fieldXRes = new TIFFField(tagXRes, 5, 1, (Object)new long[][]{{resolution, 1L}});
        TIFFField fieldYRes = new TIFFField(tagYRes, 5, 1, (Object)new long[][]{{resolution, 1L}});
        tiffDirectory.addTIFFField(fieldXRes);
        tiffDirectory.addTIFFField(fieldYRes);
        return tiffDirectory.getAsMetadata();
    }

    public static BufferedImage loadImage(InputStream is, Iterator<ImageReader> imageReadersIterator) throws Exception {
        while (imageReadersIterator.hasNext()) {
            ImageReader imageReader = imageReadersIterator.next();
            try {
                imageReader.setInput(new MemoryCacheImageInputStream(is));
                BufferedImage bufferedImage = imageReader.read(0);
                return bufferedImage;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        return null;
    }

    public static BufferedImage loadImage(InputStream is, String fileExtention) throws Exception {
        Iterator<ImageReader> imageReadersIterator = ImageIO.getImageReadersBySuffix(fileExtention);
        if (!imageReadersIterator.hasNext()) {
            throw new Exception("No imageReader");
        }
        return AwtImageUtil.loadImage(is, imageReadersIterator);
    }

    public static BufferedImage loadImage(File file) throws Exception {
        FileInputStream is1 = new FileInputStream(file);
        return AwtImageUtil.loadImage((InputStream)is1, BcFileUtil.getExtention(file));
    }

    public static BufferedImage loadImageByImageIO(File file) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(file);
        return bufferedImage;
    }

    public static BufferedImage toImage(byte[] bytes, String fileExtention) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return AwtImageUtil.loadImage((InputStream)bais, fileExtention);
    }

    public static void writeTiff(BufferedImage bufferedImage, int resolution, String compressionType, float compressionQuality, Object output) throws Exception {
        TIFFImageWriterSpi tiffImageWriterSpi = new TIFFImageWriterSpi();
        ImageWriter imageWriter = tiffImageWriterSpi.createWriterInstance();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        IIOMetadata iioMetadata = AwtImageUtil.createMetadata(imageWriter, imageWriteParam, resolution);
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionType(compressionType);
        imageWriteParam.setCompressionQuality(compressionQuality);
        try (ImageOutputStream imageOs = ImageIO.createImageOutputStream(output);){
            imageWriter.setOutput(imageOs);
            IIOImage iioImage = new IIOImage(bufferedImage, null, iioMetadata);
            imageWriter.write(null, iioImage, imageWriteParam);
        }
    }

    public static void writeTiff(BufferedImage bufferedImage, int resolution, Object output) throws Exception {
        AwtImageUtil.writeTiff(bufferedImage, resolution, "CCITT T.4", 0.5f, output);
    }

    public static BufferedImage rotate(BufferedImage sourceImage, int angle) throws Exception {
        BufferedImage outputImage;
        int imageType = AwtImageUtil.getImageType(sourceImage);
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        switch (angle) {
            case 90: 
            case 270: {
                outputImage = new BufferedImage(height, width, imageType);
                break;
            }
            case 180: {
                outputImage = new BufferedImage(width, height, imageType);
                break;
            }
            default: {
                String msg = BcMessageCreator.getInstance().bindMessage("\u6307\u5b9a\u3057\u305f\u3055\u308c\u305f\u89d2\u5ea6 {0} \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u305b\u3093\u3002", angle);
                throw new Exception(msg);
            }
        }
        Graphics2D g2d = outputImage.createGraphics();
        AffineTransform afRotate = new AffineTransform();
        AffineTransform afTrans = new AffineTransform();
        afRotate.rotate(Math.toRadians(angle), 0.0, 0.0);
        switch (angle) {
            case 90: {
                afTrans.translate(height, 0.0);
                break;
            }
            case 180: {
                afTrans.translate(width, height);
                break;
            }
            case 270: {
                afTrans.translate(0.0, width);
            }
        }
        afTrans.concatenate(afRotate);
        g2d.drawImage(sourceImage, afTrans, null);
        return outputImage;
    }
}

