/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.awt;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import java.awt.Color;

public class AwtColorUtil {
    public static final int RGB_MIN = 0;
    public static final int RGB_MAX = 255;

    private AwtColorUtil() {
    }

    public static boolean compare(Color color1, Color color2) {
        if (color1.getRed() != color2.getRed()) {
            return false;
        }
        if (color1.getGreen() != color2.getGreen()) {
            return false;
        }
        return color1.getBlue() == color2.getBlue();
    }

    public static Color toBisidesColor(Color color1) {
        int red = 255 - color1.getRed();
        int green = 255 - color1.getGreen();
        int blue = 255 - color1.getBlue();
        Color color2 = new Color(red, green, blue);
        return color2;
    }

    public static Color hexToColor(String hex) {
        int intValue = Integer.parseInt(hex, 16);
        Color color = new Color(intValue);
        return color;
    }

    public static String toHex(Color color) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.fillPrefix(Integer.toString(color.getRed(), 16).toUpperCase(), 2, '0'));
        sb.append(BcStringUtil.fillPrefix(Integer.toString(color.getGreen(), 16).toUpperCase(), 2, '0'));
        sb.append(BcStringUtil.fillPrefix(Integer.toString(color.getBlue(), 16).toUpperCase(), 2, '0'));
        return sb.toString();
    }

    public static boolean chackRGB(int elem) {
        return elem >= 0 && elem <= 255;
    }

    public static boolean chackRGB(int ... rgb) {
        int i = 0;
        while (i < rgb.length) {
            if (!AwtColorUtil.chackRGB(rgb[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int colorChange(int elem1, int diff) {
        int elem2 = elem1 + diff;
        if (elem2 < 0) {
            elem2 = 0;
        } else if (elem2 > 255) {
            elem2 = 255;
        }
        return elem2;
    }

    public static int[] colorChange(int[] rgb1, int diff) {
        int[] rgb2 = new int[3];
        int i = 0;
        while (i < rgb1.length) {
            rgb2[i] = AwtColorUtil.colorChange(rgb1[i], diff);
            ++i;
        }
        return rgb2;
    }

    public static int[] colorChange(int r, int g, int b, int diff) {
        int[] rgb = new int[]{r, g, b};
        return AwtColorUtil.colorChange(rgb, diff);
    }

    public static int[] colorChange(Color baseColor, int diff) {
        return AwtColorUtil.colorChange(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), diff);
    }

    public static Color toColor(Color baseColor, int diff) {
        int[] rgb = AwtColorUtil.colorChange(baseColor, diff);
        if (!AwtColorUtil.chackRGB(rgb)) {
            BcLogUtil.debug("isRangeOrver");
            rgb = AwtColorUtil.colorChange(baseColor, diff * -1);
        }
        Color newColor = new Color(rgb[0], rgb[1], rgb[2]);
        return newColor;
    }

    public static Color toComplementaryColor(Color baseColor, int diff) {
        int max = BcNumberUtil.max(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue());
        int min = BcNumberUtil.min(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue());
        int x = max + min;
        int r = x - baseColor.getRed();
        int g = x - baseColor.getGreen();
        int b = x - baseColor.getBlue();
        Color newColor = new Color(r, g, b);
        return newColor;
    }

    public static Color toSelectionColor(Color baseColor, int diff) {
        int sum = baseColor.getRed() + baseColor.getGreen() + baseColor.getBlue();
        int average = sum / 3;
        Color newColor = null;
        newColor = average > 128 ? Color.BLUE : Color.CYAN;
        return newColor;
    }
}

