/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcInteger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BcIndexer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5202755299209975018L;
    private List<BcInteger> indexList;

    public BcIndexer(int size) {
        if (size > 0) {
            this.indexList = new ArrayList<BcInteger>(size);
            this.addIndex(size);
        } else {
            this.indexList = new ArrayList<BcInteger>();
        }
    }

    public BcIndexer() {
        this.indexList = new ArrayList<BcInteger>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            this.indexList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(int indexCount) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int modelIndex = this.indexList.size();
            int i = 0;
            while (i < indexCount) {
                BcInteger bcInteger = new BcInteger(modelIndex + i);
                this.indexList.add(bcInteger);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(int indexCount, int modelIndex) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int i = 0;
            while (i < indexCount) {
                BcInteger bcInteger = new BcInteger(modelIndex);
                this.indexList.add(bcInteger);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIndex(int viewIndex, int modelIndex) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            this.indexList.add(viewIndex, new BcInteger(modelIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertIndex(int viewIndex) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int modelIndex = this.indexList.size();
            this.insertIndex(viewIndex, modelIndex);
            return modelIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(int viewIndex, int modelIndex) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            BcInteger lbInteger = this.indexList.get(viewIndex);
            lbInteger.value = modelIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeIndex(int index1, int index2) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int size = index2 - index1 + 1;
            int arraySize = this.indexList.size();
            int arrayIndex = -1;
            int i = 0;
            while (i < arraySize) {
                arrayIndex = arraySize - i - 1;
                if (this.toModelIndex(arrayIndex) >= index1 && this.toModelIndex(arrayIndex) <= index2) {
                    this.indexList.remove(arrayIndex);
                } else if (this.toModelIndex(arrayIndex) > index2) {
                    this.indexList.get((int)arrayIndex).value = this.toModelIndex(arrayIndex) - size;
                }
                ++i;
            }
            return size;
        }
    }

    public int removeIndex(int index) {
        return this.removeIndex(index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toModelIndex(int viewIndex) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            return this.indexList.get((int)viewIndex).value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toModelIndexs(int[] viewIndex) {
        int[] modelIndexs = new int[viewIndex.length];
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int i = 0;
            while (i < viewIndex.length) {
                modelIndexs[i] = this.toModelIndex(viewIndex[i]);
                ++i;
            }
            return modelIndexs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toViewIndex(int modelIndex) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int viewIndex = -1;
            int i = 0;
            while (i < this.indexList.size()) {
                if (this.indexList.get((int)i).value == modelIndex) {
                    viewIndex = i;
                    break;
                }
                ++i;
            }
            return viewIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toViewIndexs(int[] modelIndexs) {
        int[] viewIndex = new int[modelIndexs.length];
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int i = 0;
            while (i < modelIndexs.length) {
                viewIndex[i] = this.toViewIndex(modelIndexs[i]);
                ++i;
            }
            return viewIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            return this.indexList.size();
        }
    }

    public List<BcInteger> getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List<BcInteger> indexList) {
        this.indexList = indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            BcIndexer obj = new BcIndexer(0);
            int i = 0;
            while (i < this.indexList.size()) {
                obj.indexList.add((BcInteger)this.indexList.get(i).clone());
                ++i;
            }
            return obj;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.indexList.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(i) + "=" + this.indexList.get((int)i).value);
            ++i;
        }
        return sb.toString();
    }
}

