/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import java.util.Arrays;
import java.util.List;

final class BcCsvUtil2 {
    private BcCsvUtil2() {
    }

    public static MmdField createMmdFieldForCSV(String columnName) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.columnName = BcStringUtil.toString(columnName);
        return mmdField;
    }

    public static BcTableColumn createTableColumnForCSV(String columnName) throws Exception {
        MmdField mmdField = BcCsvUtil2.createMmdFieldForCSV(columnName);
        BcTableColumn tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        return tableColumn;
    }

    public static BcTableColumn addColumnNameForCSV(BcTableColumnModel tableColumnModel, String columnName) throws Exception {
        BcTableColumn tableColumn = BcCsvUtil2.createTableColumnForCSV(columnName);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        return tableColumn;
    }

    public static void addColumnNameForCSV(BcTableColumnModel tableColumnModel, List<? extends String> columnNameList) throws Exception {
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            BcCsvUtil2.addColumnNameForCSV(tableColumnModel, columnName);
            ++i;
        }
    }

    public static void addColumnNameForCSV(BcTableColumnModel tableColumnModel, String ... columnNames) throws Exception {
        List<String> columnNameList = Arrays.asList(columnNames);
        BcCsvUtil2.addColumnNameForCSV(tableColumnModel, columnNameList);
    }
}

