/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil2;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.text.StringEscapeUtils;

public class BcCsvUtil {
    private static CSVFormat csvFormat_RFC4180;

    private BcCsvUtil() {
    }

    public static CSVFormat getCsvFormat_RFC4180() throws Exception {
        if (csvFormat_RFC4180 != null) {
            return csvFormat_RFC4180;
        }
        CSVFormat.Builder formatBuilder = CSVFormat.RFC4180.builder();
        formatBuilder.setSkipHeaderRecord(false);
        csvFormat_RFC4180 = formatBuilder.build();
        return csvFormat_RFC4180;
    }

    public static void csvToTable(CSVFormat csvFormat, Reader reader, BcTableModel tableModel, int headerRowNumber) throws Exception {
        BcTableColumnModel tableColumnModel = tableModel.getTableColumnModel();
        CSVParser csvRecords = csvFormat.parse(reader);
        for (CSVRecord csvRecord : csvRecords) {
            ArrayList<String> tableRow = new ArrayList<String>();
            int i = 0;
            while (i < csvRecord.size()) {
                String value = csvRecord.get(i);
                tableRow.add(value);
                ++i;
            }
            if (csvRecord.getRecordNumber() < (long)headerRowNumber) continue;
            if (csvRecord.getRecordNumber() == (long)headerRowNumber) {
                BcCsvUtil2.addColumnNameForCSV(tableColumnModel, tableRow);
                continue;
            }
            int gap = tableRow.size() - tableColumnModel.getColumnCount();
            if (gap > 0) {
                int i2 = 0;
                while (i2 < gap) {
                    MmdField mmdField = BcCsvUtil2.createMmdFieldForCSV(Integer.toString(tableColumnModel.getColumnCount() + 1));
                    BcTableColumn tableColumn = new BcTableColumn(tableColumnModel.getColumnCount());
                    tableColumn.setMmdField(mmdField);
                    tableColumnModel.addColumn(tableColumn);
                    ++i2;
                }
            }
            tableModel.addRow(tableRow);
        }
    }

    public static BcTableModel csvToTable(CSVFormat csvFormat, Reader reader, int headerRowNumber) throws Exception {
        BcTableModel tableModel = new BcTableModel();
        BcCsvUtil.csvToTable(csvFormat, reader, tableModel, headerRowNumber);
        return tableModel;
    }

    public static BcTableModel csvToTable(Reader reader, int headerRowNumber) throws Exception {
        CSVFormat csvFormat = BcCsvUtil.getCsvFormat_RFC4180();
        return BcCsvUtil.csvToTable(csvFormat, reader, headerRowNumber);
    }

    public static BcTableModel csvToTable(CSVFormat csvFormat, String csv, int headerRowNumber) throws Exception {
        CharArrayReader charArrayReader = new CharArrayReader(csv.toCharArray());
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        return BcCsvUtil.csvToTable(csvFormat, bufferedReader, headerRowNumber);
    }

    public static BcTableModel csvToTable(String csv, int headerRowNumber) throws Exception {
        CSVFormat csvFormat = BcCsvUtil.getCsvFormat_RFC4180();
        return BcCsvUtil.csvToTable(csvFormat, csv, headerRowNumber);
    }

    public static List<String> parseCsvRow(String csvRow, boolean emptyEnable) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(csvRow)) {
            if (emptyEnable) {
                return valueList;
            }
            throw new Exception("csvRow=" + csvRow);
        }
        CharArrayReader charArrayReader = new CharArrayReader(csvRow.toCharArray());
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        CSVFormat csvFormat = BcCsvUtil.getCsvFormat_RFC4180();
        CSVParser csvRecords = csvFormat.parse((Reader)bufferedReader);
        Iterator iterator = csvRecords.iterator();
        if (iterator.hasNext()) {
            CSVRecord csvRecord = (CSVRecord)iterator.next();
            int i = 0;
            while (i < csvRecord.size()) {
                String value = csvRecord.get(i);
                valueList.add(value);
                ++i;
            }
        }
        return valueList;
    }

    public static String toCsv(Collection<String> collection, boolean doEescape, String delimiter) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String str;
            String newStr = str = iterator.next();
            if (doEescape) {
                newStr = StringEscapeUtils.escapeCsv((String)str);
            }
            newList.add(newStr);
        }
        return BcStringUtil.marge(collection, delimiter).toString();
    }

    public static String toCsv(Collection<String> collection, boolean doEescape) {
        return BcCsvUtil.toCsv(collection, doEescape, BcStringUtil.COMMA_STR);
    }

    public static String toCsv(Collection<String> collection) {
        return BcCsvUtil.toCsv(collection, true);
    }

    public static int getElementIndex(String csvRow, Object element) throws Exception {
        List<String> elementList = BcCsvUtil.parseCsvRow(csvRow, true);
        int i = 0;
        while (i < elementList.size()) {
            String element2 = elementList.get(i);
            if (element.toString().equals(element2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean hasElement(String csvRow, Object element) throws Exception {
        return BcCsvUtil.getElementIndex(csvRow, element) >= 0;
    }
}

