/*
 * Decompiled with CFR 0.152.
 */
package ext.base.runtime;

import ext.base.core.BcLangUtil;
import ext.base.io.BcFileFilter;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.runtime.BcRuntimeUtil_FileCircuit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class BcRuntimeUtil {
    public static final Class[] addURLParameters = new Class[]{URL.class};
    public static final String ATTRIBUTE_MainClass = "Main-Class";
    public static final int OS_TYPE_null = -1;
    public static final int OS_TYPE_linux = 11;
    public static final int OS_TYPE_mac = 21;
    public static final int OS_TYPE_windows = 31;
    protected static int osType = -1;

    private BcRuntimeUtil() {
    }

    public static int getProcessId() {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        String name = rt.getName();
        int pid = -1;
        if (name.matches("\\d+@.*")) {
            pid = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        return pid;
    }

    public static boolean classExist(String className) {
        boolean classExist = false;
        try {
            Class.forName(className);
            classExist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return classExist;
    }

    public static URLClassLoader addClassPath(ClassLoader parentClassLoader, URL[] urls) throws Exception {
        URLClassLoader urlClassLoader = null;
        if (parentClassLoader instanceof URLClassLoader) {
            urlClassLoader = (URLClassLoader)parentClassLoader;
        } else {
            urlClassLoader = URLClassLoader.newInstance(urls, parentClassLoader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
        }
        String methodName = "addURL";
        Method addURLMethod = URLClassLoader.class.getDeclaredMethod(methodName, addURLParameters);
        addURLMethod.setAccessible(true);
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            addURLMethod.invoke((Object)urlClassLoader, url);
            ++i;
        }
        return urlClassLoader;
    }

    public static URLClassLoader addClassPath(ClassLoader classLoader, URL url) throws Exception {
        return BcRuntimeUtil.addClassPath(classLoader, new URL[]{url});
    }

    public static URLClassLoader addClassPath(ClassLoader classLoader, File dir) throws Exception {
        URL[] urls = BcRuntimeUtil.createJarUrls(dir);
        return BcRuntimeUtil.addClassPath(classLoader, urls);
    }

    public static URL getResourceUrl(Class clazz) throws Exception {
        URL resourceUrl = clazz.getResource(BcLangUtil.toClassFileName(clazz));
        return resourceUrl;
    }

    public static URL getJarFileUrl(URL url) throws Exception {
        URLConnection urlConnection = url.openConnection();
        URL jarFileUrl = null;
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            jarFileUrl = jarURLConnection.getJarFileURL();
        }
        return jarFileUrl;
    }

    public static URL getJarFileUrl(Class clazz) throws Exception {
        URL jarUrl = BcRuntimeUtil.getResourceUrl(clazz);
        if (jarUrl == null) {
            return null;
        }
        return BcRuntimeUtil.getJarFileUrl(jarUrl);
    }

    public static URL getStartJarUrl() throws Exception {
        String sunJavaCommand = System.getProperty("sun.java.command");
        File file = new File(sunJavaCommand);
        URL url = null;
        if (file.exists()) {
            url = file.toURI().toURL();
        }
        return url;
    }

    public static List<URL> createJarUrlList(File dir) throws Exception {
        BcFileFilter fileFilter = new BcFileFilter();
        fileFilter.setHiddenEnable(false);
        fileFilter.addAcceptPattern(".*");
        ArrayList<File> fileList = new ArrayList<File>();
        BcRuntimeUtil_FileCircuit fileCircuit = new BcRuntimeUtil_FileCircuit(fileList);
        fileCircuit.setFileFilter(fileFilter);
        fileCircuit.start(dir);
        List<URL> urlList = BcFileUtil.toUrlList(fileList);
        return urlList;
    }

    public static URL[] createJarUrls(File dir) throws Exception {
        List<URL> urlList = BcRuntimeUtil.createJarUrlList(dir);
        URL[] urls = urlList.toArray(new URL[0]);
        return urls;
    }

    public static Class getMainClass() throws Exception {
        String sunJavaCommand = System.getProperty("sun.java.command");
        String[] texts = sunJavaCommand.split("[\\s]+");
        Class<?> clazz = Class.forName(texts[0]);
        return clazz;
    }

    public static String getMainClassValue(Class clazz) throws Exception {
        Manifest manifest = BcRuntimeUtil.getManifest(clazz);
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue(ATTRIBUTE_MainClass);
    }

    public static Manifest getManifest(Class clazz) throws Exception {
        URL resourceUrl = BcRuntimeUtil.getResourceUrl(clazz);
        String s = resourceUrl.toExternalForm();
        String jar = s.substring(0, s.lastIndexOf(clazz.getPackage().getName().replace('.', '/')));
        URL manifestUrl = new URL(String.valueOf(jar) + "META-INF/MANIFEST.MF");
        Manifest manifest = null;
        try {
            InputStream inputStream = manifestUrl.openStream();
            manifest = new Manifest(inputStream);
        }
        catch (IOException ex) {
            return null;
        }
        return manifest;
    }

    public static boolean isJava_1_7() {
        String javaVersion = System.getProperties().getProperty("java.version");
        return javaVersion.startsWith("1.7");
    }

    public static boolean isJava_1_8() {
        String javaVersion = System.getProperties().getProperty("java.version");
        return javaVersion.startsWith("1.8");
    }

    public static int getOsType() {
        if (osType >= 11) {
            return osType;
        }
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.indexOf("linux") >= 0) {
            osType = 11;
        } else if (osName.indexOf("mac") >= 0) {
            osType = 21;
        } else if (osName.indexOf("windows") >= 0) {
            osType = 31;
        }
        return osType;
    }

    public static void manifestLog(Manifest manifest) throws Exception {
        Map<String, Attributes> map = manifest.getEntries();
        for (Map.Entry<String, Attributes> mapEntry : map.entrySet()) {
            BcLogUtil.debug(mapEntry.getKey() + "=" + mapEntry.getValue());
        }
    }

    public static File getUserHomeDir() {
        File dir = new File(System.getProperty("user.home"));
        return dir;
    }

    public static File getUserDir() {
        File dir = new File(System.getProperty("user.dir"));
        return dir;
    }
}

