/*
 * Decompiled with CFR 0.152.
 */
package ext.base.mmd;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcCloneUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MmdModel
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5536967804112713946L;
    public int id;
    public String modelName;
    public String javaClassName;
    public String tableName;
    public String displayName;
    public String wordCode;
    public String note;
    public String displayNameWork;
    public List<MmdField> fieldList = new ArrayList<MmdField>();
    public Map<String, MmdIndex> indexMap = new HashMap<String, MmdIndex>();
    public String primaryIndexName;

    public MmdModel() {
        this.clear();
    }

    public void clear() {
        this.id = 0;
        this.modelName = null;
        this.javaClassName = null;
        this.tableName = null;
        this.displayName = null;
        this.wordCode = null;
        this.note = null;
        this.displayNameWork = null;
        this.fieldList.clear();
        this.indexMap.clear();
        this.primaryIndexName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setField(MmdField mmdField) {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            int gap = mmdField.ordinalPosition - this.fieldList.size();
            if (gap > 0) {
                int i = 0;
                while (i < gap) {
                    this.fieldList.add(null);
                    ++i;
                }
            }
            mmdField.tableColumnName = MmdUtil.createTableColumnName(this.tableName, mmdField.columnName);
            this.fieldList.set(mmdField.ordinalPosition - 1, mmdField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmdField removeField(int index) {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            MmdField mmdField = this.fieldList.remove(index);
            return mmdField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(MmdField mmdField) {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            mmdField.ordinalPosition = this.fieldList.size() + 1;
            this.setField(mmdField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmdField getField(int index) {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            return this.fieldList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldCount() {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            return this.fieldList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmdField getFieldByColumnName(String columnName) {
        if (BcStringUtil.isEmpty(columnName)) {
            return null;
        }
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            int i = 0;
            while (i < this.getFieldCount()) {
                MmdField mmdField = this.getField(i);
                if (columnName.equalsIgnoreCase(mmdField.columnName)) {
                    return mmdField;
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldIndexByName(String fieldName) {
        int resValue = -1;
        if (BcStringUtil.isEmpty(fieldName)) {
            return resValue;
        }
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            int i = 0;
            while (i < this.getFieldCount()) {
                MmdField field = this.getField(i);
                if (fieldName.equals(field.fieldName)) {
                    resValue = i;
                    break;
                }
                ++i;
            }
            return resValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(MmdIndex mmdIndex) {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            this.indexMap.put(mmdIndex.name, mmdIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmdIndex getIndex(String indexName) {
        List<MmdField> list = this.fieldList;
        synchronized (list) {
            return this.indexMap.get(indexName);
        }
    }

    public MmdIndex getPrimaryIndex() {
        MmdIndex mmdIndex = null;
        if (!BcStringUtil.isEmpty(this.primaryIndexName)) {
            mmdIndex = this.getIndex(this.primaryIndexName);
        }
        return mmdIndex;
    }

    public String getProvisionalDisplayName() throws Exception {
        if (!BcStringUtil.isEmpty(this.displayNameWork)) {
            return this.displayNameWork;
        }
        if (!BcStringUtil.isEmpty(this.displayName)) {
            return this.displayName;
        }
        if (!BcStringUtil.isEmpty(this.modelName)) {
            return this.modelName;
        }
        if (!BcStringUtil.isEmpty(this.tableName)) {
            return this.tableName;
        }
        return "null";
    }

    public Object clone() throws CloneNotSupportedException {
        return BcCloneUtil.createClone(this);
    }
}

