/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.core.BcTimeUtil_JP;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BcTimeParser {
    protected final int MODE_init = 0;
    protected final int MODE_era = 11;
    protected final int MODE_yyyy = 12;
    protected final int MODE_MM = 13;
    protected final int MODE_dd = 14;
    protected final int MODE_ampm = 21;
    protected final int MODE_HH = 22;
    protected final int MODE_mm = 23;
    protected final int MODE_ss = 24;
    protected final int MODE_SSS = 25;
    protected List<Character> dateDelimiterList = new ArrayList<Character>();
    protected List<Character> timeDelimiterList = new ArrayList<Character>();

    public BcTimeParser() {
        this.dateDelimiterList.add(Character.valueOf('/'));
        this.dateDelimiterList.add(Character.valueOf('-'));
        this.dateDelimiterList.add(Character.valueOf('.'));
        this.timeDelimiterList.add(Character.valueOf(':'));
        this.dateDelimiterList.add(Character.valueOf('\u2010'));
        this.dateDelimiterList.add(Character.valueOf('\u2011'));
        this.dateDelimiterList.add(Character.valueOf('\u2012'));
        this.dateDelimiterList.add(Character.valueOf('\u2013'));
        this.dateDelimiterList.add(Character.valueOf('\u2014'));
        this.dateDelimiterList.add(Character.valueOf('\u2015'));
        this.dateDelimiterList.add(Character.valueOf('\u30fb'));
        this.dateDelimiterList.add(Character.valueOf('\uff0d'));
        this.dateDelimiterList.add(Character.valueOf('\uff0f'));
        this.timeDelimiterList.add(Character.valueOf('\uff1a'));
    }

    public Calendar parseToCalendar(String src, int y2Base, boolean isActualMaximum) throws Exception {
        Calendar calendar = null;
        try {
            TimeStructure timeStructure = this.parseToStructure(src);
            calendar = this.parseToCalendar(timeStructure, y2Base, isActualMaximum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }

    public TimeStructure parseToStructure(String src) throws Exception {
        String src2 = BcStringUtil.trim(src);
        src2 = BcStringUtil.toLatinBasic(src2, 2).toString();
        TimeStructure timeStructure = new TimeStructure();
        StringBuilder sb = new StringBuilder();
        int pos = -1;
        char aCHar = '\u0000';
        int mode = 11;
        boolean isLast = false;
        boolean b1 = false;
        while (++pos < src2.length()) {
            if (pos == src2.length() - 1) {
                isLast = true;
            }
            aCHar = src2.charAt(pos);
            switch (mode) {
                case 11: {
                    if (aCHar >= '0' && aCHar <= '9') {
                        timeStructure.era = sb.toString();
                        sb.delete(0, sb.length());
                        sb.append(aCHar);
                        mode = 12;
                        b1 = false;
                        break;
                    }
                    if (aCHar == ' ' || aCHar == ' ') break;
                    sb.append(aCHar);
                    break;
                }
                case 12: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isDateSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u5e74') {
                        b1 = true;
                    }
                    if (b1) {
                        timeStructure.year = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 13;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        timeStructure.year = sb.toString();
                        sb.delete(0, sb.length());
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 13: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isDateSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u6708') {
                        b1 = true;
                    }
                    if (b1) {
                        timeStructure.month = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 14;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 14: {
                    if (BcStringUtil.isSpace(aCHar)) {
                        if (sb.length() <= 0) break;
                        b1 = true;
                    } else if (this.isDateSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u65e5') {
                        b1 = true;
                    }
                    if (b1) {
                        timeStructure.day = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 21;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        timeStructure.day = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 21;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 21: {
                    if (BcStringUtil.isSpace(aCHar) || aCHar == '\u65e5') break;
                    if (aCHar >= '0' && aCHar <= '9') {
                        timeStructure.ampm = sb.toString();
                        sb.delete(0, sb.length());
                        sb.append(aCHar);
                        mode = 22;
                        b1 = false;
                        break;
                    }
                    if (aCHar == ' ' || aCHar == ' ') break;
                    sb.append(aCHar);
                    break;
                }
                case 22: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isTimeSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u6642') {
                        b1 = true;
                    }
                    if (b1) {
                        timeStructure.hour = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 23;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        timeStructure.hour = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 23;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 23: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isTimeSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u5206') {
                        b1 = true;
                    }
                    if (b1) {
                        timeStructure.minute = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 24;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        timeStructure.minute = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 24;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 24: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (this.isTimeSep(aCHar)) {
                        b1 = true;
                    } else if (aCHar == '\u79d2') {
                        b1 = true;
                    }
                    if (b1) {
                        timeStructure.second = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 25;
                        b1 = false;
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        timeStructure.second = sb.toString();
                        sb.delete(0, sb.length());
                        mode = 25;
                        b1 = false;
                        break;
                    }
                    sb.append(aCHar);
                    break;
                }
                case 25: {
                    if (BcStringUtil.isSpace(aCHar)) break;
                    if (b1) {
                        timeStructure.milliSecnd = sb.toString();
                        sb.delete(0, sb.length());
                        break;
                    }
                    if (isLast) {
                        sb.append(aCHar);
                        timeStructure.milliSecnd = sb.toString();
                        sb.delete(0, sb.length());
                        break;
                    }
                    sb.append(aCHar);
                }
            }
        }
        StringBuilder tmpSb = new StringBuilder(10);
        if (!BcStringUtil.isEmpty(timeStructure.year)) {
            tmpSb.append(timeStructure.year);
        }
        if (!BcStringUtil.isEmpty(timeStructure.month)) {
            tmpSb.append(timeStructure.month);
        }
        if (!BcStringUtil.isEmpty(timeStructure.day)) {
            tmpSb.append(timeStructure.day);
        }
        if (tmpSb.toString().equals(BcStringUtil.fill("0", tmpSb.length()))) {
            return null;
        }
        if (tmpSb.toString().equals(BcStringUtil.fill("9", tmpSb.length()))) {
            return null;
        }
        if (BcStringUtil.equals(timeStructure.year, tmpSb.toString()) && (tmpSb.length() == 6 || tmpSb.length() == 8)) {
            int posMM = tmpSb.length() - 4;
            timeStructure.year = tmpSb.substring(0, posMM);
            timeStructure.month = tmpSb.substring(posMM, posMM + 2);
            timeStructure.day = tmpSb.substring(posMM + 2, posMM + 4);
        }
        return timeStructure;
    }

    public Calendar parseToCalendar(TimeStructure timeStructure, int y2Base, boolean isActualMaximum) throws Exception {
        int eraStartDate = -1;
        if (!BcStringUtil.isEmpty(timeStructure.era) && (eraStartDate = BcTimeUtil_JP.getEraStartDateByAny(timeStructure.era)) <= 0) {
            return null;
        }
        int yyyy = BcNumberUtil.parseInteger(timeStructure.year);
        if (eraStartDate <= 0) {
            yyyy += BcTimeUtil.yyToYbase(yyyy, y2Base);
        } else {
            Calendar tmpCalendar = BcTimeUtil.toCalendar(eraStartDate);
            yyyy += tmpCalendar.get(1) - 1;
        }
        int MM = BcNumberUtil.parseInteger(timeStructure.month);
        int dd = BcNumberUtil.parseInteger(timeStructure.day);
        Calendar resCalendar = null;
        if (isActualMaximum) {
            Calendar tmpCalendar1 = BcTimeUtil.createCalendar();
            tmpCalendar1.set(yyyy, MM - 1, 1, 0, 0, 0);
            tmpCalendar1.set(14, 0);
            Calendar tmpCalendar2 = BcTimeUtil.toMonthEnd(tmpCalendar1);
            if (tmpCalendar2.get(5) >= dd) {
                tmpCalendar1.set(yyyy, MM - 1, dd, 0, 0, 0);
                resCalendar = tmpCalendar1;
            } else {
                tmpCalendar1.set(yyyy, MM - 1, tmpCalendar2.get(5), 0, 0, 0);
                resCalendar = tmpCalendar1;
            }
        } else {
            Calendar tmpCalendar = BcTimeUtil.createCalendar();
            tmpCalendar.clear();
            tmpCalendar.set(yyyy, MM - 1, dd);
            resCalendar = tmpCalendar;
        }
        if (!BcStringUtil.isEmpty(timeStructure.hour)) {
            int HH = BcNumberUtil.parseInt(timeStructure.hour, 0);
            HH = BcTimeUtil.toHourOfDay(HH, timeStructure.ampm);
            int mm = BcNumberUtil.parseInt(timeStructure.minute, 0);
            int ss = BcNumberUtil.parseInt(timeStructure.second, 0);
            int SSS = BcNumberUtil.parseInt(timeStructure.milliSecnd, 0);
            resCalendar.set(11, HH);
            resCalendar.set(12, mm);
            resCalendar.set(13, ss);
            resCalendar.set(14, SSS);
        }
        return resCalendar;
    }

    protected boolean isDateSep(char aCahr) {
        return this.dateDelimiterList.indexOf(Character.valueOf(aCahr)) >= 0;
    }

    protected boolean isTimeSep(char aCahr) {
        return this.timeDelimiterList.indexOf(Character.valueOf(aCahr)) >= 0;
    }

    public StringBuilder createLog(TimeStructure timeStructure) {
        StringBuilder sb = new StringBuilder();
        sb.append("era=" + timeStructure.era);
        sb.append(" year=" + timeStructure.year);
        sb.append(" month=" + timeStructure.month);
        sb.append(" day=" + timeStructure.day);
        sb.append(" ampm=" + timeStructure.ampm);
        sb.append(" hour=" + timeStructure.hour);
        sb.append(" minute=" + timeStructure.minute);
        sb.append(" second=" + timeStructure.second);
        sb.append(" milliSecnd=" + timeStructure.milliSecnd);
        return sb;
    }

    public class TimeStructure {
        String era;
        String year;
        String month;
        String day;
        String ampm;
        String hour;
        String minute;
        String second;
        String milliSecnd;
    }
}

