/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

import ext.base.core.BcLangUtil;
import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public final class BcStringUtil {
    public static final char NULL = '\u0000';
    public static final char BEL = '\u0007';
    public static final char BACKSPACE = '\b';
    public static final char HORIZONTAL_TAB = '\t';
    public static final String HORIZONTAL_TAB_STR = Character.toString('\t');
    public static final char LINE_FEED = '\n';
    public static final String LINE_FEED_STR = Character.toString('\n');
    public static final char VERTICAL_TAB = '\u000b';
    public static final char FORM_FEED = '\f';
    public static final char CARRIAGE_RETURN = '\r';
    public static final String CARRIAGE_RETURN_STR = Character.toString('\r');
    public static final char ESCAPE = '\u001b';
    public static final char SPACE = ' ';
    public static final String SPACE_STR = Character.toString(' ');
    public static final char DOUBLE_QUOTATION = '\"';
    public static final String DOUBLE_QUOTATION_STR = Character.toString('\"');
    public static final char SHARP = '#';
    public static final String SHARP_STR = Character.toString('#');
    public static final char DOLLAR = '$';
    public static final String DOLLAR_STR = Character.toString('$');
    public static final char PERCENT = '%';
    public static final String PERCENT_STR = Character.toString('%');
    public static final char AMPERSAND = '&';
    public static final String AMPERSAND_STR = Character.toString('&');
    public static final char SINGLE_QUOTATION = '\'';
    public static final String SINGLE_QUOTATION_STR = Character.toString('\'');
    public static final char PARENTHESES_STRAT = '(';
    public static final String PARENTHESES_STRAT_STR = Character.toString('(');
    public static final char PARENTHESES_END = ')';
    public static final String PARENTHESES_END_STR = Character.toString(')');
    public static final char ASTERISK = '*';
    public static final String ASTERISK_STR = Character.toString('*');
    public static final char PLUS = '+';
    public static final String PLUS_STR = Character.toString('+');
    public static final char COMMA = ',';
    public static final String COMMA_STR = Character.toString(',');
    public static final char HYPHEN = '-';
    public static final String HYPHEN_STR = Character.toString('-');
    public static final char DOT = '.';
    public static final String DOT_STR = Character.toString('.');
    public static final char SLASH = '/';
    public static final String SLASH_STR = Character.toString('/');
    public static final char ZERO = '0';
    public static final String ZERO_STR = Character.toString('0');
    public static final char NINE = '9';
    public static final String NINE_STR = Character.toString('9');
    public static final char COLON = ':';
    public static final String COLON_STR = Character.toString(':');
    public static final char SEMICOLON = ';';
    public static final String SEMICOLON_STR = Character.toString(';');
    public static final char LESS_THAN = '<';
    public static final String LESS_THAN_STR = Character.toString('<');
    public static final char EQUALS = '=';
    public static final String EQUALS_STR = Character.toString('=');
    public static final char GREATER_THAN = '>';
    public static final String GREATER_THAN_STR = Character.toString('>');
    public static final char QUESTION = '?';
    public static final String QUESTION_STR = Character.toString('?');
    public static final char x0041_A = 'A';
    public static final char x005A_Z = 'Z';
    public static final char SQUARE_BRACKETS_ST = '[';
    public static final String SQUARE_BRACKETS_ST_STR = Character.toString('[');
    public static final char BACKSLASH = '\\';
    public static final String BACKSLASH_STR = Character.toString('\\');
    public static final char SQUARE_BRACKETS_ED = ']';
    public static final String SQUARE_BRACKETS_ED_STR = Character.toString(']');
    public static final char CIRCUMFLEX = '^';
    public static final String CIRCUMFLEX_STR = Character.toString('^');
    public static final char UNDER_SCORE = '_';
    public static final String UNDER_SCORE_STR = Character.toString('_');
    public static final char x0061_a = 'a';
    public static final char x007A_z = 'z';
    public static final char LEFT_CURLY_BRACKET = '{';
    public static final String LEFT_CURLY_BRACKET_STR = Character.toString('{');
    public static final char VERTICAL_LINE = '|';
    public static final String VERTICAL_LINE_STR = Character.toString('|');
    public static final char RIGHT_CURLY_BRACKET = '}';
    public static final String RIGHT_CURLY_BRACKET_STR = Character.toString('}');
    public static final char TILDE = '~';
    public static final String TILDE_STR = Character.toString('~');
    public static final char BOX_DRAWINGS_LIGHT_HORIZONTAL = '\u2500';
    public static final char HYPHEN_U2501 = '\u2501';
    public static final char HYPHEN_U2574 = '\u2574';
    public static final char HYPHEN_U2576 = '\u2576';
    public static final char KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = '\u30fc';
    public static final char TILDE_OPERATOR = '\u223c';
    public static final char REVERSED_TILDE = '\u223d';
    public static final char INVERTED_LAZY_S = '\u223e';
    public static final char SIGN_WAVE = '\u223f';
    public static final char WAVE_DASH = '\u301c';
    public static final char FULLWIDTH_TILDE = '\uff5e';
    public static final char CONTROL_START = '\u0000';
    public static final char CONTROL_END = '\u001f';
    public static final char LATIN_START = '!';
    public static final char LATIN_END = '~';
    public static final char ALPHABET_CAPITAL_START = 'A';
    public static final char ALPHABET_CAPITAL_END = 'Z';
    public static final char ALPHABET_SMALL_START = 'a';
    public static final char ALPHABET_SMALL_END = 'z';
    public static final int ALPHABET_CAPITAL_OFFSET = 32;
    public static final char FULLWIDTH_LATIN_START = '\uff01';
    public static final char FULLWIDTH_LATIN_END = '\uff5e';
    public static final int FULLWIDTH_LATIN_OFFSET = 65248;
    public static final int MODE_null = 0;
    public static final int MODE_throwException = 1;
    public static final int MODE_ignore = 2;
    public static final int MODE_remove = 3;
    public static char[] ESCAPE_SEQENCE_CHARS;
    public static char[] ESCAPE_SEQENCE_STRS;
    public static final String lineSeparator;
    public static char[] TRIM_TARGETS;
    public static final String EMPTY = "";
    public static final char[] bake1;
    public static final String[] bake2;
    public static final String COMMA_AND_SPACE;

    static {
        char[] cArray = new char[9];
        cArray[1] = 7;
        cArray[2] = 8;
        cArray[3] = 9;
        cArray[4] = 10;
        cArray[5] = 11;
        cArray[6] = 12;
        cArray[7] = 13;
        cArray[8] = 27;
        ESCAPE_SEQENCE_CHARS = cArray;
        ESCAPE_SEQENCE_STRS = new char[]{'0', 'a', 'b', 't', 'n', 'v', 'f', 'r', 'e'};
        lineSeparator = System.getProperty("line.separator");
        TRIM_TARGETS = new char[]{' ', '\u3000'};
        bake1 = new char[]{'\uff0d', '\u2212', '\uff5e', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u2460', '\u2461', '\u2462', '\u2463', '\u2464', '\u2465', '\u2466', '\u2467', '\u2468', '\u2469', '\u246a', '\u246b', '\u246c', '\u246d', '\u246e', '\u246f', '\u2470', '\u2471', '\u2472', '\u2473', '\u7104', '\ufa11', '\u7028', '\u66fa', '\u9ad9', '\ufa10', '\u5fb7', '\ufa1e', '\u6ff5', '\u6801', '\u8cf4'};
        bake2 = new String[]{Character.toString('-'), Character.toString('-'), Character.toString('\u301c'), "[1]", "[2]", "[3]", "[4]", "[5]", "[6]", "[7]", "[8]", "[9]", "[10]", "(1)", "(2)", "(3)", "(4)", "(5)", "(6)", "(7)", "(8)", "(9)", "(10)", "(11)", "(12)", "(13)", "(14)", "(15)", "(16)", "(17)", "(18)", "(19)", "(20)", "\u541b", "\u5d0e", "\u702c", "\u66f9", "\u9ad8", "\u585a", "\u5fb3", "\u7fbd", "\u6ff1", "\u67f3", "\u983c"};
        COMMA_AND_SPACE = String.valueOf(COMMA_STR) + SPACE_STR;
    }

    private BcStringUtil() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(Object srcObj) {
        if (srcObj == null) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(srcObj.getClass())) {
            CharSequence charSequence = (CharSequence)srcObj;
            return BcStringUtil.isEmpty(charSequence);
        }
        return false;
    }

    public static boolean equals(CharSequence charSeq1, CharSequence charSeq2) {
        if (charSeq1 != null) {
            if (charSeq2 != null) {
                return charSeq1.equals(charSeq2);
            }
            return charSeq1.length() == 0;
        }
        if (charSeq2 != null) {
            return charSeq2.length() == 0;
        }
        return true;
    }

    public static int length(CharSequence src) {
        if (BcStringUtil.isEmpty(src)) {
            return 0;
        }
        return src.length();
    }

    public static boolean isEscapeSequenceChar(char aChar) {
        int i = 0;
        while (i < ESCAPE_SEQENCE_CHARS.length) {
            if (aChar == ESCAPE_SEQENCE_CHARS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEscapeSequenceStr(char aChar) {
        int i = 0;
        while (i < ESCAPE_SEQENCE_STRS.length) {
            if (aChar == ESCAPE_SEQENCE_STRS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static char toEscapeSequenceChar(char aChar) throws Exception {
        int i = 0;
        while (i < ESCAPE_SEQENCE_CHARS.length) {
            if (aChar == ESCAPE_SEQENCE_STRS[i]) {
                return ESCAPE_SEQENCE_CHARS[i];
            }
            ++i;
        }
        throw new Exception("'" + String.valueOf(aChar) + "' is not escape sequence.");
    }

    public static char toEscapeSequenceStr(char aChar) throws Exception {
        int i = 0;
        while (i < ESCAPE_SEQENCE_CHARS.length) {
            if (aChar == ESCAPE_SEQENCE_CHARS[i]) {
                return ESCAPE_SEQENCE_STRS[i];
            }
            ++i;
        }
        throw new Exception("'" + String.valueOf(aChar) + "' is not escape sequence.");
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        str1 = BcStringUtil.toLowerCase(str1);
        str2 = BcStringUtil.toLowerCase(str2);
        return BcStringUtil.equals(str1, str2);
    }

    public static boolean isNumber(char aChar) {
        return aChar >= '0' && aChar <= '9';
    }

    public static boolean isAlphabetCapital(char aChar) {
        return aChar >= 'A' && aChar <= 'Z';
    }

    public static boolean isAlphabetSmall(char aChar) {
        return aChar >= 'a' && aChar <= 'z';
    }

    public static boolean isAlphabet(char aChar) {
        return BcStringUtil.isAlphabetCapital(aChar) || BcStringUtil.isAlphabetSmall(aChar);
    }

    public static String toLowerCase(CharSequence str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toString().toLowerCase(locale);
    }

    public static String toLowerCase(CharSequence str) {
        return BcStringUtil.toLowerCase(str, Locale.getDefault());
    }

    public static String toUpperCase(CharSequence str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toString().toUpperCase(locale);
    }

    public static String toUpperCase(CharSequence str) {
        return BcStringUtil.toUpperCase(str, Locale.getDefault());
    }

    public static StringBuilder replace(CharSequence src, CharSequence target, CharSequence replacement, boolean caseSensitive) {
        StringBuilder sb = new StringBuilder();
        if (BcStringUtil.isEmpty(src)) {
            return sb;
        }
        if (BcStringUtil.isEmpty(target)) {
            if (src != null) {
                sb.append(src);
            }
            return sb;
        }
        String srcStr = null;
        srcStr = src instanceof String ? (String)src : src.toString();
        String srcWk = null;
        srcWk = caseSensitive ? srcStr : srcStr.toUpperCase();
        String str1Wk = null;
        str1Wk = target instanceof String ? (String)target : target.toString();
        if (!caseSensitive) {
            str1Wk = str1Wk.toUpperCase();
        }
        int srcLen = srcWk.length();
        int str1Len = str1Wk.length();
        int index1 = -1;
        int index2 = 0;
        while ((index1 = srcWk.indexOf(str1Wk, index2)) >= 0) {
            sb.append(srcStr.substring(index2, index1));
            if (!BcStringUtil.isEmpty(replacement)) {
                sb.append(replacement);
            }
            index2 = index1 + str1Len;
        }
        sb.append(srcStr.substring(index2, srcLen));
        return sb;
    }

    public static StringBuilder replace(CharSequence src, CharSequence target, CharSequence replacement) {
        return BcStringUtil.replace(src, target, replacement, true);
    }

    public static StringBuilder replace(CharSequence src, char charFrom, char charTo) throws Exception {
        return BcStringUtil.replace(src, Character.toString(charFrom), Character.toString(charTo));
    }

    public static String replace(CharSequence src, Properties replaceProps) throws Exception {
        StringBuilder sb = new StringBuilder(src);
        Enumeration<?> enumeration = replaceProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String str1 = (String)enumeration.nextElement();
            String str2 = replaceProps.getProperty(str1);
            sb = BcStringUtil.replace((CharSequence)sb, str1, str2);
        }
        return sb.toString();
    }

    public static String replace2(String src, String pattern, String replacement) {
        StringBuffer sb = new StringBuffer();
        int index = src.indexOf(pattern);
        if (index == -1) {
            sb.append(src);
            return sb.toString();
        }
        sb.append(String.valueOf(src.substring(0, index)) + replacement);
        if (index + pattern.length() < src.length()) {
            String rest = src.substring(index + pattern.length(), src.length());
            sb.append((CharSequence)BcStringUtil.replace((CharSequence)rest, pattern, replacement));
        }
        return sb.toString();
    }

    public static boolean isSpace(char aChar) {
        return aChar == ' ' || aChar == '\u3000';
    }

    public static String trim(CharSequence src, boolean toNull) {
        if (src == null) {
            return null;
        }
        int idx1 = 0;
        boolean isBreak = false;
        int i = 0;
        while (i < src.length()) {
            if (!BcStringUtil.isTrimTarget(src.charAt(i))) {
                idx1 = i;
                break;
            }
            ++i;
        }
        int idx2 = 0;
        isBreak = false;
        int i2 = 0;
        while (i2 < src.length()) {
            if (!BcStringUtil.isTrimTarget(src.charAt(src.length() - i2 - 1))) {
                idx2 = src.length() - i2;
                break;
            }
            ++i2;
        }
        String res = src.toString().substring(idx1, idx2);
        if (res.length() <= 0 && toNull) {
            res = null;
        }
        return res;
    }

    public static String trim(CharSequence src) {
        return BcStringUtil.trim(src, false);
    }

    public static boolean isTrimTarget(char aChar) {
        int i = 0;
        while (i < TRIM_TARGETS.length) {
            if (aChar == TRIM_TARGETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String endTrim(String src) {
        if (src == null) {
            return null;
        }
        int idx = 0;
        boolean isBreak = false;
        int i = 0;
        while (i < src.length()) {
            switch (src.charAt(src.length() - i - 1)) {
                case ' ': 
                case '\u3000': {
                    break;
                }
                default: {
                    idx = src.length() - i;
                    isBreak = true;
                }
            }
            if (isBreak) break;
            ++i;
        }
        return src.substring(0, idx);
    }

    public static List<String> trim(List<String> strList) {
        ArrayList<String> strList2 = new ArrayList<String>();
        int i = 0;
        while (i < strList.size()) {
            strList2.add(BcStringUtil.trim(strList.get(i)));
            ++i;
        }
        return strList2;
    }

    public static int indexOf(String src, String target) {
        if (BcStringUtil.isEmpty(src) || BcStringUtil.isEmpty(target)) {
            return -1;
        }
        return src.indexOf(target.toString());
    }

    public static int indexOf(String src, String ... targets) {
        if (BcStringUtil.isEmpty(src)) {
            return -1;
        }
        int i = 0;
        while (i < targets.length) {
            String target = targets[i];
            int index = BcStringUtil.indexOf(src, target);
            if (index >= 0) {
                return index;
            }
            ++i;
        }
        return -1;
    }

    public static boolean startsWith(String src, String prefix) {
        if (BcStringUtil.isEmpty(src)) {
            return false;
        }
        return src.startsWith(prefix);
    }

    public static boolean endsWith(String src, String suffix) {
        if (BcStringUtil.isEmpty(src)) {
            return false;
        }
        return src.endsWith(suffix);
    }

    public static String substring(String src, int beginIndex, int endIndex) {
        try {
            return src.substring(beginIndex, endIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String leftString(String src, int length) {
        if (BcStringUtil.length(src) <= length) {
            return src;
        }
        return BcStringUtil.substring(src, 0, length);
    }

    public static String rightString(String src, int length) {
        if (BcStringUtil.length(src) <= length) {
            return src;
        }
        return src.substring(src.length() - length);
    }

    public static String substring2(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String[] split(String src, String regex, int limit) {
        if (src == null) {
            return new String[0];
        }
        return src.split(regex, limit);
    }

    public static String[] split(String src, String regex) {
        return BcStringUtil.split(src, regex, -1);
    }

    public static String fill(CharSequence src, int cnt) {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length() * cnt);
        int i = 0;
        while (i < cnt) {
            sb.append(src);
            ++i;
        }
        return sb.toString();
    }

    public static String fill(char aChar, int cnt) {
        return BcStringUtil.fill(Character.toString(aChar), cnt);
    }

    public static String fillPrefix(CharSequence src, int length, char prefixChar) {
        if (BcStringUtil.isEmpty(src)) {
            return BcStringUtil.fill(prefixChar, length);
        }
        if (src.length() < length) {
            return String.valueOf(BcStringUtil.fill(prefixChar, length - src.length())) + src;
        }
        return src.toString();
    }

    public static String fillPrefix(Number number, int len, char prefixChar) {
        String value = null;
        if (number != null) {
            value = number.toString();
        }
        return BcStringUtil.fillPrefix(value, len, prefixChar);
    }

    public static String fillPrefix(Number number, int len) {
        return BcStringUtil.fillPrefix(number, len, '0');
    }

    public static String fillSuffix(CharSequence src, int length, char fillChar) {
        if (BcStringUtil.isEmpty(src)) {
            return BcStringUtil.fill(fillChar, length);
        }
        if (src.length() < length) {
            return src + BcStringUtil.fill(fillChar, length - src.length());
        }
        return src.toString();
    }

    public static String fillSuffixForce(CharSequence src, int length, char fillChar) {
        String tmpStr = BcStringUtil.fillSuffix(src, length, fillChar);
        return tmpStr.substring(0, length);
    }

    public static void clear(StringBuilder sb) {
        sb.delete(0, sb.length());
    }

    public static void lineSeparetor(CharSequence src, List<String> strList) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int index = -1;
        char aChar = '\u0000';
        int preChar = 0;
        while (++index < src.length()) {
            aChar = src.charAt(index);
            switch (aChar) {
                case '\n': {
                    if (preChar == 13) break;
                    strList.add(sb.toString());
                    BcStringUtil.clear(sb);
                    break;
                }
                case '\r': {
                    if (preChar == 10) break;
                    strList.add(sb.toString());
                    BcStringUtil.clear(sb);
                    break;
                }
                default: {
                    sb.append(aChar);
                }
            }
            preChar = aChar;
        }
        if (sb.length() > 0) {
            strList.add(sb.toString());
        }
    }

    public static List<String> lineSeparete(CharSequence src) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        BcStringUtil.lineSeparetor(src, strList);
        return strList;
    }

    public static List<String> lineSeparete2(String src) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(src)) {
            return strList;
        }
        StringBuilder sb = new StringBuilder();
        int index = -1;
        char aChar = '\u0000';
        int preChar = 0;
        while (++index < src.length()) {
            aChar = src.charAt(index);
            switch (aChar) {
                case '\n': {
                    if (preChar == 13) break;
                    strList.add(BcStringUtil.toNull(sb));
                    BcStringUtil.clear(sb);
                    break;
                }
                case '\r': {
                    strList.add(BcStringUtil.toNull(sb));
                    BcStringUtil.clear(sb);
                    break;
                }
                default: {
                    sb.append(aChar);
                }
            }
            preChar = aChar;
        }
        if (sb.length() > 0) {
            strList.add(sb.toString());
        } else if (aChar == '\n' || aChar == '\r') {
            strList.add(null);
        }
        return strList;
    }

    public static String marge(Collection<?> elementCollection, String delimiter, boolean nullEnable) {
        StringBuilder sb = new StringBuilder();
        for (Object element : elementCollection) {
            if (element == null && !nullEnable) continue;
            if (sb.length() > 0 && !BcStringUtil.isEmpty(delimiter)) {
                sb.append(delimiter);
            }
            if (element == null) continue;
            sb.append(element.toString());
        }
        return sb.toString();
    }

    public static String marge(Collection<?> elementCollection, String delimiter) {
        return BcStringUtil.marge(elementCollection, delimiter, true);
    }

    public static String marge(Collection<?> elementCollection) {
        return BcStringUtil.marge(elementCollection, null);
    }

    public static String margeArray(String delimiter, boolean nullEnable, Object array) throws Exception {
        List<Object> elementList = BcCollectionUtil.toList(array);
        return BcStringUtil.marge(elementList, delimiter, nullEnable);
    }

    public static String margeArray(String delimiter, Object ... values) throws Exception {
        return BcStringUtil.margeArray(delimiter, true, (Object)values);
    }

    public static String margeArray2(Object ... values) throws Exception {
        return BcStringUtil.margeArray(null, values).toString();
    }

    public static String topCharToUpperCase(String source) {
        return String.valueOf(source.substring(0, 1).toUpperCase()) + source.substring(1);
    }

    public static boolean containsIgnoreCase(CharSequence str1, List<String> strList) {
        str1 = BcStringUtil.toLowerCase(str1);
        int i = 0;
        while (i < strList.size()) {
            String str2 = BcStringUtil.toLowerCase(strList.get(i));
            if (BcStringUtil.equals(str1, str2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object choiceNotNull(Object value1, Object value2, Object defaultValue) {
        if (!BcStringUtil.isEmpty(value1)) {
            return value1;
        }
        if (!BcStringUtil.isEmpty(value2)) {
            return value2;
        }
        return defaultValue;
    }

    public static Object choiceNotNull(Object value1, Object value2) {
        return BcStringUtil.choiceNotNull(value1, value2, null);
    }

    public static Number choiceNotNull(Number value1, Number value2, Number defaultValue) {
        if (value1.doubleValue() > 0.0) {
            return value1;
        }
        if (value2.doubleValue() > 0.0) {
            return value2;
        }
        return defaultValue;
    }

    public static int choiceNotNull(int value1, int value2, int defaultValue) {
        Number number = BcStringUtil.choiceNotNull(new Integer(value1), new Integer(value2), new Integer(defaultValue));
        return number.intValue();
    }

    public static String choiceNotNull(CharSequence value1, CharSequence value2) {
        Object selectedValue = BcStringUtil.choiceNotNull(value1, value2, EMPTY);
        return selectedValue.toString();
    }

    public static String getLastText(CharSequence str) {
        if (BcStringUtil.isEmpty(str)) {
            return null;
        }
        return str.subSequence(str.length() - 1, str.length()).toString();
    }

    public static String extract(String str, String sep, int fromIndex) {
        int index2;
        int index1;
        block5: {
            block4: {
                try {
                    index1 = str.indexOf(sep, fromIndex);
                    if (index1 >= 0) break block4;
                    return null;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            index2 = str.indexOf(sep, index1 + 1);
            if (index2 >= 0) break block5;
            return null;
        }
        return str.substring(index1 + 1, index2);
    }

    public static String sandwiche(Object src, String mark) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(mark)) {
            sb.append(mark);
        }
        if (!BcStringUtil.isEmpty(src)) {
            sb.append(src);
        }
        if (!BcStringUtil.isEmpty(mark)) {
            sb.append(mark);
        }
        return sb.toString();
    }

    public static String doubleQuotation(Object src) {
        return BcStringUtil.sandwiche(src, DOUBLE_QUOTATION_STR);
    }

    public static String singleQuotation(Object src) {
        return BcStringUtil.sandwiche(src, SINGLE_QUOTATION_STR);
    }

    public static String toString(Object src) {
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public static String toStringNotNull(Object src) {
        if (src != null) {
            return src.toString();
        }
        return EMPTY;
    }

    public static int getCharCount(CharSequence src, char ... chars) {
        int count = 0;
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            int j = 0;
            while (j < chars.length) {
                if (aChar == chars[j]) {
                    ++count;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public static StringBuilder escapEncode(CharSequence src) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length() + 32);
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            sb.append(BcStringUtil.escapEncode_L2(aChar));
            ++i;
        }
        return sb;
    }

    public static String escapEncode_L2(char aChar) throws Exception {
        switch (aChar) {
            case '\u0000': {
                return String.valueOf(BACKSLASH_STR) + "0";
            }
            case '\b': {
                return String.valueOf(BACKSLASH_STR) + "b";
            }
            case '\t': {
                return String.valueOf(BACKSLASH_STR) + "t";
            }
            case '\n': {
                return String.valueOf(BACKSLASH_STR) + "n";
            }
            case '\f': {
                return String.valueOf(BACKSLASH_STR) + "f";
            }
            case '\r': {
                return String.valueOf(BACKSLASH_STR) + "r";
            }
            case '\"': 
            case '\'': 
            case '\\': {
                return String.valueOf(BACKSLASH_STR) + String.valueOf(aChar);
            }
        }
        return String.valueOf(aChar);
    }

    public static StringBuilder escapDecode(CharSequence src) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        char curChar = '\u0000';
        char preChar = '\u0000';
        boolean isEscape = false;
        int i = 0;
        while (i < src.length()) {
            curChar = src.charAt(i);
            if (isEscape) {
                switch (curChar) {
                    case '\"': 
                    case '\\': {
                        sb.append('\\');
                        sb.append(curChar);
                        isEscape = false;
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        isEscape = false;
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        isEscape = false;
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        isEscape = false;
                        break;
                    }
                    default: {
                        new Exception("\u30a8\u30b9\u30b1\u30fc\u30d7\u30b3\u30fc\u30c9\u5f8c\u306e\u6587\u5b57\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002char=" + curChar);
                        break;
                    }
                }
            } else {
                switch (curChar) {
                    case '\\': {
                        isEscape = true;
                        break;
                    }
                    default: {
                        sb.append(curChar);
                    }
                }
            }
            preChar = curChar;
            ++i;
        }
        return sb;
    }

    public static String toNull(CharSequence charSequence) {
        if (BcStringUtil.isEmpty(charSequence)) {
            return null;
        }
        return charSequence.toString();
    }

    public static String toNotNull(Object value) {
        if (value == null) {
            return EMPTY;
        }
        return value.toString();
    }

    public static void appendExceptEmpty(StringBuilder sb, CharSequence delimiter, Object ... appendDatas) {
        int i = 0;
        while (i < appendDatas.length) {
            String fosStr;
            Object appendData = appendDatas[i];
            if (appendData != null && !BcStringUtil.isEmpty(fosStr = appendData.toString())) {
                if (!BcStringUtil.isEmpty(delimiter) && !BcStringUtil.isEmpty(sb)) {
                    sb.append(delimiter);
                }
                sb.append(fosStr);
            }
            ++i;
        }
    }

    public static void appendExceptEmpty(StringBuilder sb, char delimiter, Object ... appendDatas) {
        BcStringUtil.appendExceptEmpty(sb, Character.toString(delimiter), appendDatas);
    }

    public static StringBuilder toStringBuilderExceptEmpty(CharSequence delimiter, Object ... appendDatas) {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.appendExceptEmpty(sb, delimiter, appendDatas);
        return sb;
    }

    public static StringBuilder toStringBuilderExceptEmpty(char delimiter, Object ... appendDatas) {
        return BcStringUtil.toStringBuilderExceptEmpty(Character.toString(delimiter), appendDatas);
    }

    public static void append(StringBuilder sb, Object appendData) {
        if (!BcStringUtil.isEmpty(appendData)) {
            sb.append(appendData);
        }
    }

    public static void appendCaseOfNotEmpty(StringBuilder sb, Object appendData) {
        if (BcStringUtil.isEmpty(sb)) {
            return;
        }
        if (appendData != null) {
            sb.append(appendData);
        }
    }

    public static void appendCaseOfTestDataNotEmpty(StringBuilder sb, CharSequence testData, Object appendData) {
        if (BcStringUtil.isEmpty(testData)) {
            return;
        }
        if (appendData != null) {
            sb.append(appendData);
        }
    }

    public static String appendCaseOfTestDataNotEmpty(CharSequence testData, CharSequence appendData) {
        if (BcStringUtil.isEmpty(testData)) {
            return EMPTY;
        }
        return appendData.toString();
    }

    public static StringBuilder choiceChrars(CharSequence src, char[][] charRenges) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            int j = 0;
            while (j < charRenges.length) {
                char[] charRenge = charRenges[j];
                if (BcStringUtil.isHit(aChar, charRenge)) {
                    sb.append(aChar);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return sb;
    }

    public static StringBuilder choiceChrars(CharSequence src, char[] charRenge) throws Exception {
        char[][] charRenges = new char[1][charRenge.length];
        charRenges[0] = charRenge;
        return BcStringUtil.choiceChrars(src, charRenges);
    }

    public static boolean isHit(char aChar, char[] charRenge) throws Exception {
        return aChar >= charRenge[0] && aChar <= charRenge[1];
    }

    public static String valueOfEnumeration(CharSequence src, char delimiter, int index) {
        if (BcStringUtil.isEmpty(src)) {
            return null;
        }
        int strLen = src.length();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        char aChar = '\u0000';
        for (int pos = 0; pos < strLen; ++pos) {
            aChar = src.charAt(pos);
            if (aChar == delimiter) {
                if (count == index) {
                    return sb.toString();
                }
                ++count;
                BcStringUtil.clear(sb);
                continue;
            }
            sb.append(aChar);
        }
        if (aChar == delimiter || sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static int indexOfEnumeration(CharSequence src, char delimiter, CharSequence target) {
        if (BcStringUtil.isEmpty(src)) {
            return -1;
        }
        int strLen = src.length();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        char aChar = '\u0000';
        for (int pos = 0; pos < strLen; ++pos) {
            aChar = src.charAt(pos);
            if (aChar == delimiter) {
                if (BcStringUtil.equals(sb.toString(), target)) {
                    return count;
                }
                ++count;
                BcStringUtil.clear(sb);
                continue;
            }
            sb.append(aChar);
        }
        if (BcStringUtil.equals(sb.toString(), target)) {
            return count;
        }
        return -1;
    }

    public static void stringTokenize(CharSequence src, String delimiter, boolean includeDelimiter, boolean doTrim, List<String> tokenList) {
        if (BcStringUtil.isEmpty(src)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(src.toString(), delimiter, includeDelimiter);
        boolean tokenFlag = true;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals(delimiter)) {
                if (tokenFlag) {
                    tokenList.add(null);
                }
                tokenFlag = true;
                continue;
            }
            if (doTrim) {
                token = BcStringUtil.trim(token);
            }
            tokenList.add(token);
            tokenFlag = false;
        }
    }

    public static List<String> stringTokenize(CharSequence src, String delimiter, boolean includeDelimiter, boolean doTrim) {
        ArrayList<String> tokenList = new ArrayList<String>();
        BcStringUtil.stringTokenize(src, delimiter, includeDelimiter, doTrim, tokenList);
        return tokenList;
    }

    public static List<String> stringTokenize(CharSequence src, char delimiter, boolean includeDelimiter, boolean doTrim) {
        return BcStringUtil.stringTokenize(src, Character.toString(delimiter), includeDelimiter, doTrim);
    }

    public static List<String> splitByLength(String src, int length) {
        ArrayList<String> strList = new ArrayList<String>();
        int i = 0;
        while (i < BcStringUtil.length(src)) {
            strList.add(BcStringUtil.substring2(src, i, i + length));
            i += length;
        }
        return strList;
    }

    public static boolean isControlCharacter(char aChar) {
        return aChar >= '\u0000' && aChar <= '\u001f';
    }

    public static boolean isHanLatinCharacter(char aChar) {
        return aChar >= '!' && aChar <= '~';
    }

    public static StringBuilder toLatinBasic(CharSequence src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block8: while (++pos < src.length()) {
            char aChar = src.charAt(pos);
            if (aChar >= '\uff01' && aChar <= '\uff5e') {
                sb.append((char)(aChar - 65248));
                continue;
            }
            switch (aChar) {
                case '\u3000': {
                    sb.append(' ');
                    continue block8;
                }
                case ' ': {
                    sb.append(aChar);
                    continue block8;
                }
            }
            switch (mode) {
                case 3: {
                    continue block8;
                }
                case 2: {
                    sb.append(aChar);
                    continue block8;
                }
            }
            throw new Exception("convert error:src='" + src + "' char1='" + aChar + "'");
        }
        return sb;
    }

    public static StringBuilder toLatinBasic(CharSequence src) throws Exception {
        return BcStringUtil.toLatinBasic(src, 2);
    }

    public static StringBuilder toZenLatinBasic(CharSequence src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block8: while (++pos < src.length()) {
            char aChar = src.charAt(pos);
            if (aChar >= '!' && aChar <= '~') {
                sb.append((char)(aChar + 65248));
                continue;
            }
            switch (aChar) {
                case ' ': {
                    sb.append('\u3000');
                    continue block8;
                }
                case '\u3000': {
                    sb.append(aChar);
                    continue block8;
                }
            }
            switch (mode) {
                case 3: {
                    continue block8;
                }
                case 2: {
                    sb.append(aChar);
                    continue block8;
                }
            }
            throw new Exception("convert error:src='" + src + "' char1='" + aChar + "'");
        }
        return sb;
    }

    public static StringBuilder toZenLatinBasic(CharSequence src) throws Exception {
        return BcStringUtil.toZenLatinBasic(src, 2);
    }

    public static String convNonSupportedtChar(CharSequence src) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            String tmpStr = null;
            int j = 0;
            while (j < bake1.length) {
                if (aChar == bake1[j]) {
                    tmpStr = bake2[j];
                    break;
                }
                ++j;
            }
            if (tmpStr == null) {
                sb.append(aChar);
            } else {
                BcLogUtil.debug("'" + aChar + "' -> '" + tmpStr + "'");
                sb.append(tmpStr);
            }
            ++i;
        }
        return sb.toString();
    }

    public static Character checkNonSupportedtChar(CharSequence src) throws Exception {
        if (src == null) {
            return null;
        }
        int i = 0;
        while (i < src.length()) {
            int j = 0;
            while (j < bake1.length) {
                if (src.charAt(i) == bake1[j]) {
                    return Character.valueOf(src.charAt(i));
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static StringBuilder toCharCode(CharSequence src, int columnCount) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (BcStringUtil.isEmpty(src)) {
            return sb;
        }
        int i = 0;
        while (i < src.length()) {
            char aChar = src.charAt(i);
            if ((i + 1) % columnCount == 1 && i > 0) {
                sb.append("\n");
            } else if (i > 0) {
                sb.append("    ");
            }
            sb.append(String.valueOf(aChar) + " : " + BcNumberUtil.toHex(aChar));
            ++i;
        }
        return sb;
    }

    public static StringBuilder toCharCode(CharSequence src) throws Exception {
        return BcStringUtil.toCharCode(src, 5);
    }

    public static StringBuilder toCharCode(char aChar) throws Exception {
        return BcStringUtil.toCharCode(Character.toString(aChar));
    }

    public static void dispCharCode(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int pos = -1;
        char[] chars = new char[1];
        while (true) {
            ++pos;
            if (reader.read(chars, 0, 1) < 0) break;
            char aChar = chars[0];
            BcLogUtil.info("'" + aChar + "' " + BcNumberUtil.toHex(aChar));
        }
        ((InputStream)is).close();
    }

    public static List<Integer> createIndexList(String src, String target) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int pos = 0;
        while ((pos = src.indexOf(target, pos)) >= 0) {
            indexList.add(new Integer(pos));
            pos += target.length();
        }
        return indexList;
    }

    public static String[] toStringArray(Collection collection) {
        String[] array = new String[collection.size()];
        int index = 0;
        for (Object value : collection) {
            array[index] = BcStringUtil.toString(value);
            ++index;
        }
        return array;
    }

    public static String toCsv(Collection collection, boolean withSpase) {
        String delimiter = null;
        delimiter = withSpase ? COMMA_AND_SPACE : COMMA_STR;
        return BcStringUtil.marge(collection, delimiter).toString();
    }

    public static String toCsv(Collection collection) {
        return BcStringUtil.toCsv(collection, false);
    }

    public static String toCsv(boolean withSpase, Object ... objects) throws Exception {
        return BcStringUtil.toCsv(Arrays.asList(objects), withSpase);
    }

    public static String toCsv(Object ... objects) throws Exception {
        return BcStringUtil.toCsv(false, objects);
    }

    public static String toCsv(boolean withSpase, String ... strings) throws Exception {
        return BcStringUtil.toCsv(Arrays.asList(strings), withSpase);
    }

    public static String toCsv(String ... strings) throws Exception {
        return BcStringUtil.toCsv(false, strings);
    }

    public static String toSsv(Collection collection) {
        return BcStringUtil.marge(collection, SPACE_STR).toString();
    }

    public static String toSsv(Object ... objects) {
        return BcStringUtil.toSsv(Arrays.asList(objects));
    }

    public static String changeCase(String src, char sepChar) {
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        char preChar = '\u0000';
        while (++pos < src.length()) {
            char aChar = src.charAt(pos);
            if (pos == 0) {
                sb.append(Character.toLowerCase(aChar));
            } else if (BcStringUtil.isAlphabetCapital(aChar)) {
                if (preChar != sepChar && !BcStringUtil.isAlphabetCapital(preChar)) {
                    sb.append(sepChar);
                }
                sb.append(Character.toLowerCase(aChar));
            } else if (BcStringUtil.isNumber(aChar)) {
                if (preChar != sepChar && !BcStringUtil.isNumber(preChar)) {
                    sb.append(sepChar);
                }
                sb.append(aChar);
            } else {
                sb.append(aChar);
            }
            preChar = aChar;
        }
        return sb.toString();
    }

    public static String toSnakeCase(String src) {
        return BcStringUtil.changeCase(src, '_');
    }

    public static String toKebabCase(String src) {
        return BcStringUtil.changeCase(src, '-');
    }

    public static String toPlaceholder(String str) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("${");
        sb.append(str);
        sb.append("}");
        return sb.toString();
    }

    public static enum LineSeparator {
        LF(LINE_FEED_STR, "LF: UNIX/Linux"),
        CR(CARRIAGE_RETURN_STR, "CR: Mac OS"),
        CR_LF(String.valueOf(CARRIAGE_RETURN_STR) + LINE_FEED_STR, "CR+LF: Windows");

        public final String separator;
        public final String note;

        private LineSeparator(String separator, String note) {
            this.separator = separator;
            this.note = note;
        }

        public static LineSeparator getBySeparator(String separator) {
            LineSeparator[] lineSeparatorArray = LineSeparator.values();
            int n = lineSeparatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineSeparator lineSeparator = lineSeparatorArray[n2];
                if (lineSeparator.separator.equals(separator)) {
                    return lineSeparator;
                }
                ++n2;
            }
            return null;
        }

        public static String getNoteBySeparator(String separator) {
            LineSeparator lineSeparator = LineSeparator.getBySeparator(separator);
            if (lineSeparator != null) {
                return lineSeparator.note;
            }
            return null;
        }

        public static String getSeparatorByName(String name) {
            LineSeparator lineSeparator = BcLangUtil.getEnumByName(LineSeparator.class, name);
            if (lineSeparator != null) {
                return lineSeparator.separator;
            }
            return null;
        }
    }

    public static class TextReplace {
        protected CharSequence src;
        protected CharSequence target;
        protected CharSequence replacement;
        protected boolean caseSensitive;

        public StringBuilder replace(CharSequence src, CharSequence target, CharSequence replacement, boolean caseSensitive) {
            String stbString;
            this.src = src;
            this.target = target;
            this.replacement = replacement;
            this.caseSensitive = caseSensitive;
            this.started();
            StringBuilder sb = new StringBuilder();
            if (BcStringUtil.isEmpty(src)) {
                return sb;
            }
            if (BcStringUtil.isEmpty(target)) {
                if (src != null) {
                    sb.append(src);
                }
                return sb;
            }
            String srcStr = null;
            srcStr = src instanceof String ? (String)src : src.toString();
            String srcWk = null;
            srcWk = caseSensitive ? srcStr : srcStr.toUpperCase();
            String str1Wk = null;
            str1Wk = target instanceof String ? (String)target : target.toString();
            if (!caseSensitive) {
                str1Wk = str1Wk.toUpperCase();
            }
            int index1 = -1;
            int index2 = 0;
            while ((index1 = srcWk.indexOf(str1Wk, index2)) >= 0) {
                this.found(index1, sb);
                stbString = srcStr.substring(index2, index1);
                sb.append(stbString);
                if (!BcStringUtil.isEmpty(replacement)) {
                    sb.append(replacement);
                }
                index2 = index1 + str1Wk.length();
            }
            stbString = srcStr.substring(index2, srcWk.length());
            sb.append(stbString);
            this.finished();
            return sb;
        }

        protected void started() {
        }

        protected void found(int index, StringBuilder beforeStr) {
            BcLogUtil.debug("found:index=" + index);
        }

        protected void finished() {
        }
    }
}

