/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EUCJPProber;
import org.mozilla.universalchardet.prober.EUCKRProber;
import org.mozilla.universalchardet.prober.EUCTWProber;
import org.mozilla.universalchardet.prober.GB18030Prober;
import org.mozilla.universalchardet.prober.SJISProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class MBCSGroupProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private CharsetProber[] probers = new CharsetProber[7];
    private boolean[] isActive = new boolean[7];
    private int bestGuess;
    private int activeNum;

    public MBCSGroupProber() {
        this.probers[0] = new UTF8Prober();
        this.probers[1] = new SJISProber();
        this.probers[2] = new EUCJPProber();
        this.probers[3] = new GB18030Prober();
        this.probers[4] = new EUCKRProber();
        this.probers[5] = new Big5Prober();
        this.probers[6] = new EUCTWProber();
        this.reset();
    }

    public String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    public float getConfidence() {
        float f = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        for (int i = 0; i < this.probers.length; ++i) {
            float f2;
            if (!this.isActive[i] || !(f < (f2 = this.probers[i].getConfidence()))) continue;
            f = f2;
            this.bestGuess = i;
        }
        return f;
    }

    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3;
        boolean bl = true;
        byte[] byArray2 = new byte[n2];
        int n4 = 0;
        int n5 = n + n2;
        for (n3 = n; n3 < n5; ++n3) {
            if ((byArray[n3] & 0x80) != 0) {
                byArray2[n4++] = byArray[n3];
                bl = true;
                continue;
            }
            if (!bl) continue;
            byArray2[n4++] = byArray[n3];
            bl = false;
        }
        for (n3 = 0; n3 < this.probers.length; ++n3) {
            if (!this.isActive[n3]) continue;
            CharsetProber.ProbingState probingState = this.probers[n3].handleData(byArray2, 0, n4);
            if (probingState == CharsetProber.ProbingState.FOUND_IT) {
                this.bestGuess = n3;
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (probingState != CharsetProber.ProbingState.NOT_ME) continue;
            this.isActive[n3] = false;
            --this.activeNum;
            if (this.activeNum > 0) continue;
            this.state = CharsetProber.ProbingState.NOT_ME;
            break;
        }
        return this.state;
    }

    public void reset() {
        this.activeNum = 0;
        for (int i = 0; i < this.probers.length; ++i) {
            this.probers[i].reset();
            this.isActive[i] = true;
            ++this.activeNum;
        }
        this.bestGuess = -1;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    public void setOption() {
    }
}

