/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;

public class JdbcOdbcResultSetMetaData
extends JdbcOdbcObject
implements ResultSetMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcResultSetInterface resultSet;
    protected long hStmt;

    public JdbcOdbcResultSetMetaData(JdbcOdbc jdbcOdbc, JdbcOdbcResultSetInterface jdbcOdbcResultSetInterface) {
        this.OdbcApi = jdbcOdbc;
        this.resultSet = jdbcOdbcResultSetInterface;
        this.hStmt = jdbcOdbcResultSetInterface.getHSTMT();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isAutoIncrement (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 11);
        return bl;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isCaseSensitive (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 12);
        return bl;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        int n2;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isSearchable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 13)) != 0;
        return bl;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isCurrency (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 9);
        return bl;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isNullable (" + n + ")");
        }
        int n2 = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? 0 : this.getColAttribute(n, 7);
        return n2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isSigned (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : !this.getColAttributeBoolean(n, 8);
        return bl;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnDisplaySize (" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() : this.getColAttribute(n, 6);
        return n2;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnLabel (" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n, 18);
        string = this.resultSet.mapColumnName(string, n);
        return string;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnName (" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n, 1);
        string = this.resultSet.mapColumnName(string, n);
        return string;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getSchemaName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 16);
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getPrecision (" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() - 1 : this.getColAttribute(n, 4);
        return n2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getScale (" + n + ")");
        }
        return this.resultSet.getScale(n);
    }

    @Override
    public String getTableName(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getTableName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 15);
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getCatalogName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 17);
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnType (" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n)) != null ? jdbcOdbcPseudoCol.getColumnType() - 1 : this.resultSet.getColumnType(n);
        return n2;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnTypeName (" + n + ")");
        }
        String string = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? "" : this.getColAttributeString(n, 14);
        return string;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        int n2;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isReadOnly (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? true : (n2 = this.getColAttribute(n, 10)) == 0;
        return bl;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        int n2;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isWritable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 2;
        return bl;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        int n2;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isDefinitelyWritable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 1;
        return bl;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnClassName (" + n + ")");
        }
        String string = new String().getClass().getName();
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 2: 
            case 3: {
                string = new BigDecimal(0).getClass().getName();
                break;
            }
            case -7: {
                string = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                string = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                string = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                string = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                string = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                string = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                string = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 91: {
                string = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                string = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                string = new Timestamp(123456L).getClass().getName();
            }
        }
        return string;
    }

    protected int getColAttribute(int n, int n2) throws SQLException {
        return this.resultSet.getColAttribute(n, n2);
    }

    protected boolean getColAttributeBoolean(int n, int n2) throws SQLException {
        int n3 = this.getColAttribute(n, n2);
        boolean bl = false;
        if (n3 == 1) {
            bl = true;
        }
        return bl;
    }

    protected String getColAttributeString(int n, int n2) throws SQLException {
        String string = "";
        this.resultSet.clearWarnings();
        try {
            string = this.OdbcApi.SQLColAttributesString(this.hStmt, n, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.resultSet.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

