/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class OrderByDeParser
extends AbstractDeParser<List<OrderByElement>> {
    private ExpressionVisitor expressionVisitor;

    OrderByDeParser() {
        super(new StringBuilder());
    }

    public OrderByDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(List<OrderByElement> orderByElementList) {
        this.deParse(false, orderByElementList);
    }

    public void deParse(boolean oracleSiblings, List<OrderByElement> orderByElementList) {
        if (oracleSiblings) {
            this.buffer.append(" ORDER SIBLINGS BY ");
        } else {
            this.buffer.append(" ORDER BY ");
        }
        Iterator<OrderByElement> iter = orderByElementList.iterator();
        while (iter.hasNext()) {
            OrderByElement orderByElement = iter.next();
            this.deParseElement(orderByElement);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public void deParseElement(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }

    void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

