/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xml.serializer.WriterChain;

class WriterToASCI
extends Writer
implements WriterChain {
    private final OutputStream m_os;

    public WriterToASCI(OutputStream os) {
        this.m_os = os;
    }

    @Override
    public void write(char[] chars, int start, int length) throws IOException {
        int n = length + start;
        int i = start;
        while (i < n) {
            this.m_os.write(chars[i]);
            ++i;
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.m_os.write(c);
    }

    @Override
    public void write(String s) throws IOException {
        int n = s.length();
        int i = 0;
        while (i < n) {
            this.m_os.write(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_os.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_os.close();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.m_os;
    }

    @Override
    public Writer getWriter() {
        return null;
    }
}

