/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.native2ascii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.Native2Ascii;
import org.apache.tools.ant.taskdefs.optional.native2ascii.Native2AsciiAdapter;
import org.apache.tools.ant.util.Native2AsciiUtils;
import org.apache.tools.ant.util.StringUtils;

public class BuiltinNative2Ascii
implements Native2AsciiAdapter {
    static final String IMPLEMENTATION_NAME = "builtin";

    /*
     * Loose catch block
     */
    @Override
    public final boolean convert(Native2Ascii args, File srcFile, File destFile) throws BuildException {
        Writer output;
        BufferedReader input;
        Throwable throwable;
        block20: {
            block19: {
                boolean reverse = args.getReverse();
                String encoding = args.getEncoding();
                throwable = null;
                Object var7_9 = null;
                input = this.getReader(srcFile, encoding, reverse);
                output = this.getWriter(destFile, encoding, reverse);
                this.translate(input, output, reverse);
                if (output == null) break block19;
                output.close();
            }
            if (input == null) break block20;
            input.close();
        }
        return true;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            if (output != null) {
                                output.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (input != null) {
                                input.close();
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("Exception trying to translate data", ex);
                }
            }
        }
    }

    private BufferedReader getReader(File srcFile, String encoding, boolean reverse) throws IOException {
        if (!reverse && encoding != null) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), encoding));
        }
        return new BufferedReader(new FileReader(srcFile));
    }

    private Writer getWriter(File destFile, String encoding, boolean reverse) throws IOException {
        if (!reverse) {
            encoding = "ASCII";
        }
        if (encoding != null) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), encoding));
        }
        return new BufferedWriter(new FileWriter(destFile));
    }

    private void translate(BufferedReader input, Writer output, boolean reverse) throws IOException {
        String line = null;
        while ((line = input.readLine()) != null) {
            if (!reverse) {
                output.write(Native2AsciiUtils.native2ascii(line));
            } else {
                output.write(Native2AsciiUtils.ascii2native(line));
            }
            output.write(StringUtils.LINE_SEP);
        }
    }
}

