/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class ZipCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int level;

    public ZipCompressAction(File source, File destination, boolean deleteSource, int level) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.source = source;
        this.destination = destination;
        this.deleteSource = deleteSource;
        this.level = level;
    }

    @Override
    public boolean execute() throws IOException {
        return ZipCompressAction.execute(this.source, this.destination, this.deleteSource, this.level);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(File source, File destination, boolean deleteSource, int level) throws IOException {
        block14: {
            if (!source.exists()) return false;
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FileInputStream fis = new FileInputStream(source);
                try {
                    try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destination));){
                        int n;
                        zos.setLevel(level);
                        ZipEntry zipEntry = new ZipEntry(source.getName());
                        zos.putNextEntry(zipEntry);
                        byte[] inbuf = new byte[8192];
                        while ((n = fis.read(inbuf)) != -1) {
                            zos.write(inbuf, 0, n);
                        }
                    }
                    if (fis == null) break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        if (!deleteSource) return true;
        if (source.delete()) return true;
        LOGGER.warn("Unable to delete " + source.toString() + '.');
        return true;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return String.valueOf(ZipCompressAction.class.getSimpleName()) + '[' + this.source + " to " + this.destination + ", level=" + this.level + ", deleteSource=" + this.deleteSource + ']';
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }

    public int getLevel() {
        return this.level;
    }
}

