/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.jms;

import javax.jms.Message;
import javax.jms.Session;
import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.output.AbstractTarget;
import org.apache.log.output.jms.MessageBuilder;

public abstract class AbstractJMSTarget
extends AbstractTarget {
    private MessageBuilder m_builder;

    public AbstractJMSTarget(MessageBuilder builder) {
        this.m_builder = builder;
    }

    public AbstractJMSTarget(MessageBuilder builder, ErrorHandler errorHandler) {
        super(errorHandler);
        this.m_builder = builder;
    }

    protected abstract void send(Message var1);

    protected abstract Session getSession();

    @Override
    protected void doProcessEvent(LogEvent event) throws Exception {
        Message message = this.m_builder.buildMessage(this.getSession(), event);
        this.send(message);
    }

    @Override
    protected synchronized void open() {
        if (!this.isOpen()) {
            super.open();
            this.openConnection();
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            this.closeConnection();
            super.close();
        }
    }

    protected abstract void openConnection();

    protected abstract void closeConnection();
}

