/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public class MLSxEntryParser
extends FTPFileEntryParserImpl {
    private static final MLSxEntryParser PARSER = new MLSxEntryParser();
    private static final HashMap<String, Integer> TYPE_TO_INT = new HashMap();
    private static int[] UNIX_GROUPS;
    private static int[][] UNIX_PERMS;

    static {
        TYPE_TO_INT.put("file", 0);
        TYPE_TO_INT.put("cdir", 1);
        TYPE_TO_INT.put("pdir", 1);
        TYPE_TO_INT.put("dir", 1);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        UNIX_GROUPS = nArray;
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[0];
        nArrayArray[1] = new int[]{2};
        nArrayArray[2] = new int[]{1};
        nArrayArray[3] = new int[]{2, 1};
        nArrayArray[4] = new int[1];
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[5] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray[6] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArrayArray[7] = nArray4;
        UNIX_PERMS = nArrayArray;
    }

    @Override
    public FTPFile parseFTPEntry(String entry) {
        if (entry.startsWith(" ")) {
            if (entry.length() > 1) {
                FTPFile file = new FTPFile();
                file.setRawListing(entry);
                file.setName(entry.substring(1));
                return file;
            }
            return null;
        }
        String[] parts = entry.split(" ", 2);
        if (parts.length != 2 || parts[1].length() == 0) {
            return null;
        }
        String factList = parts[0];
        if (!factList.endsWith(";")) {
            return null;
        }
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        file.setName(parts[1]);
        String[] facts = factList.split(";");
        boolean hasUnixMode = parts[0].toLowerCase(Locale.ENGLISH).contains("unix.mode=");
        String[] stringArray = facts;
        int n = facts.length;
        int n2 = 0;
        while (n2 < n) {
            String fact = stringArray[n2];
            String[] factparts = fact.split("=", -1);
            if (factparts.length != 2) {
                return null;
            }
            String factname = factparts[0].toLowerCase(Locale.ENGLISH);
            String factvalue = factparts[1];
            if (factvalue.length() != 0) {
                String valueLowerCase = factvalue.toLowerCase(Locale.ENGLISH);
                if ("size".equals(factname)) {
                    file.setSize(Long.parseLong(factvalue));
                } else if ("sizd".equals(factname)) {
                    file.setSize(Long.parseLong(factvalue));
                } else if ("modify".equals(factname)) {
                    Calendar parsed = MLSxEntryParser.parseGMTdateTime(factvalue);
                    if (parsed == null) {
                        return null;
                    }
                    file.setTimestamp(parsed);
                } else if ("type".equals(factname)) {
                    Integer intType = TYPE_TO_INT.get(valueLowerCase);
                    if (intType == null) {
                        file.setType(3);
                    } else {
                        file.setType(intType);
                    }
                } else if (factname.startsWith("unix.")) {
                    String unixfact = factname.substring("unix.".length()).toLowerCase(Locale.ENGLISH);
                    if ("group".equals(unixfact)) {
                        file.setGroup(factvalue);
                    } else if ("owner".equals(unixfact)) {
                        file.setUser(factvalue);
                    } else if ("mode".equals(unixfact)) {
                        int off = factvalue.length() - 3;
                        int i = 0;
                        while (i < 3) {
                            int ch = factvalue.charAt(off + i) - 48;
                            if (ch >= 0 && ch <= 7) {
                                int[] nArray = UNIX_PERMS[ch];
                                int n3 = nArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    int p = nArray[n4];
                                    file.setPermission(UNIX_GROUPS[i], p, true);
                                    ++n4;
                                }
                            }
                            ++i;
                        }
                    }
                } else if (!hasUnixMode && "perm".equals(factname)) {
                    this.doUnixPerms(file, valueLowerCase);
                }
            }
            ++n2;
        }
        return file;
    }

    public static Calendar parseGMTdateTime(String timestamp) {
        boolean hasMillis;
        SimpleDateFormat sdf;
        if (timestamp.contains(".")) {
            sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            hasMillis = true;
        } else {
            sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            hasMillis = false;
        }
        TimeZone GMT = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(GMT);
        GregorianCalendar gc = new GregorianCalendar(GMT);
        ParsePosition pos = new ParsePosition(0);
        sdf.setLenient(false);
        Date parsed = sdf.parse(timestamp, pos);
        if (pos.getIndex() != timestamp.length()) {
            return null;
        }
        gc.setTime(parsed);
        if (!hasMillis) {
            gc.clear(14);
        }
        return gc;
    }

    private void doUnixPerms(FTPFile file, String valueLowerCase) {
        char[] cArray = valueLowerCase.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'a': {
                    file.setPermission(0, 1, true);
                    break;
                }
                case 'c': {
                    file.setPermission(0, 1, true);
                    break;
                }
                case 'd': {
                    file.setPermission(0, 1, true);
                    break;
                }
                case 'e': {
                    file.setPermission(0, 0, true);
                    break;
                }
                case 'f': {
                    break;
                }
                case 'l': {
                    file.setPermission(0, 2, true);
                    break;
                }
                case 'm': {
                    file.setPermission(0, 1, true);
                    break;
                }
                case 'p': {
                    file.setPermission(0, 1, true);
                    break;
                }
                case 'r': {
                    file.setPermission(0, 0, true);
                    break;
                }
                case 'w': {
                    file.setPermission(0, 1, true);
                    break;
                }
            }
            ++n2;
        }
    }

    public static FTPFile parseEntry(String entry) {
        return PARSER.parseFTPEntry(entry);
    }

    public static MLSxEntryParser getInstance() {
        return PARSER;
    }
}

