/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class BeanPropertyPointer
extends PropertyPointer {
    private static final long serialVersionUID = -6008991447676468786L;
    private static final Object UNINITIALIZED = new Object();
    private String propertyName;
    private JXPathBeanInfo beanInfo;
    private Object baseValue = UNINITIALIZED;
    private Object value = UNINITIALIZED;
    private transient String[] names;
    private transient PropertyDescriptor[] propertyDescriptors;
    private transient PropertyDescriptor propertyDescriptor;

    public BeanPropertyPointer(NodePointer parent, JXPathBeanInfo beanInfo) {
        super(parent);
        this.beanInfo = beanInfo;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public int getPropertyCount() {
        if (this.beanInfo.isAtomic()) {
            return 0;
        }
        return this.getPropertyDescriptors().length;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.names == null) {
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            this.names = new String[pds.length];
            int i = 0;
            while (i < this.names.length) {
                this.names[i] = pds[i].getName();
                ++i;
            }
        }
        return this.names;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(Integer.MIN_VALUE);
        this.propertyName = propertyName;
    }

    @Override
    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.propertyName = null;
            this.propertyDescriptor = null;
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
    }

    @Override
    public Object getBaseValue() {
        if (this.baseValue == UNINITIALIZED) {
            PropertyDescriptor pd = this.getPropertyDescriptor();
            if (pd == null) {
                return null;
            }
            this.baseValue = ValueUtils.getValue(this.getBean(), pd);
        }
        return this.baseValue;
    }

    @Override
    public void setIndex(int index) {
        if (this.index == index) {
            return;
        }
        if (this.index != Integer.MIN_VALUE || index != 0 || this.isCollection()) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    @Override
    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            PropertyDescriptor pd;
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.getBaseValue()) : ((pd = this.getPropertyDescriptor()) == null ? null : ValueUtils.getValue(this.getBean(), pd, this.index));
        }
        return this.value;
    }

    @Override
    protected boolean isActualProperty() {
        return this.getPropertyDescriptor() != null;
    }

    @Override
    public boolean isCollection() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            return false;
        }
        if (pd instanceof IndexedPropertyDescriptor) {
            return true;
        }
        int hint = ValueUtils.getCollectionHint(pd.getPropertyType());
        if (hint == -1) {
            return false;
        }
        if (hint == 1) {
            return true;
        }
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    @Override
    public int getLength() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            return 1;
        }
        if (pd instanceof IndexedPropertyDescriptor) {
            return ValueUtils.getIndexedPropertyLength(this.getBean(), (IndexedPropertyDescriptor)pd);
        }
        int hint = ValueUtils.getCollectionHint(pd.getPropertyType());
        if (hint == -1) {
            return 1;
        }
        return ValueUtils.getLength(this.getBaseValue());
    }

    @Override
    public void setValue(Object value) {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            throw new JXPathInvalidAccessException("Cannot set property: " + this.asPath() + " - no such property");
        }
        if (this.index == Integer.MIN_VALUE) {
            ValueUtils.setValue(this.getBean(), pd, value);
        } else {
            ValueUtils.setValue(this.getBean(), pd, this.index, value);
        }
        this.value = value;
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        if (this.getImmediateNode() == null) {
            super.createPath(context);
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
        return this;
    }

    @Override
    public void remove() {
        if (this.index == Integer.MIN_VALUE) {
            this.setValue(null);
        } else if (this.isCollection()) {
            Object o = this.getBaseValue();
            Object collection = ValueUtils.remove(this.getBaseValue(), this.index);
            if (collection != o) {
                ValueUtils.setValue(this.getBean(), this.getPropertyDescriptor(), collection);
            }
        } else if (this.index == 0) {
            this.index = Integer.MIN_VALUE;
            this.setValue(null);
        }
    }

    @Override
    public String getPropertyName() {
        PropertyDescriptor pd;
        if (this.propertyName == null && (pd = this.getPropertyDescriptor()) != null) {
            this.propertyName = pd.getName();
        }
        return this.propertyName != null ? this.propertyName : "*";
    }

    private PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            int inx = this.getPropertyIndex();
            if (inx == Integer.MIN_VALUE) {
                this.propertyDescriptor = this.beanInfo.getPropertyDescriptor(this.propertyName);
            } else {
                PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
                this.propertyDescriptor = inx >= 0 && inx < propertyDescriptors.length ? propertyDescriptors[inx] : null;
            }
        }
        return this.propertyDescriptor;
    }

    protected synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        }
        return this.propertyDescriptors;
    }
}

