/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;

public abstract class CoreOperationRelationalExpression
extends CoreOperation {
    protected CoreOperationRelationalExpression(Expression[] args) {
        super(args);
    }

    @Override
    public final Object computeValue(EvalContext context) {
        return this.compute(this.args[0].compute(context), this.args[1].compute(context)) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected final int getPrecedence() {
        return 3;
    }

    @Override
    protected final boolean isSymmetric() {
        return false;
    }

    protected abstract boolean evaluateCompare(int var1);

    private boolean compute(Object left, Object right) {
        left = this.reduce(left);
        right = this.reduce(right);
        if (left instanceof InitialContext) {
            ((InitialContext)left).reset();
        }
        if (right instanceof InitialContext) {
            ((InitialContext)right).reset();
        }
        if (left instanceof Iterator && right instanceof Iterator) {
            return this.findMatch((Iterator)left, (Iterator)right);
        }
        if (left instanceof Iterator) {
            return this.containsMatch((Iterator)left, right);
        }
        if (right instanceof Iterator) {
            return this.containsMatch((Iterator)right, left);
        }
        double ld = InfoSetUtil.doubleValue(left);
        if (Double.isNaN(ld)) {
            return false;
        }
        double rd = InfoSetUtil.doubleValue(right);
        if (Double.isNaN(rd)) {
            return false;
        }
        return this.evaluateCompare(ld == rd ? 0 : (ld < rd ? -1 : 1));
    }

    private Object reduce(Object o) {
        if (o instanceof SelfContext) {
            o = ((EvalContext)o).getSingleNodePointer();
        }
        if (o instanceof Collection) {
            o = ((Collection)((Object)o)).iterator();
        }
        return o;
    }

    private boolean containsMatch(Iterator it, Object value) {
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.compute(element, value)) continue;
            return true;
        }
        return false;
    }

    private boolean findMatch(Iterator lit, Iterator rit) {
        HashSet left = new HashSet();
        while (lit.hasNext()) {
            left.add(lit.next());
        }
        while (rit.hasNext()) {
            if (!this.containsMatch(left.iterator(), rit.next())) continue;
            return true;
        }
        return false;
    }
}

