/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class VerifierFactoryListModel
implements VerifierFactoryObserver,
ListModel<String> {
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private final Set<String> cache = new TreeSet<String>();

    public VerifierFactoryListModel() {
        VerifierFactory.attach(this);
        this.update(null);
    }

    @Override
    public synchronized void update(String s) {
        Verifier[] verifiers = VerifierFactory.getVerifiers();
        int num_of_verifiers = verifiers.length;
        this.cache.clear();
        Verifier[] verifierArray = verifiers;
        int n = verifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Verifier verifier = verifierArray[n2];
            this.cache.add(verifier.getClassName());
            ++n2;
        }
        for (ListDataListener listener : this.listeners) {
            ListDataEvent e = new ListDataEvent(this, 0, 0, num_of_verifiers - 1);
            listener.contentsChanged(e);
        }
    }

    @Override
    public synchronized void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public synchronized int getSize() {
        return this.cache.size();
    }

    @Override
    public synchronized String getElementAt(int index) {
        return this.cache.toArray(new String[this.cache.size()])[index];
    }
}

