/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.apache.bcel.generic.ElementValuePairGen;
import org.apache.bcel.generic.ObjectType;

public class AnnotationEntryGen {
    private int typeIndex;
    private List<ElementValuePairGen> evs;
    private final ConstantPoolGen cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationEntryGen(AnnotationEntry a, ConstantPoolGen cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        this.typeIndex = copyPoolEntries ? cpool.addUtf8(a.getAnnotationType()) : a.getAnnotationTypeIndex();
        this.isRuntimeVisible = a.isRuntimeVisible();
        this.evs = this.copyValues(a.getElementValuePairs(), cpool, copyPoolEntries);
    }

    private List<ElementValuePairGen> copyValues(ElementValuePair[] in, ConstantPoolGen cpool, boolean copyPoolEntries) {
        ArrayList<ElementValuePairGen> out = new ArrayList<ElementValuePairGen>();
        ElementValuePair[] elementValuePairArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            ElementValuePair nvp = elementValuePairArray[n2];
            out.add(new ElementValuePairGen(nvp, cpool, copyPoolEntries));
            ++n2;
        }
        return out;
    }

    private AnnotationEntryGen(ConstantPoolGen cpool) {
        this.cpool = cpool;
    }

    public AnnotationEntry getAnnotation() {
        AnnotationEntry a = new AnnotationEntry(this.typeIndex, this.cpool.getConstantPool(), this.isRuntimeVisible);
        for (ElementValuePairGen element : this.evs) {
            a.addElementNameValuePair(element.getElementNameValuePair());
        }
        return a;
    }

    public AnnotationEntryGen(ObjectType type, List<ElementValuePairGen> elements, boolean vis, ConstantPoolGen cpool) {
        this.cpool = cpool;
        this.typeIndex = cpool.addUtf8(type.getSignature());
        this.evs = elements;
        this.isRuntimeVisible = vis;
    }

    public static AnnotationEntryGen read(DataInput dis, ConstantPoolGen cpool, boolean b) throws IOException {
        AnnotationEntryGen a = new AnnotationEntryGen(cpool);
        a.typeIndex = dis.readUnsignedShort();
        int elemValuePairCount = dis.readUnsignedShort();
        int i = 0;
        while (i < elemValuePairCount) {
            int nidx = dis.readUnsignedShort();
            a.addElementNameValuePair(new ElementValuePairGen(nidx, ElementValueGen.readElementValue(dis, cpool), cpool));
            ++i;
        }
        a.isRuntimeVisible(b);
        return a;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.evs.size());
        for (ElementValuePairGen envp : this.evs) {
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(ElementValuePairGen evp) {
        if (this.evs == null) {
            this.evs = new ArrayList<ElementValuePairGen>();
        }
        this.evs.add(evp);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public final String getTypeSignature() {
        ConstantUtf8 utf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return utf8.getBytes();
    }

    public final String getTypeName() {
        return this.getTypeSignature();
    }

    public List<ElementValuePairGen> getValues() {
        return this.evs;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(32);
        s.append("AnnotationGen:[").append(this.getTypeName()).append(" #").append(this.evs.size()).append(" {");
        int i = 0;
        while (i < this.evs.size()) {
            s.append(this.evs.get(i));
            if (i + 1 < this.evs.size()) {
                s.append(",");
            }
            ++i;
        }
        s.append("}]");
        return s.toString();
    }

    public String toShortString() {
        StringBuilder s = new StringBuilder();
        s.append("@").append(this.getTypeName()).append("(");
        int i = 0;
        while (i < this.evs.size()) {
            s.append(this.evs.get(i));
            if (i + 1 < this.evs.size()) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    private void isRuntimeVisible(boolean b) {
        this.isRuntimeVisible = b;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Attribute[] getAnnotationAttributes(ConstantPoolGen cp, AnnotationEntryGen[] annotationEntryGens) {
        if (annotationEntryGens.length == 0) {
            return new Attribute[0];
        }
        try {
            ByteArrayOutputStream riaBytes;
            ByteArrayOutputStream rvaBytes;
            int countVisible = 0;
            int countInvisible = 0;
            AnnotationEntryGen[] annotationEntryGenArray = annotationEntryGens;
            int n = annotationEntryGens.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    rvaBytes = new ByteArrayOutputStream();
                    riaBytes = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    annotationEntryGenArray = null;
                    try {
                        DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
                        try {
                            try (DataOutputStream riaDos = new DataOutputStream(riaBytes);){
                                rvaDos.writeShort(countVisible);
                                riaDos.writeShort(countInvisible);
                                AnnotationEntryGen[] annotationEntryGenArray2 = annotationEntryGens;
                                int n3 = annotationEntryGens.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    AnnotationEntryGen a = annotationEntryGenArray2[n4];
                                    if (a.isRuntimeVisible()) {
                                        a.dump(rvaDos);
                                    } else {
                                        a.dump(riaDos);
                                    }
                                    ++n4;
                                }
                            }
                            if (rvaDos == null) break;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (rvaDos == null) throw throwable;
                            rvaDos.close();
                            throw throwable;
                        }
                        rvaDos.close();
                        break;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                AnnotationEntryGen a = annotationEntryGenArray[n2];
                if (a.isRuntimeVisible()) {
                    ++countVisible;
                } else {
                    ++countInvisible;
                }
                ++n2;
            }
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (rvaData.length > 2) {
                rvaIndex = cp.addUtf8("RuntimeVisibleAnnotations");
            }
            if (riaData.length > 2) {
                riaIndex = cp.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList<Annotations> newAttributes = new ArrayList<Annotations>();
            if (rvaData.length > 2) {
                newAttributes.add(new RuntimeVisibleAnnotations(rvaIndex, rvaData.length, new DataInputStream(new ByteArrayInputStream(rvaData)), cp.getConstantPool()));
            }
            if (riaData.length <= 2) return newAttributes.toArray(new Attribute[newAttributes.size()]);
            newAttributes.add(new RuntimeInvisibleAnnotations(riaIndex, riaData.length, new DataInputStream(new ByteArrayInputStream(riaData)), cp.getConstantPool()));
            return newAttributes.toArray(new Attribute[newAttributes.size()]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing annotations");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Attribute[] getParameterAnnotationAttributes(ConstantPoolGen cp, List<AnnotationEntryGen>[] vec) {
        int[] visCount = new int[vec.length];
        int totalVisCount = 0;
        int[] invisCount = new int[vec.length];
        int totalInvisCount = 0;
        try {
            DataOutputStream rvaDos232;
            int i = 0;
            while (i < vec.length) {
                if (vec[i] != null) {
                    for (AnnotationEntryGen annotationEntryGen : vec[i]) {
                        if (annotationEntryGen.isRuntimeVisible()) {
                            int n = i;
                            visCount[n] = visCount[n] + 1;
                            ++totalVisCount;
                            continue;
                        }
                        int n = i;
                        invisCount[n] = invisCount[n] + 1;
                        ++totalInvisCount;
                    }
                }
                ++i;
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object object = null;
            try {
                rvaDos232 = new DataOutputStream(rvaBytes);
                try {
                    rvaDos232.writeByte(vec.length);
                    int i2 = 0;
                    while (i2 < vec.length) {
                        rvaDos232.writeShort(visCount[i2]);
                        if (visCount[i2] > 0) {
                            for (AnnotationEntryGen element3 : vec[i2]) {
                                if (!element3.isRuntimeVisible()) continue;
                                element3.dump(rvaDos232);
                            }
                        }
                        ++i2;
                    }
                }
                finally {
                    if (rvaDos232 != null) {
                        rvaDos232.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                void var7_13;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var7_13;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = null;
            rvaDos232 = null;
            try (DataOutputStream riaDos = new DataOutputStream(byteArrayOutputStream);){
                riaDos.writeByte(vec.length);
                int i3 = 0;
                while (i3 < vec.length) {
                    riaDos.writeShort(invisCount[i3]);
                    if (invisCount[i3] > 0) {
                        for (AnnotationEntryGen element4 : vec[i3]) {
                            if (element4.isRuntimeVisible()) continue;
                            element4.dump(riaDos);
                        }
                    }
                    ++i3;
                }
            }
            catch (Throwable rvaDos232) {
                if (object == null) {
                    object = rvaDos232;
                } else if (object != rvaDos232) {
                    ((Throwable)object).addSuppressed(rvaDos232);
                }
                throw object;
            }
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = byteArrayOutputStream.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (totalVisCount > 0) {
                rvaIndex = cp.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (totalInvisCount > 0) {
                riaIndex = cp.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<ParameterAnnotations> newAttributes = new ArrayList<ParameterAnnotations>();
            if (totalVisCount > 0) {
                newAttributes.add(new RuntimeVisibleParameterAnnotations(rvaIndex, rvaData.length, new DataInputStream(new ByteArrayInputStream(rvaData)), cp.getConstantPool()));
            }
            if (totalInvisCount > 0) {
                newAttributes.add(new RuntimeInvisibleParameterAnnotations(riaIndex, riaData.length, new DataInputStream(new ByteArrayInputStream(riaData)), cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[newAttributes.size()]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing parameter annotations");
            e.printStackTrace();
            return null;
        }
    }
}

