/*
 * Decompiled with CFR 0.152.
 */
package ext.scf8.cluster.controller;

import ext.appfw.common.AfbXmlUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.net.BcAddressPort;
import ext.base.xml.BcXmlUtil;
import ext.scf.scheduler.ScfTimerTask;
import ext.scf.server.ScfAbstractServerModule;
import ext.scf.server.ScfServerContainer;
import ext.scf8.cluster.common.KscfClusterEventHandler;
import ext.scf8.cluster.common.KscfClusterNode;
import ext.scf8.cluster.controller.KscfMulticastReceiver;
import ext.scf8.cluster.controller.KscfMulticastSender;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.w3c.dom.Node;

public class KscfClusterController
extends ScfAbstractServerModule {
    protected String nodeId;
    protected BcAddressPort multicastAddressPort;
    protected KscfMulticastReceiver multicastReceiver;
    protected KscfMulticastSender multicastSender;
    protected Map<String, KscfClusterNode> nodeMap;
    protected List<KscfClusterNode> clusterNodeList;
    protected long heartBeatInterval;
    protected long heartBeatCheckInterval;
    protected long dropTime;
    protected FwHeartBeatTask heartBeatTask;
    protected FwHeartBeatCheckTask heartBeatCheckTask;
    protected String nodeType;
    public List<KscfClusterEventHandler> clusterEventHadlerList;

    @Override
    public void init() throws Exception {
        Node baseNode = BcXmlUtil.getNode(ScfServerContainer.getInstance().getConfig(), "cluster");
        if (baseNode != null) {
            this.nodeId = BcXmlUtil.getTextValue(baseNode, "nodeId");
            this.nodeId = String.valueOf(this.nodeId) + "@" + InetAddress.getLocalHost().getHostName() + "[" + System.nanoTime() + "]";
            BcLogUtil.info("nodeId=" + this.nodeId);
            this.multicastAddressPort = new BcAddressPort();
            AfbXmlUtil.parseAddressPort(baseNode, this.multicastAddressPort);
            BcLogUtil.info("multicastAddress=" + this.multicastAddressPort.address);
            BcLogUtil.info("multicastPort=" + this.multicastAddressPort.port);
            this.heartBeatInterval = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "heartBeat/sendInterval"), -1);
            this.heartBeatCheckInterval = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "heartBeat/checkInterval"), -1);
            this.dropTime = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "heartBeat/dropTime"), -1);
            this.multicastReceiver = new KscfMulticastReceiver(this);
            this.multicastSender = new KscfMulticastSender(this);
        }
        this.nodeMap = new HashMap<String, KscfClusterNode>();
        this.clusterEventHadlerList = new ArrayList<KscfClusterEventHandler>();
    }

    @Override
    public void start() throws Exception {
        if (this.multicastAddressPort == null) {
            return;
        }
        this.multicastReceiver.setup(this.multicastAddressPort);
        this.multicastSender.setup(this.multicastAddressPort);
        this.heartBeatTask = new FwHeartBeatTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.heartBeatTask, this.heartBeatInterval, this.heartBeatInterval);
        this.heartBeatCheckTask = new FwHeartBeatCheckTask();
        Timer timer2 = new Timer();
        timer2.schedule((TimerTask)this.heartBeatCheckTask, this.heartBeatCheckInterval, this.heartBeatCheckInterval);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public KscfMulticastSender getSender() {
        return this.multicastSender;
    }

    public KscfMulticastReceiver getReceiver() {
        return this.multicastReceiver;
    }

    public Map getCulsuterMap() {
        return this.nodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterNode(KscfClusterNode clusterNode, boolean isEntry) {
        Map<String, KscfClusterNode> map = this.nodeMap;
        synchronized (map) {
            if (!this.nodeMap.containsKey(clusterNode.id)) {
                this.nodeMap.put(clusterNode.id, clusterNode);
                this.clusterNodeList = null;
                BcLogUtil.info("addClusterNode:clusterNode.id=" + clusterNode.id);
            } else if (isEntry) {
                BcLogUtil.info("addClusterNode:clusterNode.id is already exsits.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KscfClusterNode> getClusterNodeList() {
        Map<String, KscfClusterNode> map = this.nodeMap;
        synchronized (map) {
            if (this.clusterNodeList != null) {
                return this.clusterNodeList;
            }
            ArrayList<KscfClusterNode> clusterNodeList2 = new ArrayList<KscfClusterNode>();
            Set<Map.Entry<String, KscfClusterNode>> entrySet = this.nodeMap.entrySet();
            for (Map.Entry<String, KscfClusterNode> mapEntry : entrySet) {
                clusterNodeList2.add(mapEntry.getValue());
            }
            this.clusterNodeList = clusterNodeList2;
        }
        return this.clusterNodeList;
    }

    public boolean hasMember() {
        return this.nodeMap.size() > 0;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String addNodeType(String nodeType2) {
        BcLogUtil.debug("addNodeType:nodeType2=" + nodeType2);
        if (this.nodeType == null) {
            this.nodeType = "";
        }
        this.nodeType = String.valueOf(this.nodeType) + nodeType2;
        return this.nodeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartBeatRecieve(String clusterNodeId) {
        Map<String, KscfClusterNode> map = this.nodeMap;
        synchronized (map) {
            KscfClusterNode clusterNode = this.nodeMap.get(clusterNodeId);
            if (clusterNode != null) {
                clusterNode.lasrHeartBeat = System.currentTimeMillis();
            } else {
                BcLogUtil.warning("cluster heartBeatRecieve error clusterNodeId=" + clusterNodeId);
            }
        }
    }

    public void notifyNodeType() throws Exception {
        Object[] dataArray = new Object[]{this.nodeType};
        if (this.multicastSender != null) {
            this.multicastSender.send(51, dataArray);
        }
    }

    public int extractNo(String srcStr, String type) {
        BcLogUtil.debug("extractNo:srcStr=" + srcStr + " type=" + type);
        int psNo = -1;
        if (BcStringUtil.isEmpty(srcStr)) {
            return psNo;
        }
        int pos1 = srcStr.indexOf(type);
        if (pos1 >= 0) {
            int pos2 = srcStr.indexOf("]", pos1);
            psNo = BcNumberUtil.parseInteger(srcStr.substring(pos1 + type.length() + 1, pos2));
        }
        BcLogUtil.debug("extractNo:psNo=" + psNo);
        return psNo;
    }

    public boolean isMostYong(String type, int psNo) {
        BcLogUtil.debug("isMostYong:type=" + type + " psNo=" + psNo);
        boolean resValue = true;
        List<KscfClusterNode> clusterNodeList2 = this.getClusterNodeList();
        int i = 0;
        while (i < clusterNodeList2.size()) {
            KscfClusterNode clusterNode = clusterNodeList2.get(i);
            int psNo2 = this.extractNo(clusterNode.type, type);
            if (psNo2 > 0 && psNo2 < psNo) {
                resValue = false;
                break;
            }
            if (psNo2 == psNo) {
                BcLogUtil.error("cluster error:1021");
            }
            ++i;
        }
        BcLogUtil.debug("isMostYong:resValue=" + resValue);
        return resValue;
    }

    public KscfClusterNode searchNodeType(String nodoType2) {
        List<KscfClusterNode> clusterNodeList2 = this.getClusterNodeList();
        int i = 0;
        while (i < clusterNodeList2.size()) {
            KscfClusterNode clusterNode = clusterNodeList2.get(i);
            if (clusterNode.type != null && clusterNode.type.indexOf(nodoType2) >= 0) {
                return clusterNode;
            }
            ++i;
        }
        return null;
    }

    public int countNodeType(String nodoType2) {
        int cnt = 0;
        List<KscfClusterNode> clusterNodeList2 = this.getClusterNodeList();
        int i = 0;
        while (i < clusterNodeList2.size()) {
            KscfClusterNode clusterNode = clusterNodeList2.get(i);
            if (clusterNode.type != null && clusterNode.type.indexOf(nodoType2) >= 0) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public int getNodeTypeMaxNo(String nodoType2) {
        int psNo1 = -1;
        List<KscfClusterNode> clusterNodeList2 = this.getClusterNodeList();
        int i = 0;
        while (i < clusterNodeList2.size()) {
            int psNo2;
            KscfClusterNode clusterNode = clusterNodeList2.get(i);
            if (clusterNode.type != null && clusterNode.type.indexOf(nodoType2) >= 0 && (psNo2 = this.extractNo(clusterNode.type, nodoType2)) > psNo1) {
                psNo1 = psNo2;
            }
            ++i;
        }
        return psNo1;
    }

    public void notifyNodeRemoved(KscfClusterNode clusterNode) {
        KscfClusterEventHandler[] clusterEventHandlers = this.clusterEventHadlerList.toArray(new KscfClusterEventHandler[0]);
        int i = 0;
        while (i < clusterEventHandlers.length) {
            clusterEventHandlers[i].nodeRemoved(clusterNode);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterEventHandler(KscfClusterEventHandler eventHandler) {
        List<KscfClusterEventHandler> list = this.clusterEventHadlerList;
        synchronized (list) {
            this.clusterEventHadlerList.add(eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterEventHandler(KscfClusterEventHandler eventHandler) {
        List<KscfClusterEventHandler> list = this.clusterEventHadlerList;
        synchronized (list) {
            this.clusterEventHadlerList.remove(eventHandler);
        }
    }

    public void heartBeatCheck() {
        long now = System.currentTimeMillis();
        List<KscfClusterNode> clusterNodeList2 = this.getClusterNodeList();
        int i = 0;
        while (i < clusterNodeList2.size()) {
            KscfClusterNode clusterNode = clusterNodeList2.get(i);
            if (now - clusterNode.lasrHeartBeat >= this.dropTime) {
                KscfClusterNode clusterNode2 = this.nodeMap.remove(clusterNode.id);
                if (clusterNode2 != null) {
                    this.clusterNodeList = null;
                    BcLogUtil.info("heartBeatCheck:down nodeId=" + clusterNode2.id);
                    this.notifyNodeRemoved(clusterNode2);
                } else {
                    BcLogUtil.error("cluster error:2011");
                }
            }
            ++i;
        }
    }

    protected class FwHeartBeatCheckTask
    extends ScfTimerTask {
        @Override
        protected void run2() throws Exception {
            KscfClusterController.this.heartBeatCheck();
        }
    }

    protected class FwHeartBeatTask
    extends ScfTimerTask {
        @Override
        protected void run2() throws Exception {
            KscfClusterController.this.getSender().send(61, KscfClusterController.this.getNodeId());
        }
    }
}

