/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.base.core.BcInteger;
import ext.lib.swg.SwgArrangementHint;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgTextArea;
import ext.lib.swg.SwgUtil;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;

public class HswgComponentFactory {
    protected static SwgArrangementHint arrangementHint1;

    private HswgComponentFactory() throws Exception {
    }

    public static SwgArrangementHint createArrangementHint(Font baseFont) throws Exception {
        SwgArrangementHint arrangementHint = new SwgArrangementHint();
        arrangementHint.topMargin = 2;
        arrangementHint.leftMargin = 4;
        arrangementHint.rowHeight = SwgUtil.getTextFieldSize((Font)baseFont).height;
        arrangementHint.rowSpace = 0;
        arrangementHint.labelWidth = SwgUtil.getTextFieldSize((Font)baseFont, (int)14).width;
        arrangementHint.columnSpace = SwgUtil.getRowDiff(baseFont);
        arrangementHint.fieldX = arrangementHint.leftMargin + arrangementHint.labelWidth + arrangementHint.columnSpace;
        arrangementHint.fieldWidth = SwgUtil.getTextFieldSize((Font)baseFont, (int)28).width;
        return arrangementHint;
    }

    public static SwgArrangementHint createArrangementHint() throws Exception {
        SwgArrangementHint arrangementHint = HswgComponentFactory.createArrangementHint(SwgLafManager.getInstance().font);
        return arrangementHint;
    }

    public static SwgArrangementHint getArrangementHint() throws Exception {
        if (arrangementHint1 != null) {
            return arrangementHint1;
        }
        arrangementHint1 = HswgComponentFactory.createArrangementHint(SwgLafManager.getInstance().font);
        return arrangementHint1;
    }

    public static void setLocation(JComponent container, JComponent component1, JComponent component2, int component2Width, SwgArrangementHint arrangementHint, BcInteger ly, int xOffset) throws Exception {
        SwgUtil.setLocation(container, component1, (double)(arrangementHint.leftMargin + xOffset), (double)ly.value, (double)arrangementHint.labelWidth, (double)arrangementHint.rowHeight);
        if (component2Width > 0) {
            component2.setPreferredSize(new Dimension(component2Width, component2.getPreferredSize().height));
        }
        SwgUtil.setLocation(container, component2, (double)(arrangementHint.fieldX + xOffset), (double)ly.value, (double)component2.getPreferredSize().width, (double)arrangementHint.rowHeight);
    }

    public static void setLocation(JComponent container, JComponent component1, JComponent component2, SwgArrangementHint arrangementHint, BcInteger ly, int xOffset) throws Exception {
        HswgComponentFactory.setLocation(container, component1, component2, -1, arrangementHint, ly, xOffset);
    }

    public static void setLocation(JComponent container, JComponent component1, JComponent component2, SwgArrangementHint arrangementHint, BcInteger ly) throws Exception {
        HswgComponentFactory.setLocation(container, component1, component2, arrangementHint, ly, 0);
    }

    public static void setLocation(JComponent container, CharSequence labelName, JComponent component2, int component2Width, SwgArrangementHint arrangementHint, BcInteger ly, int xOffset) throws Exception {
        SwgLabel label = new SwgLabel(labelName.toString(), 4);
        HswgComponentFactory.setLocation(container, label, component2, component2Width, arrangementHint, ly, xOffset);
    }

    public static void setLocation(JComponent container, CharSequence labelName, JComponent component2, SwgArrangementHint arrangementHint, BcInteger ly, int xOffset) throws Exception {
        HswgComponentFactory.setLocation(container, labelName, component2, -1, arrangementHint, ly, xOffset);
    }

    public static void setLocation(JComponent container, CharSequence labelName, JComponent component2, int component2Width, SwgArrangementHint arrangementHint, BcInteger ly) throws Exception {
        HswgComponentFactory.setLocation(container, labelName, component2, component2Width, arrangementHint, ly, 0);
    }

    public static void setLocation(JComponent container, JComponent component, SwgArrangementHint arrangementHint, BcInteger ly) throws Exception {
        SwgUtil.setLocation(container, component, (double)arrangementHint.leftMargin, (double)ly.value, (double)component.getPreferredSize().width, (double)arrangementHint.rowHeight);
    }

    public static SwgTextArea createTextArea(JComponent parentComponent, SwgArrangementHint arrangementHint, BcInteger ly, String name, int charLength, int rowCount) throws Exception {
        SwgLabel label = new SwgLabel(name, 4);
        SwgUtil.setLocation(parentComponent, label, (double)arrangementHint.leftMargin, (double)ly.value, (double)arrangementHint.labelWidth, (double)arrangementHint.rowHeight);
        int textFieldWidth = SwgUtil.getTextFieldSize((Font)parentComponent.getFont(), (int)charLength).width;
        int textFieldHeight = SwgUtil.getTextFieldSize((Font)parentComponent.getFont()).height * rowCount;
        SwgTextArea textArea = new SwgTextArea();
        SwgUtil.setLocation(parentComponent, textArea, (double)(label.getBounds().x + label.getBounds().width + arrangementHint.columnSpace), (double)ly.value, (double)textFieldWidth, (double)textFieldHeight);
        return textArea;
    }
}

