/*
 * Decompiled with CFR 0.152.
 */
package ext.scf3.rmo;

import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableModel;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.scf.common.ScfHandle;
import ext.scf.common.ScfHandleImpl;
import ext.scf.server.ScfServerContainer;
import ext.scf2.server.ScfTableHandleResource;
import ext.scf3.server.ScfSqlHandleResolver;
import ext.scf3.server.ScfSqlHandleResource;
import ext.scf3.server.ScfSqlTask;
import ext.scf3.server.ScfTableModelTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ScfSqlUtil {
    private ScfSqlUtil() {
    }

    public static SqlStatement createStatement(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlStatement stmt = null;
        stmt = sqlContext.isScrollSupport() ? sqlContext.createStatementForScroll(dtsSession.getConnection()) : sqlContext.createStatementForForward(dtsSession.getConnection());
        return stmt;
    }

    public static void setRespons(RmiRespons rmiRes, ScfHandle handle, List<BcTableColumn> tableColumnList, BcTableContext tableContext) throws Exception {
        rmiRes.putData((Object)new Integer(0), new Boolean(true));
        rmiRes.putData((Object)"hId", handle.getHandleId());
        rmiRes.putData((Object)"tableColumnList", tableColumnList);
        rmiRes.putData((Object)"tb_ctx", tableContext);
    }

    public static void setRespons(SqlContext sqlContext, RmiRespons rmiRes, ScfHandle handle, List<BcTableColumn> tableColumnList, BcTableContext tableContext, SqlResultSet rs) throws Exception {
        ScfSqlUtil.setRespons(rmiRes, handle, tableColumnList, tableContext);
        if (sqlContext.isScrollSupport()) {
            rs.last();
            int rowCownt = rs.getRow();
            rmiRes.putData((Object)"tb_rs", rowCownt);
            rs.beforeFirst();
        }
        tableContext.elapsedTime = rs.getEndTime() - rs.getStartTime();
    }

    public static void setRespons(RmiRespons rmiRes, ScfHandle handle, Object result) throws Exception {
        rmiRes.putData((Object)new Integer(0), new Boolean(true));
        rmiRes.putData((Object)"hId", handle.getHandleId());
        rmiRes.putData((Object)"tableColumnList", result);
    }

    public static void setRespons(DtsSession dtsSession, SqlResultSet rs, List<BcTableColumn> tableColumnList, BcTableContext tableContext, RmiRmoArgument rmoArg) throws Exception {
        ScfSqlHandleResource sqlHandleResource = new ScfSqlHandleResource();
        sqlHandleResource.setDBResource(dtsSession, rs, tableColumnList);
        ScfHandleImpl handle = new ScfHandleImpl();
        handle.setOwner(rmoArg.getAgent());
        handle.addHandleResource(sqlHandleResource);
        ScfServerContainer.getInstance().getHandleManager().addHandle(handle);
        ScfSqlUtil.setRespons(dtsSession.getSqlContext(), rmoArg.getRespons(), handle, tableColumnList, tableContext, rs);
    }

    public static void setRespons(DtsSession dtsSession, SqlResultSet rs, List<BcTableColumn> tableColumnList, RmiRmoArgument rmoArg) throws Exception {
        ScfSqlUtil.setRespons(dtsSession, rs, tableColumnList, new BcTableContext(), rmoArg);
    }

    public static void setRespons(RmiRespons rmiRes, ScfHandle handle, List<BcTableColumn> tableColumnList, BcTableModel tableModel, BcTableContext tableContext) throws Exception {
        rmiRes.putData((Object)new Integer(0), new Boolean(true));
        rmiRes.putData((Object)"hId", handle.getHandleId());
        rmiRes.putData((Object)"tableColumnList", tableColumnList);
        rmiRes.putData((Object)"tb_rs", tableModel.getRowCount());
        rmiRes.putData((Object)"tb_ctx", tableContext);
    }

    public static void setSqlTaskField(ScfSqlTask sqlTask, RmiRmoArgument rmoArg, DtsSession dtsSession, DtsWordManager wordManager) throws Exception {
        sqlTask.rmoArg = rmoArg;
        sqlTask.dtsSession = dtsSession;
        sqlTask.locale = dtsSession.getLocale();
        sqlTask.wordManager = wordManager;
        sqlTask.stmt = ScfSqlUtil.createStatement(dtsSession);
    }

    public static void setSqlTaskField(ScfSqlTask sqlTask, RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.createDtsSession();
        DtsWordManager wordManager = dtsSession.getSessionFactory().wordManager;
        ScfSqlUtil.setSqlTaskField(sqlTask, rmoArg, dtsSession, wordManager);
    }

    public static ScfSqlTask createSqlTask(RmiRmoArgument rmoArg, DtsSession dtsSession) throws Exception {
        ScfSqlTask sqlTask = new ScfSqlTask();
        DtsSessionFactory dtsSessionFactory = dtsSession.getSessionFactory();
        DtsWordManager wordManager = dtsSessionFactory.wordManager;
        ScfSqlUtil.setSqlTaskField(sqlTask, rmoArg, dtsSession, wordManager);
        return sqlTask;
    }

    public static ScfSqlTask createSqlTask(RmiRmoArgument rmoArg) throws Exception {
        return ScfSqlUtil.createSqlTask(rmoArg, rmoArg.createDtsSession());
    }

    public static void setTableModelTaskField(ScfTableModelTask tableModelTask, RmiRmoArgument rmoArg) throws Exception {
        tableModelTask.rmoArg = rmoArg;
    }

    public static void generalListNew(ScfSqlTask sqlTask, Object owner) throws Exception {
        ScfHandleImpl handle = new ScfHandleImpl();
        handle.setOwner(owner);
        ScfServerContainer.getInstance().getHandleManager().addHandle(handle);
        sqlTask.handle = handle;
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future response = executorService.submit(sqlTask);
        ScfSqlHandleResource sqlHandleResource = new ScfSqlHandleResource();
        sqlHandleResource.sqlTask = sqlTask;
        handle.setOwner(owner);
        handle.addHandleResource(sqlHandleResource);
        RmiRespons rmiRes = sqlTask.rmoArg.getRespons();
        rmiRes.putData((Object)"hId", handle.getHandleId());
    }

    public static void generalListNew(ScfTableModelTask \uff54ableModelTask, Object owner) throws Exception {
        ScfHandleImpl handle = new ScfHandleImpl();
        handle.setOwner(owner);
        ScfServerContainer.getInstance().getHandleManager().addHandle(handle);
        \uff54ableModelTask.handle = handle;
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future response = executorService.submit(\uff54ableModelTask);
        ScfTableHandleResource tableHandleResource = new ScfTableHandleResource();
        tableHandleResource.tmpObject = \uff54ableModelTask;
        handle.setOwner(owner);
        handle.addHandleResource(tableHandleResource);
        RmiRespons rmiRes = \uff54ableModelTask.rmoArg.getRespons();
        rmiRes.putData((Object)"hId", handle.getHandleId());
    }

    public static void generalList(RmiRmoArgument rmoArg, DtsSession dtsSession1, String query, List<String> tableColumnNameList, Map<String, MmdField> mmdFieldMap, DtsWordManager wordManager, Locale locale, BcTableContext tableContext) throws Exception {
        SqlStatement stmt = ScfSqlUtil.createStatement(dtsSession1);
        try {
            SqlResultSet rs = stmt.executeQuery(query);
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(rs.getMetaData(), tableColumnNameList, mmdFieldMap, wordManager, locale);
            ScfSqlUtil.setRespons(dtsSession1, rs, tableColumnList, tableContext, rmoArg);
        }
        catch (Exception ex) {
            stmt.close();
            throw ex;
        }
    }

    public static void generalList(RmiRmoArgument rmoArg, DtsSession dtsSession, String sql, List<String> tableColumnNameList, BcTableContext tableContext) throws Exception {
        Map<String, MmdField> mmdFieldMap = dtsSession.getSessionFactory().mmdFieldMap;
        DtsWordManager wordManager = dtsSession.getSessionFactory().wordManager;
        ScfSqlUtil.generalList(rmoArg, dtsSession, sql, tableColumnNameList, mmdFieldMap, wordManager, dtsSession.getLocale(), tableContext);
    }

    public static void generalList(RmiRmoArgument rmoArg, DtsSession dtsSession, String sql, BcTableContext tableContext) throws Exception {
        ScfSqlUtil.generalList(rmoArg, dtsSession, sql, null, tableContext);
    }

    public static void generalList(RmiRmoArgument rmoArg, DtsSession dtsSession, SqlSelectSql selectSql, BcTableContext tableContext) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = sqlContext.buildSelectSql(selectSql);
        ScfSqlUtil.generalList(rmoArg, dtsSession, query, selectSql.getSelectColumnList(), tableContext);
    }

    public static void generalList(RmiRmoArgument rmoArg, DtsSession dtsSession, SqlSelectSql selectSql, List conditionList) throws Exception {
        BcTableContext tableContext = new BcTableContext();
        tableContext.title = selectSql.getFromClause();
        tableContext.tableName = selectSql.getMainTableName();
        tableContext.setConditionList(conditionList);
        ScfSqlUtil.generalList(rmoArg, dtsSession, selectSql, tableContext);
    }

    public static void generalList(RmiRmoArgument rmoArg, DtsSession dtsSession, SqlSelectSql selectSql) throws Exception {
        ScfSqlUtil.generalList(rmoArg, dtsSession, selectSql, new ArrayList());
    }

    public static void generalList(RmiRmoArgument rmoArg, String query, BcTableContext tableContext) throws Exception {
        DtsSession dtsSession = rmoArg.createDtsSession();
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfSqlUtil.generalList(rmoArg, dtsSession, query, null, tableContext);
    }

    public static void generalList(RmiRmoArgument rmoArg, SqlSelectSql selectSql) throws Exception {
        DtsSession dtsSession = rmoArg.createDtsSession();
        ScfSqlUtil.generalList(rmoArg, dtsSession, selectSql);
    }

    public static void setResponsForResolver(RmiRmoArgument rmoArg, DtsSession dtsSession, SqlResultSet rs, List<BcTableColumn> tableColumnList, ScfSqlHandleResolver sqlHandleResolver) throws Exception {
        ScfSqlHandleResource sqlHandleResource = new ScfSqlHandleResource();
        sqlHandleResource.setDBResource(dtsSession, rs, tableColumnList);
        sqlHandleResource.sqlHandleResolver = sqlHandleResolver;
        ScfHandleImpl handle = new ScfHandleImpl();
        handle.setOwner(rmoArg.getAgent());
        handle.addHandleResource(sqlHandleResource);
        ScfServerContainer.getInstance().getHandleManager().addHandle(handle);
        ScfSqlUtil.setRespons(dtsSession.getSqlContext(), rmoArg.getRespons(), handle, tableColumnList, new BcTableContext(), rs);
    }

    public static void setResponsForResolver(RmiRmoArgument rmoArg, DtsSession dtsSession, SqlResultSet rs, List<BcTableColumn> tableColumnList, ScfSqlHandleResolver sqlHandleResolver, Object owner) throws Exception {
        ScfSqlUtil.setResponsForResolver(rmoArg, dtsSession, rs, tableColumnList, sqlHandleResolver);
    }

    public static void setResponsForResolver(RmiRmoArgument rmoArg, SqlResultSet rs, List<BcTableColumn> tableColumnList, ScfSqlHandleResolver sqlHandleResolver, Object owner) throws Exception {
        DtsSession dtsSession = rmoArg.getSessionFactory().createSession(owner);
        ScfSqlUtil.setResponsForResolver(rmoArg, dtsSession, rs, tableColumnList, sqlHandleResolver);
    }

    public static void setResponsForResolver(RmiRmoArgument rmoArg, DtsSession dtsSession, CharSequence query, List<String> columnNameList, ScfSqlHandleResolver sqlHandleResolver, Object owner) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlStatement stmt = ScfSqlUtil.createStatement(dtsSession);
        try {
            SqlResultSet rs = stmt.executeQuery(query.toString());
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData(), columnNameList);
            ScfSqlUtil.setResponsForResolver(rmoArg, dtsSession, rs, tableColumnList, sqlHandleResolver, owner);
        }
        catch (Exception ex) {
            stmt.close();
            throw ex;
        }
    }

    public static void setResponsForResolver(RmiRmoArgument rmoArg, SqlSelectSql selectSql, ScfSqlHandleResolver sqlHandleResolver, Object owner) throws Exception {
        DtsSession dtsSession = rmoArg.getSessionFactory().createSession(owner);
        String query = dtsSession.getSqlContext().buildSelectSql(selectSql);
        ScfSqlUtil.setResponsForResolver(rmoArg, rmoArg.getDtsSession(owner), query, selectSql.getSelectColumnList(), sqlHandleResolver, owner);
    }
}

