/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.server;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbApplicationSetup;
import ext.appfw.common.AfbLogUtil;
import ext.appfw.common.AfbShutdownManager;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcArgumentUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.rmi.server.RmiServer;
import ext.scf.rmi.server.RmiServerModule;
import ext.scf.server.ScfAgentEventHandler;
import ext.scf.server.ScfServerContainer;
import ext.scf.server.ScfServerShutdownTask;
import ext.scf.util.ScfSetupUtil;
import java.io.File;
import java.io.FileNotFoundException;
import org.w3c.dom.Document;

public class ScfServerSetup
implements AfbApplicationSetup {
    protected ScfAgentEventHandler agentEventHandler = new ScfAgentEventHandler();

    @Override
    public void setup(AfbApplication application) throws Exception {
        String serverCofigPath;
        File file;
        String vFilePath = BcArgumentUtil.getArgumentValue(application.getMainArguments(), "-svcfg");
        if (BcStringUtil.isEmpty(vFilePath)) {
            vFilePath = "${ROOT}config/server.xml";
        }
        if (!(file = new File(serverCofigPath = application.toReal(vFilePath))).exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        Document serverConfigDom = BcXmlUtil.createDocument(file);
        BcLogUtil.info(AfbLogUtil.serverModeLog(application));
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        serverContainer.setConfig(serverConfigDom);
        this.setupCommon(application);
    }

    public void setupCommon(AfbApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        RmiServerModule rmiServerModule = serverContainer.rmiServerModule;
        rmiServerModule.init(application.isServer());
        RmiServer rmiServer = rmiServerModule.getServer();
        rmiServer.addAgentEventHandler(this.agentEventHandler);
        ScfSetupUtil.loadModule(serverContainer, application.getBootConfig(), "serverModule");
        serverContainer.initModule();
        ScfServerShutdownTask serverShutdownTask = new ScfServerShutdownTask();
        AfbShutdownManager.getInstance().addShutdownTask(serverShutdownTask);
    }

    @Override
    public void start(AfbApplication application) throws Exception {
        ScfServerContainer serverContainer = ScfServerContainer.getInstance();
        RmiServerModule rmiServerModule = serverContainer.rmiServerModule;
        rmiServerModule.start();
        serverContainer.startModule();
        BcLogUtil.info("All server modules started.");
    }
}

