/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.rmi.server;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbXmlUtil;
import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.net.BcAddressPort;
import ext.base.xml.BcXmlUtil;
import ext.lib.rmi.server.RmiServer;
import ext.scf.rmi.server.RmiLogHandlerImpl;
import ext.scf.server.ScfAbstractServerModule;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RmiServerModule
extends ScfAbstractServerModule {
    protected String loggerName = "rmi_server";
    public RmiServer rmiServer = new RmiServer();

    @Override
    public void setModuleNode(Node domNode) throws Exception {
    }

    public void init(boolean isServer) throws Exception {
        File logFile = new File(String.valueOf(AfbApplication.getInstance().getRootDirectry().getPath()) + "/log/rmix_server.log");
        BcLogUtil.createLogger(this.loggerName, BcLogConstants.LogLevel.DEBUG, logFile);
        System.out.println("init:#2");
        if (isServer) {
            String cofigPath = AfbApplication.getInstance().toReal("${ROOT}config/rmix_server.xml");
            File configFile = new File(cofigPath);
            if (!configFile.exists()) {
                this.getLogger().info("RMI Server config file is not found.");
                return;
            }
            Document configDom = BcXmlUtil.createDocument(configFile);
            Node node_tcpListen = BcXmlUtil.getNode(configDom, "tcpListen");
            BcAddressPort addressPort = new BcAddressPort();
            AfbXmlUtil.parseAddressPort(node_tcpListen, addressPort);
            this.rmiServer.setAddressPort(addressPort);
            this.rmiServer.heartBeatCheckInterval = BcNumberUtil.parseLong(BcXmlUtil.getTextValue(configDom, "heartBeat/checkInterval"), -1L);
            this.rmiServer.heartBeatDropMillis = BcNumberUtil.parseLong(BcXmlUtil.getTextValue(configDom, "heartBeat/dropTime"), -1L);
            this.rmiServer.clientMax = BcNumberUtil.parseInteger(BcXmlUtil.getTextValue(configDom, "clientMax"), -1);
            this.getLogger().info("lintenAddress=" + addressPort.address);
            this.getLogger().info("lintenPort=" + addressPort.port);
            this.getLogger().info("heartBeatCheckInterval=" + this.rmiServer.heartBeatCheckInterval);
            this.getLogger().info("heartBeatDropTime=" + this.rmiServer.heartBeatDropMillis);
            this.getLogger().info("clientMax=" + this.rmiServer.clientMax);
        } else {
            BcAddressPort addressPort = new BcAddressPort();
            addressPort.address = "localhost";
            addressPort.port = 0;
            this.rmiServer.setAddressPort(addressPort);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.rmiServer != null) {
            this.rmiServer.logHandler = new RmiLogHandlerImpl();
            this.rmiServer.init();
        }
    }

    @Override
    public void end() throws Exception {
        if (this.rmiServer != null) {
            this.rmiServer.stop();
        }
    }

    public RmiServer getServer() {
        return this.rmiServer;
    }
}

