/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.datasource;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScfDatasourceConfigParser {
    public static final String TAG_datasource = "datasource";

    public List<DtsSessionFactory> parseDatasourceConfig(Document xmlDoc, DtsSessionFactoryManegaer sessionFactoryManegaer) throws Exception {
        ArrayList<DtsSessionFactory> dtsSessionFactoryList = new ArrayList<DtsSessionFactory>();
        List<Node> nodeList1 = BcXmlUtil.getNodeList((Node)xmlDoc, (short)1);
        int i = 0;
        while (i < nodeList1.size()) {
            Node node1 = nodeList1.get(i);
            if (!node1.getNodeName().equals(TAG_datasource)) {
                throw new Exception("not suported node '" + node1.getNodeName() + "'");
            }
            String name = BcXmlUtil.getAttribute(node1, "name");
            DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
            this.setupDatasourceL2(connectionManager, node1);
            DtsSessionFactory dtsSessionFactory = new DtsSessionFactory(name, connectionManager);
            sessionFactoryManegaer.addSessionFactory(dtsSessionFactory);
            dtsSessionFactoryList.add(dtsSessionFactory);
            ++i;
        }
        return dtsSessionFactoryList;
    }

    protected void setupDatasourceL2(DtsConnectionManager connectionManager, Node baseNode) throws Exception {
        String driverClassName = BcXmlUtil.getTextValue(baseNode, "jdbcDriver");
        Driver driver = SqlUtil.createDriver(driverClassName);
        String url = BcXmlUtil.getTextValue(baseNode, "url");
        url = AfbApplication.getInstance().toReal(url);
        BcLogUtil.info("url=" + url);
        String user = BcXmlUtil.getTextValue(baseNode, "user");
        String password = BcXmlUtil.getTextValue(baseNode, "password");
        String tmpStr = BcXmlUtil.getTextValue(baseNode, "connectionMin");
        if (!BcStringUtil.isEmpty(tmpStr)) {
            connectionManager.setConnectionMin(BcNumberUtil.parseInt(tmpStr, -1));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "connectionMax"))) {
            connectionManager.setConnectionMax(BcNumberUtil.parseInt(tmpStr, -1));
        }
        tmpStr = BcXmlUtil.getTextValue(baseNode, "loginTimeout");
        BcStringUtil.isEmpty(tmpStr);
        tmpStr = BcXmlUtil.getTextValue(baseNode, "statementTimeout");
        if (!BcStringUtil.isEmpty(tmpStr)) {
            connectionManager.setStatementTimeout(BcNumberUtil.parseLong(tmpStr, -1L));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "lendinglTimeout"))) {
            connectionManager.setLendinglTimeout(BcNumberUtil.parseLong(tmpStr, -1L));
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(baseNode, "responseLogTime"))) {
            connectionManager.setResponseLogTime(BcNumberUtil.parseLong(tmpStr, -1L));
        }
        Properties dbConProps = new Properties();
        if (!BcStringUtil.isEmpty(user)) {
            dbConProps.setProperty(SqlConstants.DatasourceProperty.user.name(), user);
        }
        if (!BcStringUtil.isEmpty(password)) {
            dbConProps.setProperty(SqlConstants.DatasourceProperty.password.name(), password);
        }
        List<Node> nodeList2 = BcXmlUtil.getNodeList(baseNode, "param");
        int i = 0;
        while (i < nodeList2.size()) {
            Node node2 = nodeList2.get(i);
            String name = BcXmlUtil.getAttribute(node2, "name");
            String value = BcXmlUtil.getAttribute(node2, "value");
            dbConProps.put(name, value);
            ++i;
        }
        try {
            connectionManager.setup(driver, url, dbConProps);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            throw new Exception("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9 " + url + " \u306b\u63a5\u7d9a\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }
}

