/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import ext.appfw.common.AfbApplication;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcEncoder;
import ext.base.util.BcISO;
import ext.libx.business.account.BsnAccountsUtil;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xsod.common.FileVisitor1;
import ext.module.xsod.common.XsodConstants;
import ext.module.xsod.model.XsodCategory;
import ext.module.xsod.model.XsodMenuData;
import ext.module.xsod.model.XsodMerchandise;
import ext.module.xsod.model.XsodMerchandisePack;
import ext.module.xsod.model.XsodOrder;
import ext.module.xsod.model.XsodOrderSession;
import ext.module.xsod.model.XsodSalesDetail;
import ext.module.xsod.model.XsodSalesPack;
import ext.module.xsod.model.XsodSignageData;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public final class XsodUtil {
    private static File imageDir;
    public static final BcISO.ISO_639_1[] targetLangs;

    static {
        try {
            String tmpPath = AfbApplication.getInstance().toReal("${ROOT}data/images");
            imageDir = new File(tmpPath);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        targetLangs = new BcISO.ISO_639_1[]{BcISO.ISO_639_1.Japanese, BcISO.ISO_639_1.English};
    }

    private XsodUtil() {
    }

    public static void warn(Object msg) throws Exception {
        BcLogUtil.warning(msg);
    }

    public static File getImageDir() throws Exception {
        return imageDir;
    }

    public static int getLangIndex(String langCode) {
        int index = -1;
        int i = 0;
        while (i < XsodConstants.langArray.length) {
            BcISO.ISO_639_1 iso639_1 = XsodConstants.langArray[i];
            if (iso639_1.code.equals(langCode)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static boolean langEnabled(String langCode) {
        int i = 0;
        while (i < targetLangs.length) {
            BcISO.ISO_639_1 iso639_1 = targetLangs[i];
            if (iso639_1.code.equals(langCode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean needEncode(String langCode) {
        int cnt = 0;
        if (BcISO.ISO_639_1.Chinese.code.equals(langCode)) {
            ++cnt;
        }
        if (BcISO.ISO_639_1.Korean.code.equals(langCode)) {
            ++cnt;
        }
        return cnt > 0;
    }

    public static String getName(XsodCategory category, String langCode, boolean isDefault) throws Exception {
        int langIndex = XsodUtil.getLangIndex(langCode);
        String name = category.names[langIndex];
        if (XsodUtil.needEncode(langCode)) {
            name = BcEncoder.urlDecode(name, "UTF-8");
        }
        if (isDefault && BcStringUtil.isEmpty(name)) {
            name = category.names[XsodUtil.getLangIndex(XsodConstants.defaultLang1)];
        }
        return name;
    }

    public static void setName(XsodCategory category, String langCode, String str) throws Exception {
        int langIndex = XsodUtil.getLangIndex(langCode);
        if (XsodUtil.needEncode(langCode)) {
            str = BcEncoder.urlEncode(str, "UTF-8");
        }
        category.names[langIndex] = str;
    }

    public static String getName(XsodMerchandise merchandise, String langCode, boolean isDefault) throws Exception {
        int langIndex = XsodUtil.getLangIndex(langCode);
        String name = merchandise.namses[langIndex];
        if (XsodUtil.needEncode(langCode)) {
            name = BcEncoder.urlDecode(name, "UTF-8");
        }
        if (isDefault && BcStringUtil.isEmpty(name)) {
            name = merchandise.namses[XsodUtil.getLangIndex(XsodConstants.defaultLang1)];
        }
        return name;
    }

    public static void setName(XsodMerchandise merchandise, String langCode, String str) throws Exception {
        int langIndex = XsodUtil.getLangIndex(langCode);
        if (XsodUtil.needEncode(langCode)) {
            str = BcEncoder.urlEncode(str, "UTF-8");
        }
        merchandise.namses[langIndex] = str;
    }

    public static String getDescription(XsodMerchandise merchandise, String langCode, boolean isDefault) throws Exception {
        int langIndex = XsodUtil.getLangIndex(langCode);
        String str = merchandise.descriptions[langIndex];
        if (XsodUtil.needEncode(langCode)) {
            str = BcEncoder.urlDecode(str, "UTF-8");
        }
        if (isDefault && BcStringUtil.isEmpty(str)) {
            str = merchandise.descriptions[XsodUtil.getLangIndex(XsodConstants.defaultLang1)];
        }
        return str;
    }

    public static void setDescription(XsodMerchandise merchandise, String langCode, String str) throws Exception {
        int langIndex = XsodUtil.getLangIndex(langCode);
        if (XsodUtil.needEncode(langCode)) {
            str = BcEncoder.urlEncode(str, "UTF-8");
        }
        merchandise.descriptions[langIndex] = str;
    }

    public static XsodMerchandise findItemByCode(Collection<XsodMerchandise> itemCollection, String itemCode) {
        for (XsodMerchandise item : itemCollection) {
            if (!itemCode.equals(item.code)) continue;
            return item;
        }
        return null;
    }

    public static XsodOrder findSameItem(Collection<XsodOrder> orderCollection, XsodMerchandise item) {
        for (XsodOrder order : orderCollection) {
            if (!order.merchandiseCode.equals(item.code)) continue;
            return order;
        }
        return null;
    }

    public static void setupDataPack(XsodMenuData menuData, List<XsodCategory> categoryLisat) throws Exception {
        menuData.categoryMap.clear();
        menuData.category1List.clear();
        menuData.category2List.clear();
        int i = 0;
        while (i < categoryLisat.size()) {
            XsodCategory category = categoryLisat.get(i);
            menuData.categoryMap.put(category.code, category);
            XsodUtil.setupDataPack_L2(menuData, category);
            ++i;
        }
    }

    public static void setupDataPack_L2(XsodMenuData menuData, XsodCategory category) throws Exception {
        BcLogUtil.debug("category.code=" + category.code);
        if ("ROOT".equals(category.parent_code)) {
            menuData.category1List.add(category);
        } else {
            menuData.category2List.add(category);
        }
    }

    public static XsodMerchandisePack getMerchandisePackByItemCode(XsodMenuData menuData, String merchandiseCode) throws Exception {
        XsodMerchandisePack merchandisePack = menuData.merchandiseMap.get(merchandiseCode);
        return merchandisePack;
    }

    public static List<XsodCategory> createCategoryListByParentCode(Collection<XsodCategory> orderSessionCollection, String parentCode) throws Exception {
        ArrayList<XsodCategory> categoryList2 = new ArrayList<XsodCategory>();
        for (XsodCategory category : orderSessionCollection) {
            if (!category.parent_code.equals(parentCode)) continue;
            categoryList2.add(category);
        }
        return categoryList2;
    }

    public static void setOrderStatus(XsodOrder order) throws Exception {
        order.status = 1;
        order.status = order.orderDateTime == null ? (short)1 : (short)2;
        if (order.createStartDateTime != null) {
            order.status = (short)3;
        }
        if (order.createEndDateTime != null) {
            order.status = (short)4;
        }
        if (order.deliveryStartDateTime != null) {
            order.status = (short)5;
        }
        if (order.deliveryEndDateTime != null) {
            order.status = (short)6;
        }
        if (order.cancelDateTime != null) {
            order.status = (short)9;
        }
    }

    public static int getStatusIndex(short status) throws Exception {
        int index = -1;
        int i = 0;
        while (i < XsodConstants.ORDER_STATUSES.length) {
            if (status == XsodConstants.ORDER_STATUSES[i]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static short getNextStatus(short status) throws Exception {
        int index = XsodUtil.getStatusIndex(status);
        return XsodConstants.ORDER_STATUSES[index + 1];
    }

    public static Map<String, XsodMerchandise> toMerchandiseMap(Collection<XsodMerchandise> merchandiseCollection) {
        HashMap<String, XsodMerchandise> merchandiseMap = new HashMap<String, XsodMerchandise>();
        for (XsodMerchandise mMerchandise : merchandiseCollection) {
            merchandiseMap.put(mMerchandise.code, mMerchandise);
        }
        return merchandiseMap;
    }

    public static Map<Integer, XsodOrderSession> toOrderSessionMap(Collection<XsodOrderSession> orderSessionCollection) throws Exception {
        HashMap<Integer, XsodOrderSession> orderSessionMap = new HashMap<Integer, XsodOrderSession>();
        for (XsodOrderSession orderSession : orderSessionCollection) {
            orderSessionMap.put(orderSession.getDataId(), orderSession);
        }
        return orderSessionMap;
    }

    public static Map<Integer, XsodOrder> toOrderMap(Collection<XsodOrder> orderCollection) {
        HashMap<Integer, XsodOrder> orderMap = new HashMap<Integer, XsodOrder>();
        for (XsodOrder order : orderCollection) {
            orderMap.put(order.getDataId(), order);
        }
        return orderMap;
    }

    public static XsodSalesPack createSalesPack(List<XsodOrder> orderList, Map<String, XsodMerchandise> merchandiseMap) throws Exception {
        BcLogUtil.info("\u6ce8\u6587\u30c7\u30fc\u30bf\u6570=" + orderList.size());
        int roundMode = 0;
        int cutOffDate = BcTimeUtil.createYyyyMMdd();
        BcLogUtil.info("\u7de0\u65e5=" + cutOffDate);
        XsodSalesPack salesPack = new XsodSalesPack();
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        int i = 0;
        while (i < orderList.size()) {
            XsodOrder order = orderList.get(i);
            BcLogUtil.info("i=" + i + ":\u5546\u54c1\u30b3\u30fc\u30c9=" + order.merchandiseCode + " \u6570\u91cf=" + order.quantity);
            XsodMerchandise merchandise = merchandiseMap.get(order.merchandiseCode);
            XsodSalesDetail salesDetail = new XsodSalesDetail();
            salesDetail.merchandiseCode = order.merchandiseCode;
            salesDetail.unitAmount = merchandise.unitAmount;
            salesDetail.quantity = new BigDecimal(order.quantity);
            salesDetail.amount = BsnAccountsUtil.calcDetailAmount(salesDetail.unitAmount, salesDetail.quantity, roundMode);
            salesDetail.tax = BsnAccountsUtil.calcConsumptionTax(salesDetail.amount, cutOffDate, roundMode);
            salesDetail.orderId = order.getDataId();
            salesPack.salesDetaiList.add(salesDetail);
            amountSum = amountSum.add(salesDetail.amount);
            taxSum = taxSum.add(salesDetail.tax);
            ++i;
        }
        BcLogUtil.info("\u7a0e\u629c\u304d\u8a08=" + amountSum + " \u6d88\u8cbb\u7a0e\u984d=" + taxSum);
        salesPack.sales.amount = amountSum.longValue();
        salesPack.sales.tax = taxSum.longValue();
        return salesPack;
    }

    public static List<XfilUriEntity> getUriEntityList() throws Exception {
        File imageDir = XsodUtil.getImageDir();
        ArrayList<XfilUriEntity> uriEntityList = new ArrayList<XfilUriEntity>();
        FileVisitor1 fileVisitor = new FileVisitor1(uriEntityList);
        Files.walkFileTree(imageDir.toPath(), fileVisitor);
        return uriEntityList;
    }

    public static List<TreeNode> toTreeNodeList(TreeNode treeNode) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        XsodUtil.toTreeNodeList(treeNode, treeNodeList);
        return treeNodeList;
    }

    public static void toTreeNodeList(TreeNode treeNode, List<TreeNode> treeNodeList) {
        treeNodeList.add(treeNode);
        int i = 0;
        while (i < treeNode.getChildCount()) {
            TreeNode treeNodeChild = treeNode.getChildAt(i);
            XsodUtil.toTreeNodeList(treeNodeChild, treeNodeList);
            ++i;
        }
    }

    public static List<Object> toUserObjectList(TreeNode treeNode) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        XsodUtil.toUserObjectList(treeNode, objectList);
        return objectList;
    }

    public static void toUserObjectList(TreeNode treeNode, List<Object> objectList) {
        XsodUtil.addUserObject(treeNode, objectList);
        int i = 0;
        while (i < treeNode.getChildCount()) {
            TreeNode treeNodeChild = treeNode.getChildAt(i);
            XsodUtil.addUserObject(treeNodeChild, objectList);
            ++i;
        }
    }

    public static void addUserObject(TreeNode treeNode, List<Object> objectList) {
        if (treeNode instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
            objectList.add(((DefaultMutableTreeNode)treeNode).getUserObject());
        }
    }

    public static DefaultMutableTreeNode createTree(List<Map.Entry<Comparable, Comparable>> entryList, Comparable rootId) throws Exception {
        DefaultMutableTreeNode treeNodeRoot = new DefaultMutableTreeNode(rootId);
        HashMap<Object, DefaultMutableTreeNode> map1 = new HashMap<Object, DefaultMutableTreeNode>();
        HashMap<Object, DefaultMutableTreeNode> map2 = new HashMap<Object, DefaultMutableTreeNode>();
        map1.put(treeNodeRoot.getUserObject(), treeNodeRoot);
        int i = 0;
        while (i < entryList.size()) {
            Map.Entry<Comparable, Comparable> mapEntry = entryList.get(i);
            BcLogUtil.info("#" + (i + 1) + ": id =" + mapEntry.getKey() + " parentId=" + mapEntry.getValue());
            if (map1.get(mapEntry.getKey()) != null) {
                BcLogUtil.debug("ID\u91cd\u8907");
            } else {
                DefaultMutableTreeNode treeNodeChild;
                DefaultMutableTreeNode treeNodeParent = (DefaultMutableTreeNode)map1.get(mapEntry.getValue());
                if (treeNodeParent == null) {
                    treeNodeParent = (DefaultMutableTreeNode)map2.get(mapEntry.getValue());
                }
                if (treeNodeParent == null) {
                    treeNodeParent = new DefaultMutableTreeNode(mapEntry.getValue());
                    map2.put(treeNodeParent.getUserObject(), treeNodeParent);
                }
                if ((treeNodeChild = (DefaultMutableTreeNode)map2.remove(mapEntry.getKey())) == null) {
                    treeNodeChild = new DefaultMutableTreeNode(mapEntry.getKey());
                }
                treeNodeParent.add(treeNodeChild);
                map1.put(treeNodeChild.getUserObject(), treeNodeChild);
            }
            ++i;
        }
        if (map2.size() > 0) {
            BcLogUtil.debug("\u89e3\u6c7a\u3057\u306a\u3044\u4ef6\u6570=" + map2.size());
            for (Map.Entry mapEntry : map2.entrySet()) {
                BcLogUtil.info("\u672a\u89e3\u6c7a: id =" + mapEntry.getKey() + " parentId=" + mapEntry.getValue());
            }
        }
        return treeNodeRoot;
    }

    public static XsodSignageData toSignageData(byte[] bytes) throws Exception {
        String json = new String(bytes, "UTF-8");
        ObjectMapper objectMapper = new ObjectMapper();
        XsodSignageData signageData = (XsodSignageData)objectMapper.readValue(json, XsodSignageData.class);
        return signageData;
    }

    public static XsodSignageData getSignageData(File file) throws Exception {
        return XsodUtil.toSignageData(BcFileUtil.read(file));
    }
}

