/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogUtil;
import ext.lib.fx.table.FxTableCellValueFactory;
import ext.lib.fx.table.FxTableColumn;
import ext.module.xfil.model.XfilUriEntity;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;

public class XfilFileCellValueFactory
extends FxTableCellValueFactory {
    int mode;

    public XfilFileCellValueFactory(int mode) {
        this.mode = mode;
    }

    @Override
    public ObservableValue getCellValue(FxTableColumn tableColumn, Object item) {
        XfilUriEntity uriEntity = (XfilUriEntity)item;
        Object value = null;
        switch (this.mode) {
            case 1: {
                value = this.getCellValue1(tableColumn, uriEntity);
                break;
            }
            case 2: {
                value = this.getCellValue2(tableColumn, uriEntity);
            }
        }
        return new ReadOnlyObjectWrapper(value);
    }

    protected Object getCellValue1(FxTableColumn tableColumn, XfilUriEntity uriEntity) {
        Object value = null;
        switch (tableColumn.index) {
            case 0: {
                value = this.createPath(uriEntity);
                break;
            }
            case 1: {
                value = uriEntity.name;
                break;
            }
            case 2: {
                try {
                    value = BcNumberUtil.toString(uriEntity.size);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                break;
            }
            case 3: {
                value = uriEntity.extention;
                break;
            }
            case 4: {
                value = uriEntity.short01;
            }
        }
        return value;
    }

    public Object getCellValue2(FxTableColumn tableColumn, XfilUriEntity uriEntity) {
        Object value = null;
        switch (tableColumn.index) {
            case 0: {
                value = uriEntity.name;
                break;
            }
            case 1: {
                try {
                    value = BcNumberUtil.toString(uriEntity.size);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                break;
            }
            case 2: {
                value = uriEntity.childCount;
            }
        }
        return value;
    }

    protected StringBuilder createPath(XfilUriEntity uriEntity) {
        StringBuilder sb = new StringBuilder();
        sb.append(uriEntity.path);
        return sb;
    }
}

