/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlConditionUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.model.XfilUriEntity;
import java.util.ArrayList;
import java.util.List;

public class XfilUriEntityDAO
extends OrmAbstractDAO<XfilUriEntity> {
    public static final int MODE_id = 1;
    public static final int MODE_name = 2;

    private XfilUriEntityDAO() {
        super(new XfilUriEntity[0]);
        this.setTableName("xfil_uri_entity");
    }

    public static XfilUriEntityDAO getInstance() {
        return SingletonHolder.instance;
    }

    public int deleteEntityAll(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int cnt = sqlContext.deleteAllRow(dtsSession.getConnection(), this.tableName);
        return cnt;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, int dataId, String path, String name, Short status, int rowLimit, boolean isFuzzy) throws Exception {
        StringBuilder formula;
        ArrayList<String> conditionValueList;
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (dataId > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id = " + dataId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(path)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList<String>();
                conditionValueList.add(path);
                formula = SqlConditionUtil.createPatternMatchClause(sqlContext, "path_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula("path_" + sqlContext.toCondition_string("=", path));
            }
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(name)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList();
                conditionValueList.add(name);
                formula = SqlConditionUtil.createPatternMatchClause(sqlContext, "name_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula("name_" + sqlContext.toCondition_string("=", name));
            }
            selectSql.addWhereElement(whereElement);
        }
        if (status != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("short_01 = " + status);
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "name_");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "path_");
        }
        selectSql.rowLimit = rowLimit;
        return selectSql;
    }

    public <T> List<T> getList(DtsSession dtsSession, int mode, int dataId, String path, String name, Short status, int rowLimit, boolean isFuzzy) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "uri";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, dataId, path, name, status, rowLimit, isFuzzy);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public <T> List<T> getListByLimit(DtsSession dtsSession, int rowLimit) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "uri";
        int dataId = -1;
        String path = null;
        String name = null;
        Short status = 1;
        boolean isFuzzy = false;
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, 1, alias, dataId, path, name, status, rowLimit, isFuzzy);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, int dataId) throws Exception {
        String path = null;
        String fileName = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, 1, dataId, path, fileName, status, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByPath(DtsSession dtsSession, String directoryName, String fileName, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(directoryName) || BcStringUtil.isEmpty(fileName)) {
            throw new Exception("directoryName=" + directoryName + " fileName=" + fileName);
        }
        int dataId = -1;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, 2, dataId, directoryName, fileName, status, rowLimit, isFuzzy);
        return entityList;
    }

    public <T> T getByName(DtsSession dtsSession, String path, String name) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        int dataId = -1;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, 2, dataId, path, name, status, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByName(DtsSession dtsSession, String name, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        int dataId = -1;
        String path = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, 2, dataId, path, name, status, rowLimit, isFuzzy);
        return entityList;
    }

    public <T> List<T> getListByDirectory(DtsSession dtsSession, String directoryName, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(directoryName)) {
            return null;
        }
        int dataId = -1;
        String name = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, 2, dataId, directoryName, name, status, rowLimit, isFuzzy);
        return entityList;
    }

    /* synthetic */ XfilUriEntityDAO(XfilUriEntityDAO xfilUriEntityDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XfilUriEntityDAO instance = new XfilUriEntityDAO(null);

        private SingletonHolder() {
        }
    }
}

