/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcNumberUtil;
import ext.base.util.BcResult;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import java.sql.ResultSet;

public abstract class XsysTableRowTask
extends TskAbstractCallable<BcResult> {
    DtsSession dtsSession;
    SqlContext sqlContext;

    public void setCondition(DtsSession dtsSession) {
        this.dtsSession = dtsSession;
    }

    @Override
    public BcResult taskProcess() throws Exception {
        this.started();
        BcResult result = new BcResult();
        String sql = this.createSql();
        this.getLogger().info("sql=" + sql);
        SqlPreparedStatement ppst = this.dtsSession.getConnection().prepareStatement(sql);
        ResultSet rs = null;
        int rowNumber = 0;
        try {
            rs = ppst.executeQuery();
            this.resultSetCreated(rs);
            while (rs.next()) {
                if (++rowNumber % 1000 == 0) {
                    this.getLogger().info("Row Number=" + BcNumberUtil.toString(rowNumber));
                }
                this.selected(rs, rowNumber);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
            if (ppst != null) {
                try {
                    ppst.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        this.getLogger().info("rowCount=" + rowNumber);
        this.finied(rowNumber);
        return result;
    }

    protected void started() throws Exception {
        this.sqlContext = this.dtsSession.getSqlContext();
    }

    protected abstract String createSql() throws Exception;

    protected void resultSetCreated(ResultSet rs) throws Exception {
    }

    protected void selected(ResultSet rs, int rowNumber) throws Exception {
    }

    protected void finied(int rowNumber) throws Exception {
    }
}

