/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.lib.datasource.DtsSession;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.server.XsysTableRowTask;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class XsysTableCopyTask
extends XsysTableRowTask {
    DtsSession dtsSession2;
    SqlContext sqlContext2;
    MmdModel mmdModel1;
    MmdModel mmdModel2;
    XdtsProcessCondition processCondition;
    PreparedStatement ppst2;

    public void setCondition(DtsSession dtsSession2, XdtsProcessCondition processCondition, MmdModel mmdModel1, MmdModel mmdModel2) {
        this.dtsSession2 = dtsSession2;
        this.sqlContext2 = dtsSession2.getSqlContext();
        this.processCondition = processCondition;
        this.mmdModel1 = mmdModel1;
        this.mmdModel2 = mmdModel2;
    }

    @Override
    protected String createSql() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append(this.sqlContext.createSelectSql(this.mmdModel1));
        if (!BcStringUtil.isEmpty(this.processCondition.sql)) {
            sql.append(" WHERE ");
            sql.append(this.processCondition.sql);
        }
        return sql.toString();
    }

    @Override
    protected void resultSetCreated(ResultSet rs) throws Exception {
        super.resultSetCreated(rs);
        String insertSql = this.sqlContext2.createInsertSqlForPrepareStatement(this.mmdModel2);
        this.getLogger().info("insertSql=" + insertSql);
        this.ppst2 = this.dtsSession2.getConnection().prepareStatement(insertSql);
        if (this.processCondition.commitMode == XdtsConstants.CommitMode.AUTO) {
            this.dtsSession2.getConnection().setAutoCommit(true);
        }
    }

    @Override
    protected void selected(ResultSet rs, int rowNumber) throws Exception {
        block2: {
            try {
                super.selected(rs, rowNumber);
                this.selected_L2(rs, rowNumber);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                if (this.processCondition.iqnoreException) break block2;
                throw ex;
            }
        }
    }

    protected void selected_L2(ResultSet rs, int rowNumber) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            int colmunIndex1 = i + 1;
            String columnName = rsmd.getColumnName(colmunIndex1);
            MmdField mmdField = this.mmdModel2.getFieldByColumnName(columnName);
            if (mmdField == null) {
                throw new Exception("\u5b58\u5728\u3057\u307e\u305b\u3093\u3002columnName=" + columnName);
            }
            this.sqlContext.copyRow(rs, colmunIndex1, this.sqlContext2, this.ppst2, mmdField.ordinalPosition, this.getLogger());
            ++i;
        }
        this.ppst2.executeUpdate();
    }

    @Override
    protected void finied(int rowNumber) throws Exception {
        if (this.processCondition.commitMode == XdtsConstants.CommitMode.TABLE) {
            this.dtsSession2.commit();
        }
        try {
            this.ppst2.close();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }
}

