/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xdts.model.XdtsProfile;
import java.util.List;

public class XdtsProfileDAO
extends OrmAbstractDAO<XdtsProfile> {
    public static XdtsProfileDAO getInstance() {
        return SingletonHolder.instance;
    }

    private XdtsProfileDAO() {
        super(new XdtsProfile[0]);
        this.setTableName("xdts_profile");
        this.setViewName(String.valueOf(this.tableName) + "__v1");
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, Mode mode, String alias, Long profileId, String profileName) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (profileId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + profileId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(profileName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "name " + sqlContext.toCondition_string("=", profileName));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(SqlUtil.createTableName(this.getTableName(), alias));
        switch (mode) {
            case id: {
                selectSql.getOrderByList().add(String.valueOf(aliasWk) + "id");
                break;
            }
            case name: {
                selectSql.getOrderByList().add(String.valueOf(aliasWk) + "name");
                break;
            }
            case group: {
                selectSql.getOrderByList().add(String.valueOf(aliasWk) + "group_");
                selectSql.getOrderByList().add(String.valueOf(aliasWk) + "name");
            }
        }
        return selectSql;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, Long profileId, String profileName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "prof";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, profileId, profileName);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(null));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long profileId) throws Exception {
        String profileName = null;
        List<T> entityList = this.getList(dtsSession, Mode.id, profileId, profileName);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByName(DtsSession dtsSession, String profileName) throws Exception {
        Long profileId = null;
        List<T> entityList = this.getList(dtsSession, Mode.group, profileId, profileName);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ XdtsProfileDAO(XdtsProfileDAO xdtsProfileDAO) {
        this();
    }

    public static enum Mode {
        id,
        name,
        group;

    }

    private static final class SingletonHolder {
        private static final XdtsProfileDAO instance = new XdtsProfileDAO(null);

        private SingletonHolder() {
        }
    }
}

