/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import com.megginson.sax.DataWriter;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.module.xdts.common.XdtsXmlUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XdtsSchemaXmlCreator {
    protected DataWriter dataWriter;
    protected int indentStep = XdtsXmlUtil.indentStep;

    protected void createXml() throws Exception {
        File tempDir = new File("C://temp");
        String fileName = "test01.xml";
        File tmpFile = new File(tempDir, fileName);
        BcLogUtil.debug("tmpFile=" + tmpFile.getPath());
        BcFileUtil.makeParent(tmpFile);
        ArrayList<MmdModel> mmdList = new ArrayList<MmdModel>();
        MmdModel mmd2 = new MmdModel();
        MmdField mmdField = new MmdField();
        mmd2.addField(mmdField);
        mmdList.add(mmd2);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
        boolean isSuccess = false;
        this.dataWriter = new DataWriter((Writer)new OutputStreamWriter(os));
        try {
            this.dataWriter.startDocument();
            this.dataWriter.setIndentStep(this.indentStep);
            this.dataWriter.startElement("schema");
            int i = 0;
            while (i < mmdList.size()) {
                int cnt = i + 1;
                if (cnt % 100 == 0) {
                    BcLogUtil.info("cnt=" + cnt);
                }
                MmdModel mmd = (MmdModel)mmdList.get(i);
                this.createXml_L2(mmd);
                ++i;
            }
            this.dataWriter.endElement("schema");
            this.dataWriter.endDocument();
            this.dataWriter.flush();
            isSuccess = true;
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    protected void createXml_L2(MmdModel mmd) throws Exception {
        mmd.tableName = "hoge";
        BcLogUtil.debug("mmd.tableName=" + mmd.tableName);
        AttributesImpl aatLib1 = new AttributesImpl();
        aatLib1.addAttribute("", "name", "name", "CDATA", mmd.tableName);
        this.dataWriter.startElement("", "table", "table", (Attributes)aatLib1);
        BcLogUtil.debug("mmd.getFieldCount()=" + mmd.getFieldCount());
        int i = 0;
        while (i < mmd.getFieldCount()) {
            MmdField mmdField = mmd.getField(i);
            mmdField.columnName = "col" + (i + 1);
            this.createXml_L3(mmdField);
            ++i;
        }
        this.dataWriter.endElement("table");
    }

    protected void createXml_L3(MmdField mmdField) throws Exception {
        AttributesImpl aatLib2 = new AttributesImpl();
        aatLib2.addAttribute("", "name", "name", "CDATA", mmdField.columnName);
        this.dataWriter.startElement("", "column", "column", (Attributes)aatLib2);
        this.dataWriter.endElement("column");
    }

    public static void main(String[] args) throws Exception {
        XdtsSchemaXmlCreator schemaXml = new XdtsSchemaXmlCreator();
        schemaXml.createXml();
        System.exit(0);
    }
}

