/*
 * Decompiled with CFR 0.152.
 */
package ext.module.mqsv.server;

import ext.base.core.BcConstants;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.base.xml.BcXmlUtil;
import ext.module.mqsv.server.EssMsgAcceptThread;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MqsvServiceTest {
    protected Socket socket;

    public void connect(String hostAddress, int port) throws Exception {
        BcLogUtil.debug("connect.hostAddress=" + hostAddress);
        BcLogUtil.debug("connect.port=" + port);
        this.socket = new Socket(hostAddress, port);
    }

    public void send(Object obj) throws Exception {
        if (obj instanceof byte[]) {
            OutputStream os = this.socket.getOutputStream();
            os.write((byte[])obj);
            os.flush();
        } else if (obj instanceof Document) {
            Document xmlDoc = (Document)obj;
            BcXmlUtil.output(xmlDoc, this.socket.getOutputStream(), false);
        }
    }

    public void recieve() throws Exception {
        byte[] byteArray = BcStreamUtil.read(this.socket.getInputStream());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        InputSource inputSource = new InputSource(byteArrayInputStream);
        inputSource.setEncoding("SJIS");
        Document xmlDoc = BcXmlUtil.createDocument(inputSource);
        BcLogUtil.debug(BcXmlUtil.toString(xmlDoc, BcConstants.baseCharset.name(), true));
    }

    public void request_removeMessageListener(String hostAddress, int hostPortNo, String recievAddress, int recievPortNo) throws Exception {
        this.connect(hostAddress, hostPortNo);
        Document xmlDoc = BcXmlUtil.createDocument("root", true);
        Element rootElem = xmlDoc.createElement("request");
        xmlDoc.appendChild(rootElem);
        Element elem1 = null;
        Element elem2 = null;
        elem1 = xmlDoc.createElement("removeMessageListener");
        rootElem.appendChild(elem1);
        elem2 = xmlDoc.createElement("address");
        elem1.appendChild(elem2);
        elem2.appendChild(xmlDoc.createTextNode(recievAddress));
        elem2 = xmlDoc.createElement("port");
        elem1.appendChild(elem2);
        elem2.appendChild(xmlDoc.createTextNode(Integer.toString(recievPortNo)));
        this.send(xmlDoc);
        this.socket.close();
    }

    public void request_getPerson(String hostAddress, int hostPortNo, String recievAddress, int recievPortNo) throws Exception {
        BcLogUtil.debug("request_getPerson:");
        this.connect(hostAddress, hostPortNo);
        Document xmlDoc = BcXmlUtil.createDocument("root", true);
        Element rootElem = xmlDoc.createElement("request");
        xmlDoc.appendChild(rootElem);
        Element elem1 = null;
        elem1 = xmlDoc.createElement("getPerson");
        rootElem.appendChild(elem1);
        this.send(xmlDoc);
        this.recieve();
        this.socket.close();
    }

    public void request_getSection(String hostAddress, int hostPortNo, String recievAddress, int recievPortNo) throws Exception {
        BcLogUtil.error("request_getSection:");
        this.connect(hostAddress, hostPortNo);
        Document xmlDoc = BcXmlUtil.createDocument("root", true);
        Element rootElem = xmlDoc.createElement("request");
        xmlDoc.appendChild(rootElem);
        Element elem1 = null;
        elem1 = xmlDoc.createElement("getSection");
        rootElem.appendChild(elem1);
        this.send(xmlDoc);
        this.recieve();
        this.socket.close();
    }

    public static void main(String[] args) {
        String hostAddress = "dynabook522";
        int hostPortNo = 9011;
        String recieveAddress = "dynabook522";
        int recievePortNo = 9012;
        try {
            new EssMsgAcceptThread(recievePortNo);
            MqsvServiceTest mqsvServiceTest = new MqsvServiceTest();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }
}

