/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.swg;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.base.xml.BcXmlUtil;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgComboBox;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgFileChooser;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.lib.swg.SwgWizerdStep;
import ext.module.impt.common.ImptImportDefineParser;
import ext.module.impt.common.ImptWords;
import ext.module.impt.model.ImptDefineIndex;
import ext.module.impt.model.ImptImportContext;
import ext.module.impt.stub.ImptGeneralStub;
import ext.module.impt.swg.ImptImportMappingPanel;
import ext.module.impt.swg.ImptImportPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.InetAddress;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;

public class ImptImportSourceConditionPanel
extends SwgDecoratePanel
implements SwgWizerdStep {
    private static final long serialVersionUID = 7734045687969523945L;
    protected SwgComboBox importModeCombo = new SwgComboBox();
    protected SwgLabel defineFileLabel;
    protected SwgTextField defineFilePathField;
    protected SwgButton defineFileBrowsButton;
    protected SwgLabel sourceFileLabel;
    protected SwgTextField sourceFilePathField;
    protected SwgButton sourceFileBrowsButton;
    protected SwgLabel logFileLabel;
    protected SwgTextField logFilePathField;
    protected SwgButton logFileBrowsButton;
    protected SwgTextField outputFilePathField;
    protected SwgButton outputFileBrowsButton;
    protected String[] exchengFormatNames;
    protected SwgComboBox exchengFormatCombo;
    protected SwgFileChooser fileChooser;
    protected ImptImportPanel pa;

    public ImptImportSourceConditionPanel(ImptImportPanel pa) throws Exception {
        this.defineFileLabel = new SwgLabel(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc\u5b9a\u7fa9, 4);
        this.defineFilePathField = new SwgTextField();
        this.defineFileBrowsButton = new SwgButton("\u53c2\u7167");
        this.sourceFileLabel = new SwgLabel("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9", 4);
        this.sourceFilePathField = new SwgTextField();
        this.sourceFileBrowsButton = new SwgButton("\u53c2\u7167");
        this.logFileLabel = new SwgLabel("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb", 4);
        this.logFilePathField = new SwgTextField();
        this.logFileBrowsButton = new SwgButton("\u53c2\u7167");
        this.outputFilePathField = new SwgTextField();
        this.outputFileBrowsButton = new SwgButton("\u53c2\u7167");
        this.exchengFormatNames = new String[]{"CSV\uff08\u30ab\u30f3\u30de\u533a\u5207\u308a\uff09"};
        this.exchengFormatCombo = new SwgComboBox();
        this.pa = pa;
        this.setBorderSize(64, 48, 10, 10);
        this.setLine();
        this.setNextButton(BcWords.getInstance().next_arrow);
        this.setCancelButton(BcWords.getInstance().cancel);
        int i = 0;
        while (i < pa.defineIndexList.size()) {
            ImptDefineIndex defineIndex = pa.defineIndexList.get(i);
            this.importModeCombo.addItem(defineIndex.name);
            ++i;
        }
        switch (pa.mode) {
            case 11: {
                this.setImportComponent();
                break;
            }
            case 21: {
                i = 0;
                while (i < this.exchengFormatNames.length) {
                    this.exchengFormatCombo.addItem(this.exchengFormatNames[i]);
                    ++i;
                }
                this.setExchangeComponent();
            }
        }
        this.setDescription(String.valueOf(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc\u5b9a\u7fa9) + "\u53ca\u3073\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002", -1);
        this.importModeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() != 1) {
                    return;
                }
                boolean tmpBool = ImptImportSourceConditionPanel.this.importModeCombo.getSelectedIndex() == 0;
                ImptImportSourceConditionPanel.this.defineFileLabel.setEnabled(tmpBool);
                ImptImportSourceConditionPanel.this.defineFilePathField.setEnabled(tmpBool);
                ImptImportSourceConditionPanel.this.defineFileBrowsButton.setEnabled(tmpBool);
            }
        });
        this.defineFileBrowsButton.addActionListener(this.actionListener);
        this.sourceFileBrowsButton.addActionListener(this.actionListener);
        this.logFileBrowsButton.addActionListener(this.actionListener);
    }

    protected void setImportComponent() throws Exception {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 140;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30bd\u30fc\u30b9\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.importModeCombo, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        this.importModeCombo.setMaximumRowCount(16);
        SwgUtil.setLocation(this.centerPanel, this.defineFileLabel, (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defineFilePathField, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defineFileBrowsButton, (double)(c2x + 500), (double)ly, -1.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.sourceFileLabel, (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.sourceFilePathField, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.sourceFileBrowsButton, (double)(c2x + 500), (double)ly, -1.0, (double)rowHeight);
        ly += rowHeight + rowGap;
    }

    protected void setExchangeComponent() throws Exception {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 140;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30bd\u30fc\u30b9\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.importModeCombo, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defineFileLabel, (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defineFilePathField, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defineFileBrowsButton, (double)(c2x + 500), (double)ly, -1.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.sourceFileLabel, (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.sourceFilePathField, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.sourceFileBrowsButton, (double)(c2x + 500), (double)ly, -1.0, (double)rowHeight);
        ly += rowHeight + rowGap;
        ly += rowHeight + rowGap;
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u5909\u63db\u30d5\u30a9\u30fc\u30de\u30c3\u30c8", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.exchengFormatCombo, (double)c2x, (double)ly, 360.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u51fa\u529b\u5148\u30d5\u30a1\u30a4\u30eb", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.outputFilePathField, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.outputFileBrowsButton, (double)(c2x + 500), (double)ly, -1.0, (double)rowHeight);
        this.outputFileBrowsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImptImportSourceConditionPanel.this.fileChooser.resetChoosableFileFilters();
                switch (ImptImportSourceConditionPanel.this.fileChooser.showDialog(ImptImportSourceConditionPanel.this.pa, "\u9078\u629e")) {
                    case 0: {
                        ImptImportSourceConditionPanel.this.outputFilePathField.setText(ImptImportSourceConditionPanel.this.fileChooser.getSelectedFile().getPath());
                        break;
                    }
                }
            }
        });
        ly += rowHeight + rowGap;
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.defineFileBrowsButton) {
            if (this.fileChooser == null) {
                this.fileChooser = new SwgFileChooser();
            }
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.resetChoosableFileFilters();
            if (!BcStringUtil.isEmpty(this.defineFilePathField.getText())) {
                this.fileChooser.setSelectedFile(new File(this.defineFilePathField.getText()));
            }
            switch (this.fileChooser.showDialog(this, "\u9078\u629e")) {
                case 0: {
                    this.defineFilePathField.setText(this.fileChooser.getSelectedFile().getPath());
                    this.pa.definefFile = new File(this.defineFilePathField.getText());
                    this.saveFilePath();
                    break;
                }
            }
        } else if (ev.getSource() == this.sourceFileBrowsButton) {
            if (this.fileChooser == null) {
                this.fileChooser = new SwgFileChooser();
            }
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.resetChoosableFileFilters();
            if (!BcStringUtil.isEmpty(this.sourceFilePathField.getText())) {
                this.fileChooser.setSelectedFile(new File(this.sourceFilePathField.getText()));
            }
            switch (this.fileChooser.showDialog(this, "\u9078\u629e")) {
                case 0: {
                    this.sourceFilePathField.setText(this.fileChooser.getSelectedFile().getPath());
                    this.saveFilePath();
                    break;
                }
            }
        } else if (ev.getSource() == this.logFileBrowsButton) {
            if (this.fileChooser == null) {
                this.fileChooser = new SwgFileChooser();
            }
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.resetChoosableFileFilters();
            switch (this.fileChooser.showDialog(this, "\u9078\u629e")) {
                case 0: {
                    this.logFilePathField.setText(this.fileChooser.getSelectedFile().getPath());
                    this.saveFilePath();
                    break;
                }
            }
        }
    }

    @Override
    protected void nextButtonAction() {
        switch (this.pa.mode) {
            case 11: {
                try {
                    this.transImport();
                    break;
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
                    return;
                }
            }
            case 21: {
                try {
                    this.transExchange();
                    break;
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
                    return;
                }
            }
        }
    }

    protected void transImport() throws Exception {
        this.pa.defineIndex = this.pa.defineIndexList.get(this.importModeCombo.getSelectedIndex());
        this.pa.importCondition.processId = this.pa.defineIndex.processId;
        this.pa.definefFile = null;
        if (this.importModeCombo.getSelectedIndex() == 0) {
            this.pa.definefFile = new File(this.defineFilePathField.getText());
            if (!this.pa.definefFile.exists()) {
                JOptionPane.showMessageDialog(this, String.valueOf(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc\u5b9a\u7fa9) + "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", BcWords.getInstance().exception, 0);
                return;
            }
            this.pa.importCondition.defFileName = this.pa.definefFile.getName();
            ImptImportDefineParser importDefineParser = new ImptImportDefineParser();
            this.pa.importDefine = importDefineParser.parse(this.pa.definefFile);
        } else {
            this.pa.importCondition.defineIndexId = this.pa.defineIndex.getDataId();
            this.pa.importDefine = ImptGeneralStub.getInstance().getImportDefine(this.pa.defineIndex.fileResourceId);
        }
        BcLogUtil.debug("pa.importDefine=" + this.pa.importDefine);
        File sourceFile = new File(this.sourceFilePathField.getText());
        this.pa.sourceFileList.clear();
        if (!sourceFile.isFile()) {
            throw new Exception("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u9078\u629e\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        this.pa.sourceFileList.add(sourceFile);
        this.pa.importCondition.sourceUrl = "//" + InetAddress.getLocalHost().getHostName() + "/" + sourceFile.getPath();
        if (this.pa.sourceFileList.size() > 0) {
            if (this.pa.importCondition.resumeImportId <= 0) {
                int i = 0;
                while (i < this.pa.sourceFileList.size()) {
                    File file = this.pa.sourceFileList.get(i);
                    ImptImportContext tmpImportContext = ImptGeneralStub.getInstance().getImportContextByLastModified(file);
                    if (tmpImportContext != null) {
                        String msg = String.valueOf(file.getName()) + " \u3068\u540c\u3058\u66f4\u65b0\u65e5\u6642\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u53d6\u308a\u8fbc\u3093\u3060\u5c65\u6b74\u304c\u3042\u308a\u307e\u3059\u3002\u51e6\u7406\u3092\u7d9a\u3051\u307e\u3059\u304b\uff1f";
                        if (JOptionPane.showConfirmDialog(this, msg, BcWords.getInstance().confirm, 0) != 0) {
                            return;
                        }
                        if (file.length() == tmpImportContext.fileSize && JOptionPane.showConfirmDialog(this, msg = "\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u3082\u540c\u3058\u3067\u3059\u3002\u51e6\u7406\u3092\u7d9a\u3051\u307e\u3059\u304b\uff1f \uff08" + file.length() + " Byte)", BcWords.getInstance().confirm, 0) != 0) {
                            return;
                        }
                    }
                    ++i;
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "\u53d6\u8fbc\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", BcWords.getInstance().exception, 0);
            return;
        }
        this.pa.importCondition.logFilePath = this.logFilePathField.getText();
        int cfr_ignored_0 = this.pa.importCondition.processId;
        this.pa.setPanel(ImptImportMappingPanel.class.getName());
    }

    protected void transExchange() throws Exception {
        this.pa.defineIndex = this.pa.defineIndexList.get(this.importModeCombo.getSelectedIndex());
        this.pa.importCondition.processId = this.pa.defineIndex.processId;
        if (this.importModeCombo.getSelectedIndex() == 0) {
            this.pa.definefFile = new File(this.defineFilePathField.getText());
            if (!this.pa.definefFile.exists()) {
                JOptionPane.showMessageDialog(this, String.valueOf(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc\u5b9a\u7fa9) + "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", BcWords.getInstance().exception, 0);
                return;
            }
            ImptImportDefineParser importDefineParser = new ImptImportDefineParser();
            this.pa.importDefine = importDefineParser.parse(this.pa.definefFile);
        } else {
            this.pa.importDefine = ImptGeneralStub.getInstance().getImportDefine(this.pa.defineIndex.fileResourceId);
        }
        File sourceFile = new File(this.sourceFilePathField.getText());
        this.pa.sourceFileList.clear();
        if (sourceFile.isFile()) {
            this.pa.sourceFileList.add(sourceFile);
        } else {
            String[] fileNames = sourceFile.list();
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    File file = new File(String.valueOf(sourceFile.getPath()) + "/" + fileNames[i]);
                    if (file.isFile()) {
                        this.pa.sourceFileList.add(file);
                    }
                    ++i;
                }
            } else {
                JOptionPane.showMessageDialog(this, "\u6307\u5b9a\u3055\u308c\u305f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", BcWords.getInstance().exception, 0);
            }
        }
        if (this.pa.sourceFileList.size() <= 0) {
            JOptionPane.showMessageDialog(this, "\u53d6\u8fbc\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", BcWords.getInstance().exception, 0);
            return;
        }
        this.pa.outpuFilePath = this.outputFilePathField.getText();
        this.pa.setPanel(ImptImportMappingPanel.class.getName());
    }

    protected void saveFilePath() throws Exception {
        Document generalConfig = AfbApplication.getInstance().getGeneralConfig();
        if (this.pa.definefFile != null) {
            BcXmlUtil.setTextValue(generalConfig.getDocumentElement(), "import/defineFile", this.pa.definefFile.getPath());
        }
        File sourceFileTmp = new File(this.sourceFilePathField.getText());
        BcXmlUtil.setTextValue(generalConfig.getDocumentElement(), "import/sourceFile", sourceFileTmp.getPath());
        AfbApplication.getInstance().updateGeneralConfig(generalConfig);
    }

    @Override
    protected void cancelButtonAction() {
        this.pa.cancelButtonAction();
    }

    @Override
    public void preShow() throws Exception {
        Document generalConfig = AfbApplication.getInstance().getGeneralConfig();
        String tmpStr = BcXmlUtil.getTextValue(generalConfig.getDocumentElement(), "import/defineFile");
        if (!BcStringUtil.isEmpty(tmpStr)) {
            this.defineFilePathField.setText(tmpStr);
        }
        if (!BcStringUtil.isEmpty(tmpStr = BcXmlUtil.getTextValue(generalConfig.getDocumentElement(), "import/sourceFile"))) {
            this.sourceFilePathField.setText(tmpStr);
        }
    }

    @Override
    public void shown() throws Exception {
    }

    @Override
    public void exit() throws Exception {
    }
}

