/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.rmo;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.module.impt.dao.ImptDefineIndexDAO;
import ext.module.impt.dao.ImptFileResourceDAO;
import ext.module.impt.dao.ImptImportContextDAO;
import ext.module.impt.model.ImptDefineIndex;
import ext.module.impt.model.ImptImportContext;
import ext.scf5.model.ScfFileResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;

public class ImptGeneralRMO
extends RmiAbstractRMO {
    public void getSourceRegistDirectry(RmiRmoArgument rmoArg) throws Exception {
        int defineIndexId = rmoArg.getRequest().getDataAsInteger();
        ImptImportContext importContext = new ImptImportContext();
        ImptImportContextDAO.getInstance().putImportContext(rmoArg.getDtsSession(this), importContext);
        File preserveBaseDir = new File(AfbApplication.getInstance().toReal("${ROOT}data/import/"));
        try {
            File preserveDir;
            if (!preserveBaseDir.exists()) {
                preserveBaseDir.mkdirs();
            }
            if ((preserveDir = new File(preserveBaseDir, BcStringUtil.fillPrefix(importContext.getDataId(), 8, '0'))).exists()) {
                BcFileUtil.deleteFile(preserveDir);
            }
            preserveDir.mkdirs();
            if (defineIndexId > 0) {
                ImptDefineIndex defineIndex = ImptDefineIndexDAO.getInstance().getDefineIndex(rmoArg.getDtsSession(this), defineIndexId);
                ScfFileResource fileResource = ImptFileResourceDAO.getInstance().getFileResource(rmoArg.getDtsSession(this), defineIndex.fileResourceId);
                byte[] bytes = ImptFileResourceDAO.getInstance().getAsByteArray(rmoArg.getDtsSession(this), defineIndex.fileResourceId);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                File destFile = new File(preserveDir, fileResource.fileName);
                FileOutputStream os = new FileOutputStream(destFile.getPath(), false);
                BcStreamUtil.transmit(byteArrayInputStream, os, 4096);
                byteArrayInputStream.close();
                os.close();
            }
            rmoArg.getRespons().addData(importContext);
            rmoArg.getRespons().addData(preserveDir.getPath());
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            throw new Exception("\u30bd\u30fc\u30b9\u306e\u4fdd\u5b58\u306b\u304a\u3044\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u307e\u3057\u305f\u3002\n" + ex);
        }
    }
}

