/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.business.account;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.libx.business.account.BsnAccountsConstants;
import java.math.BigDecimal;

public final class BsnAccountsUtil {
    private BsnAccountsUtil() {
    }

    public static BigDecimal getConsumptionTaxRate(int baseDate) {
        BigDecimal taxRate = null;
        BsnAccountsConstants.ConsumptionTax[] consumptionTaxes = BsnAccountsConstants.ConsumptionTax.values();
        int i = 0;
        while (i < consumptionTaxes.length) {
            int idx = consumptionTaxes.length - i - 1;
            BsnAccountsConstants.ConsumptionTax consumptionTax = consumptionTaxes[idx];
            if (consumptionTax.getStartDate() <= baseDate) {
                taxRate = consumptionTax.getRate();
                break;
            }
            ++i;
        }
        if (taxRate == null) {
            taxRate = BigDecimal.ZERO;
        }
        taxRate = taxRate.setScale(BsnAccountsConstants.decimalPlaces, 4);
        return taxRate;
    }

    public static BigDecimal calcConsumptionTax(BigDecimal amount, int baseDate, int roundMode) {
        BigDecimal taxRate = BsnAccountsUtil.getConsumptionTaxRate(baseDate);
        BigDecimal taxPercent = taxRate.divide(new BigDecimal(100));
        BigDecimal tax = amount.multiply(taxPercent);
        tax = tax.setScale(0, roundMode);
        return tax;
    }

    public static BigDecimal calcConsumptionTax(long amount, int baseDate, int roundMode) {
        return BsnAccountsUtil.calcConsumptionTax(new BigDecimal(amount), baseDate, roundMode);
    }

    public static BigDecimal[] calcBasePrice(BigDecimal taxIncludedPrice, BigDecimal taxRate, int roundMode) {
        BigDecimal tmp1 = taxRate.add(new BigDecimal(100));
        tmp1 = taxIncludedPrice.divide(tmp1, BsnAccountsConstants.decimalPlaces, 4);
        BigDecimal basePrice = tmp1.multiply(new BigDecimal(100));
        basePrice = basePrice.setScale(BsnAccountsConstants.decimalPlaces, roundMode);
        BigDecimal tax = taxIncludedPrice.subtract(basePrice);
        BigDecimal[] res = new BigDecimal[]{basePrice, tax};
        return res;
    }

    public static BigDecimal[] calcBasePrice(BigDecimal taxIncludedPrice, int baseDate, int roundMode) {
        BigDecimal taxRate = BsnAccountsUtil.getConsumptionTaxRate(baseDate);
        return BsnAccountsUtil.calcBasePrice(taxIncludedPrice, taxRate, roundMode);
    }

    public static BigDecimal calcDetailAmount(BigDecimal unitAmount, BigDecimal quantity, int roundMode) {
        BigDecimal bd1 = unitAmount.multiply(quantity);
        BigDecimal bd2 = bd1.setScale(BsnAccountsConstants.decimalPlaces, roundMode);
        return bd2;
    }

    public static BigDecimal toSummary(BigDecimal amount, int roundMode) {
        BigDecimal sum = amount.setScale(0, roundMode);
        return sum;
    }

    public static BigDecimal calcSummary(BigDecimal basePrice, BigDecimal tax, int roundMode) {
        BigDecimal amount2 = BsnAccountsUtil.toSummary(basePrice, roundMode);
        BigDecimal tax2 = BsnAccountsUtil.toSummary(tax, roundMode);
        BigDecimal summary = amount2.add(tax2);
        return summary;
    }

    public static String toString(Object amount, int decimalPlaces) throws Exception {
        String amountStr = "";
        if (amount != null) {
            amountStr = BcNumberUtil.toString(amount, decimalPlaces, 3);
        }
        return amountStr;
    }

    public static String[] divideIntegralAndDecimal(Object amount, int decimalPlaces) throws Exception {
        String amountStr = BsnAccountsUtil.toString(amount, decimalPlaces);
        int index = amountStr.indexOf(BcStringUtil.DOT_STR);
        String integra = "";
        String decimal = "";
        if (index >= 0) {
            integra = amountStr.substring(0, index);
            decimal = amountStr.substring(index + 1);
        } else {
            integra = amountStr;
        }
        String[] amountTexts = new String[]{integra, decimal};
        return amountTexts;
    }

    public static String toSummaryString(Object price) throws Exception {
        String priceStyle = "";
        if (price != null) {
            priceStyle = String.valueOf(BsnAccountsConstants.CURRECY_SYMBOL_yen) + BsnAccountsUtil.toString(price, 0) + BsnAccountsConstants.CURRECY_SUFFIX;
        }
        return priceStyle;
    }
}

