/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.table.BcTableUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.swg.SwgMenuItem;
import ext.lib.swg.SwgTableCellEditor;
import ext.lib.swg.SwgTableCellRenderer;
import ext.lib.swg.SwgTableHeader;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.SwgUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SwgTableView
extends JTable
implements Serializable {
    private static final long serialVersionUID = -1192045687193039512L;
    protected TableCellRenderer defaultCellRenderer;
    protected TableCellEditor defaultCellEditor;
    protected List<ListSelectionListener> listSelectionListenerList = new ArrayList<ListSelectionListener>();
    protected int componentShownCnt;
    protected MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent ev) {
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            try {
                SwgTableView.this.mouseReleased2(ev);
            }
            catch (Exception ex) {
                SwgTableView.this.exceptionHandle(ex);
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
        }
    };
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            SwgTableView.this.actionPerformed2(ev);
        }
    };
    protected int mousePointX = -1;
    protected int mousePointY = -1;
    protected JPopupMenu popupMenu;
    protected SwgMenuItem copyRowMenu;
    protected SwgMenuItem copyColumnMenu;
    protected MouseAdapter headerMouseAdapter;

    public SwgTableView(TableModel tableModel) throws Exception {
        super(tableModel);
        this.init();
    }

    public SwgTableView(TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
        super(tableModel, tableColumnModel);
        this.init();
    }

    protected void init() throws Exception {
        this.setAutoResizeMode(0);
        this.setShowGrid(true);
        this.setRowHeight(SwgTableViewUtil.ROW_HEIGHT);
        this.setRowMargin(0);
        this.setIntercellSpacing(SwgTableViewUtil.INTERCELL_SPACING);
        this.setTableHeader(new SwgTableHeader(this.getColumnModel()));
        this.setDefaultCellRenderer(new SwgTableCellRenderer());
        this.setDefaultCellEditor(new SwgTableCellEditor());
        this.setSelectionMode(0);
        this.setColumnWidth();
        this.setSorter();
        Color bgColor = this.getBackground();
        this.setGridColor(SwgTableViewUtil.toGridColor(bgColor));
        this.setSelectionBackground(SwgTableViewUtil.toRowSelectedBg(bgColor));
        this.setSelectionForeground(SwgTableViewUtil.toRowSelectedFg(bgColor));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.getDefaultEditor(Object.class);
        defaultCellEditor.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent ev) {
                if (SwgTableView.this.isEditing()) {
                    SwgTableView.this.getCellEditor().stopCellEditing();
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (SwgTableView.this.isEditing()) {
                    SwgTableView.this.getCellEditor().stopCellEditing();
                }
            }
        });
        this.addMouseListener(this.mouseListener);
    }

    @Override
    public void columnAdded(TableColumnModelEvent ev) {
        super.columnAdded(ev);
        TableColumnModel tableColumnModel = (TableColumnModel)ev.getSource();
        BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(ev.getToIndex());
        if (this.getFont() != null) {
            try {
                SwgTableViewUtil.setColumnWidth(tableColumn, this.getFont());
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent ev) {
        super.columnMarginChanged(ev);
    }

    @Override
    public void columnMoved(TableColumnModelEvent ev) {
        super.columnMoved(ev);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent ev) {
        super.columnRemoved(ev);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent ev) {
        super.columnSelectionChanged(ev);
    }

    @Override
    public TableCellRenderer getCellRenderer(int rowrId, int columnId) {
        TableColumn tableColumn = this.getColumnModel().getColumn(columnId);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer != null) {
            return tableCellRenderer;
        }
        return this.defaultCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int rowrId, int columnId) {
        TableColumn tableColumn = this.getColumnModel().getColumn(columnId);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor != null) {
            return tableCellEditor;
        }
        return this.defaultCellEditor;
    }

    @Override
    public boolean isCellEditable(int rowrId, int columnId) {
        TableColumn tableColumn = this.getColumnModel().getColumn(columnId);
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass())) {
            BcTableColumn bcTableColumn = (BcTableColumn)tableColumn;
            return bcTableColumn.isEditable;
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        super.valueChanged(ev);
        if (this.listSelectionListenerList == null) {
            return;
        }
        ListSelectionListener[] listeners = this.listSelectionListenerList.toArray(new ListSelectionListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(ev);
            ++i;
        }
    }

    public TableCellRenderer getDefaultCellRenderer() {
        return this.defaultCellRenderer;
    }

    public void setDefaultCellRenderer(TableCellRenderer defaultCellRenderer) {
        this.defaultCellRenderer = defaultCellRenderer;
    }

    public TableCellEditor getDefaultCellEditor() {
        return this.defaultCellEditor;
    }

    public void setDefaultCellEditor(TableCellEditor defaultCellEditor) {
        this.defaultCellEditor = defaultCellEditor;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListenerList.add(listener);
    }

    public boolean removeListSelectionListener(ListSelectionListener listener) {
        return this.listSelectionListenerList.remove(listener);
    }

    protected void setSorter() throws Exception {
        this.setColumnSelectionAllowed(false);
        if (!BcTableModel.class.isAssignableFrom(this.getModel().getClass())) {
            return;
        }
        final BcTableModel tableModel = (BcTableModel)this.getModel();
        this.headerMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                try {
                    BcTableColumnModel tableColumnModel;
                    int columnId;
                    if (ev.getClickCount() == 1 && (columnId = (tableColumnModel = (BcTableColumnModel)SwgTableView.this.getColumnModel()).getColumnIndexAtX(ev.getX())) >= 0) {
                        TableColumn tableColumn = tableColumnModel.getColumn(columnId);
                        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass())) {
                            BcTableColumn tableColumn2 = (BcTableColumn)tableColumn;
                            tableColumn2.ascending = !tableColumn2.ascending;
                            BcTableUtil.sort(tableModel, tableColumn2.ascending, columnId);
                        } else {
                            int shiftPressed = ev.getModifiers() & 1;
                            boolean ascending = shiftPressed == 0;
                            BcTableUtil.sort(tableModel, ascending, columnId);
                        }
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        };
        this.getTableHeader().addMouseListener(this.headerMouseAdapter);
    }

    public void cancelSorter() throws Exception {
        if (this.headerMouseAdapter != null) {
            this.getTableHeader().removeMouseListener(this.headerMouseAdapter);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(SwgUtil.getTextFieldSize((Font)this.getFont()).height);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setFont(font);
        }
        try {
            this.setColumnWidth();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected void setColumnWidth() throws Exception {
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)this.getColumnModel().getColumn(i);
            SwgTableViewUtil.setColumnWidth(tableColumn, this.getFont());
            ++i;
        }
        this.getTableHeader().validate();
    }

    protected void mouseReleased2(MouseEvent ev) throws Exception {
        this.mousePointX = ev.getX();
        this.mousePointY = ev.getY();
        if (ev.isPopupTrigger()) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.copyRowMenu = new SwgMenuItem(BcWords.getInstance().copy, new ImageIcon(AwtImageHelper.getImage_icon("copy_64x64.png")));
                this.copyRowMenu.addActionListener(this.actionListener);
                this.popupMenu.add(this.copyRowMenu);
                this.copyColumnMenu = new SwgMenuItem(String.valueOf(BcWords.getInstance().copy) + "\uff08\u5217\uff09", new ImageIcon(AwtImageHelper.getImage_icon("copy_64x64.png")));
                this.copyColumnMenu.addActionListener(this.actionListener);
                this.popupMenu.add(this.copyColumnMenu);
            }
            this.popupMenu.show(this, ev.getX(), ev.getY());
        }
    }

    protected void actionPerformed2(ActionEvent ev) {
        try {
            this.actionPerformed3(ev);
        }
        catch (Exception ex) {
            this.exceptionHandle(ex);
        }
    }

    protected void actionPerformed3(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.copyRowMenu) {
            StringBuilder sb = new StringBuilder();
            int[] rowViewIdxs = this.getSelectedRows();
            int i = 0;
            while (i < rowViewIdxs.length) {
                if (i > 0) {
                    sb.append('\r');
                    sb.append('\n');
                }
                int j = 0;
                while (j < this.getColumnCount()) {
                    Object value = this.getValueAt(rowViewIdxs[i], j);
                    if (j > 0) {
                        sb.append('\t');
                    }
                    if (value != null) {
                        sb.append(value.toString());
                    }
                    ++j;
                }
                ++i;
            }
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        } else if (ev.getSource().hashCode() == this.copyColumnMenu.hashCode()) {
            int columnId = this.tableHeader.columnAtPoint(new Point(this.mousePointX, this.mousePointY));
            StringBuilder sb = new StringBuilder();
            int[] rowViewIdxs = this.getSelectedRows();
            int i = 0;
            while (i < rowViewIdxs.length) {
                Object value;
                if (i > 0) {
                    sb.append('\r');
                    sb.append('\n');
                }
                if ((value = this.getValueAt(rowViewIdxs[i], columnId)) != null) {
                    sb.append(value.toString());
                }
                ++i;
            }
            StringSelection stringSelection = new StringSelection(sb.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTable();
        }
        return this.accessibleContext;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            this.setValueAt(value, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        return super.getValueAt(row, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        int rowId = this.convertRowIndexToModel(row);
        int columnId = this.convertColumnIndexToModel(column);
        TableModel tableModel = this.getModel();
        tableModel.setValueAt(aValue, rowId, columnId);
    }

    @Override
    public void editingCanceled(ChangeEvent ev) {
        this.removeEditor();
    }

    @Override
    public JToolTip createToolTip() {
        return super.createToolTip();
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        return super.getToolTipText(ev);
    }

    protected void exceptionHandle(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        int lastSelectedRow;
        int lastSelectedCol;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescription;
        private Accessible[] columnDescription;

        protected AccessibleJTable() {
            super(SwgTableView.this);
            SwgTableView.this.addPropertyChangeListener(this);
            SwgTableView.this.getSelectionModel().addListSelectionListener(this);
            TableColumnModel tcm = SwgTableView.this.getColumnModel();
            tcm.addColumnModelListener(this);
            tcm.getSelectionModel().addListSelectionListener(this);
            SwgTableView.this.getModel().addTableModelListener(this);
            this.lastSelectedRow = SwgTableView.this.getSelectedRow();
            this.lastSelectedCol = SwgTableView.this.getSelectedColumn();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if (name.compareTo("model") == 0) {
                if (oldValue != null && oldValue instanceof TableModel) {
                    ((TableModel)oldValue).removeTableModelListener(this);
                }
                if (newValue != null && newValue instanceof TableModel) {
                    ((TableModel)newValue).addTableModelListener(this);
                }
            } else if (name.compareTo("selectionModel") == 0) {
                Object source = e.getSource();
                if (source == SwgTableView.this) {
                    if (oldValue != null && oldValue instanceof ListSelectionModel) {
                        ((ListSelectionModel)oldValue).removeListSelectionListener(this);
                    }
                    if (newValue != null && newValue instanceof ListSelectionModel) {
                        ((ListSelectionModel)newValue).addListSelectionListener(this);
                    }
                } else if (source == SwgTableView.this.getColumnModel()) {
                    if (oldValue != null && oldValue instanceof ListSelectionModel) {
                        ((ListSelectionModel)oldValue).removeListSelectionListener(this);
                    }
                    if (newValue != null && newValue instanceof ListSelectionModel) {
                        ((ListSelectionModel)newValue).addListSelectionListener(this);
                    }
                }
            } else if (name.compareTo("columnModel") == 0) {
                TableColumnModel tcm;
                if (oldValue != null && oldValue instanceof TableColumnModel) {
                    tcm = (TableColumnModel)oldValue;
                    tcm.removeColumnModelListener(this);
                    tcm.getSelectionModel().removeListSelectionListener(this);
                }
                if (newValue != null && newValue instanceof TableColumnModel) {
                    tcm = (TableColumnModel)newValue;
                    tcm.addColumnModelListener(this);
                    tcm.getSelectionModel().addListSelectionListener(this);
                }
            } else if (name.compareTo("tableCellEditor") == 0) {
                if (oldValue != null && oldValue instanceof TableCellEditor) {
                    ((TableCellEditor)oldValue).removeCellEditorListener(this);
                }
                if (newValue != null && newValue instanceof TableCellEditor) {
                    ((TableCellEditor)newValue).addCellEditorListener(this);
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            if (ev != null) {
                int firstColumn = ev.getColumn();
                int lastColumn = ev.getColumn();
                if (firstColumn == -1) {
                    firstColumn = 0;
                    lastColumn = SwgTableView.this.getColumnCount() - 1;
                }
                AccessibleJTableModelChange change = new AccessibleJTableModelChange(ev.getType(), ev.getFirstRow(), ev.getLastRow(), firstColumn, lastColumn);
                this.firePropertyChange("accessibleTableModelChanged", null, change);
            }
        }

        public void tableRowsInserted(TableModelEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int firstColumn = ev.getColumn();
            int lastColumn = ev.getColumn();
            if (firstColumn == -1) {
                firstColumn = 0;
                lastColumn = SwgTableView.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(ev.getType(), ev.getFirstRow(), ev.getLastRow(), firstColumn, lastColumn);
            this.firePropertyChange("accessibleTableModelChanged", null, change);
        }

        public void tableRowsDeleted(TableModelEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int firstColumn = ev.getColumn();
            int lastColumn = ev.getColumn();
            if (firstColumn == -1) {
                firstColumn = 0;
                lastColumn = SwgTableView.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(ev.getType(), ev.getFirstRow(), ev.getLastRow(), firstColumn, lastColumn);
            this.firePropertyChange("accessibleTableModelChanged", null, change);
        }

        @Override
        public void columnAdded(TableColumnModelEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int type = 1;
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(type, 0, 0, ev.getFromIndex(), ev.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, change);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int type = -1;
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(type, 0, 0, ev.getFromIndex(), ev.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, change);
        }

        @Override
        public void columnMoved(TableColumnModelEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int type = -1;
            AccessibleJTableModelChange change = new AccessibleJTableModelChange(type, 0, 0, ev.getFromIndex(), ev.getFromIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, change);
            int type2 = 1;
            AccessibleJTableModelChange change2 = new AccessibleJTableModelChange(type2, 0, 0, ev.getToIndex(), ev.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, change2);
        }

        @Override
        public void columnMarginChanged(ChangeEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent ev) {
        }

        @Override
        public void editingStopped(ChangeEvent ev) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void editingCanceled(ChangeEvent ev) {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            this.firePropertyChange("AccessibleSelection", false, true);
            int selectedRow = SwgTableView.this.getSelectedRow();
            int selectedCol = SwgTableView.this.getSelectedColumn();
            if (selectedRow != this.lastSelectedRow || selectedCol != this.lastSelectedCol) {
                Accessible oldA = this.getAccessibleAt(this.lastSelectedRow, this.lastSelectedCol);
                Accessible newA = this.getAccessibleAt(selectedRow, selectedCol);
                this.firePropertyChange("AccessibleActiveDescendant", oldA, newA);
                this.lastSelectedRow = selectedRow;
                this.lastSelectedCol = selectedCol;
            }
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int column = SwgTableView.this.columnAtPoint(point);
            int row = SwgTableView.this.rowAtPoint(point);
            if (column != -1 && row != -1) {
                TableColumn aColumn = SwgTableView.this.getColumnModel().getColumn(column);
                TableCellRenderer renderer = aColumn.getCellRenderer();
                if (renderer == null) {
                    Class<?> columnClass = SwgTableView.this.getColumnClass(column);
                    renderer = SwgTableView.this.getDefaultRenderer(columnClass);
                }
                Component component = renderer.getTableCellRendererComponent(SwgTableView.this, null, false, false, row, column);
                return new AccessibleJTableCell(SwgTableView.this, row, column, this.getAccessibleIndexAt(row, column));
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return SwgTableView.this.getColumnCount() * SwgTableView.this.getRowCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            TableColumn aColumn = SwgTableView.this.getColumnModel().getColumn(column);
            TableCellRenderer renderer = aColumn.getCellRenderer();
            if (renderer == null) {
                Class<?> columnClass = SwgTableView.this.getColumnClass(column);
                renderer = SwgTableView.this.getDefaultRenderer(columnClass);
            }
            Component component = renderer.getTableCellRendererComponent(SwgTableView.this, null, false, false, row, column);
            return new AccessibleJTableCell(SwgTableView.this, row, column, this.getAccessibleIndexAt(row, column));
        }

        @Override
        public int getAccessibleSelectionCount() {
            int rowsSel = SwgTableView.this.getSelectedRowCount();
            int colsSel = SwgTableView.this.getSelectedColumnCount();
            if (SwgTableView.this.cellSelectionEnabled) {
                return rowsSel * colsSel;
            }
            if (SwgTableView.this.getRowSelectionAllowed() && SwgTableView.this.getColumnSelectionAllowed()) {
                return rowsSel * SwgTableView.this.getColumnCount() + colsSel * SwgTableView.this.getRowCount() - rowsSel * colsSel;
            }
            if (SwgTableView.this.getRowSelectionAllowed()) {
                return rowsSel * SwgTableView.this.getColumnCount();
            }
            if (SwgTableView.this.getColumnSelectionAllowed()) {
                return colsSel * SwgTableView.this.getRowCount();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i > this.getAccessibleSelectionCount()) {
                return null;
            }
            int rowsSel = SwgTableView.this.getSelectedRowCount();
            int colsSel = SwgTableView.this.getSelectedColumnCount();
            int[] rowIndicies = SwgTableView.this.getSelectedRows();
            int[] colIndicies = SwgTableView.this.getSelectedColumns();
            int ttlCols = SwgTableView.this.getColumnCount();
            int ttlRows = SwgTableView.this.getRowCount();
            if (SwgTableView.this.cellSelectionEnabled) {
                int r = rowIndicies[i / colsSel];
                int c = colIndicies[i % colsSel];
                return this.getAccessibleChild(r * ttlCols + c);
            }
            if (SwgTableView.this.getRowSelectionAllowed() && SwgTableView.this.getColumnSelectionAllowed()) {
                int curIndex = i;
                boolean IN_ROW = false;
                boolean NOT_IN_ROW = true;
                int state = rowIndicies[0] == 0 ? 0 : 1;
                int j = 0;
                int prevRow = -1;
                while (j < rowIndicies.length) {
                    switch (state) {
                        case 0: {
                            if (curIndex < ttlCols) {
                                int c = curIndex % ttlCols;
                                int r = rowIndicies[j];
                                return this.getAccessibleChild(r * ttlCols + c);
                            }
                            curIndex -= ttlCols;
                            if (j + 1 == rowIndicies.length || rowIndicies[j] != rowIndicies[j + 1] - 1) {
                                state = 1;
                                prevRow = rowIndicies[j];
                            }
                            ++j;
                            break;
                        }
                        case 1: {
                            if (curIndex < colsSel * (rowIndicies[j] - (prevRow == -1 ? 0 : prevRow + 1))) {
                                int c = colIndicies[curIndex % colsSel];
                                int r = (j > 0 ? rowIndicies[j - 1] + 1 : 0) + curIndex / colsSel;
                                return this.getAccessibleChild(r * ttlCols + c);
                            }
                            curIndex -= colsSel * (rowIndicies[j] - (prevRow == -1 ? 0 : prevRow + 1));
                            state = 0;
                        }
                    }
                }
                if (curIndex < colsSel * (ttlRows - (prevRow == -1 ? 0 : prevRow + 1))) {
                    int c = colIndicies[curIndex % colsSel];
                    int r = rowIndicies[j - 1] + curIndex / colsSel + 1;
                    return this.getAccessibleChild(r * ttlCols + c);
                }
            } else {
                if (SwgTableView.this.getRowSelectionAllowed()) {
                    int c = i % ttlCols;
                    int r = rowIndicies[i / ttlCols];
                    return this.getAccessibleChild(r * ttlCols + c);
                }
                if (SwgTableView.this.getColumnSelectionAllowed()) {
                    int c = colIndicies[i % colsSel];
                    int r = i / colsSel;
                    return this.getAccessibleChild(r * ttlCols + c);
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            return SwgTableView.this.isCellSelected(row, column);
        }

        @Override
        public void addAccessibleSelection(int i) {
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            SwgTableView.this.changeSelection(row, column, true, false);
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (SwgTableView.this.cellSelectionEnabled) {
                int column = this.getAccessibleColumnAtIndex(i);
                int row = this.getAccessibleRowAtIndex(i);
                SwgTableView.this.removeRowSelectionInterval(row, row);
                SwgTableView.this.removeColumnSelectionInterval(column, column);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            SwgTableView.this.clearSelection();
        }

        @Override
        public void selectAllAccessibleSelection() {
            if (SwgTableView.this.cellSelectionEnabled) {
                SwgTableView.this.selectAll();
            }
        }

        @Override
        public int getAccessibleRow(int index) {
            return this.getAccessibleRowAtIndex(index);
        }

        @Override
        public int getAccessibleColumn(int index) {
            return this.getAccessibleColumnAtIndex(index);
        }

        @Override
        public int getAccessibleIndex(int r, int c) {
            return this.getAccessibleIndexAt(r, c);
        }

        @Override
        public AccessibleTable getAccessibleTable() {
            return this;
        }

        @Override
        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        @Override
        public void setAccessibleCaption(Accessible a) {
            Accessible oldCaption = this.caption;
            this.caption = a;
            this.firePropertyChange("accessibleTableCaptionChanged", oldCaption, this.caption);
        }

        @Override
        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        @Override
        public void setAccessibleSummary(Accessible a) {
            Accessible oldSummary = this.summary;
            this.summary = a;
            this.firePropertyChange("accessibleTableSummaryChanged", oldSummary, this.summary);
        }

        @Override
        public int getAccessibleRowCount() {
            return SwgTableView.this.getRowCount();
        }

        @Override
        public int getAccessibleColumnCount() {
            return SwgTableView.this.getColumnCount();
        }

        @Override
        public Accessible getAccessibleAt(int r, int c) {
            return this.getAccessibleChild(r * this.getAccessibleColumnCount() + c);
        }

        @Override
        public int getAccessibleRowExtentAt(int r, int c) {
            return 1;
        }

        @Override
        public int getAccessibleColumnExtentAt(int r, int c) {
            return 1;
        }

        @Override
        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        @Override
        public void setAccessibleRowHeader(AccessibleTable a) {
        }

        @Override
        public AccessibleTable getAccessibleColumnHeader() {
            JTableHeader header = SwgTableView.this.getTableHeader();
            return header == null ? null : new AccessibleTableHeader(header);
        }

        @Override
        public void setAccessibleColumnHeader(AccessibleTable a) {
        }

        @Override
        public Accessible getAccessibleRowDescription(int r) {
            if (r < 0 || r >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(r).toString());
            }
            if (this.rowDescription == null) {
                return null;
            }
            return this.rowDescription[r];
        }

        @Override
        public void setAccessibleRowDescription(int r, Accessible a) {
            if (r < 0 || r >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(r).toString());
            }
            if (this.rowDescription == null) {
                int numRows = this.getAccessibleRowCount();
                this.rowDescription = new Accessible[numRows];
            }
            this.rowDescription[r] = a;
        }

        @Override
        public Accessible getAccessibleColumnDescription(int c) {
            if (c < 0 || c >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(c).toString());
            }
            if (this.columnDescription == null) {
                return null;
            }
            return this.columnDescription[c];
        }

        @Override
        public void setAccessibleColumnDescription(int c, Accessible a) {
            if (c < 0 || c >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(c).toString());
            }
            if (this.columnDescription == null) {
                int numColumns = this.getAccessibleColumnCount();
                this.columnDescription = new Accessible[numColumns];
            }
            this.columnDescription[c] = a;
        }

        @Override
        public boolean isAccessibleSelected(int r, int c) {
            return SwgTableView.this.isCellSelected(r, c);
        }

        @Override
        public boolean isAccessibleRowSelected(int r) {
            return SwgTableView.this.isRowSelected(r);
        }

        @Override
        public boolean isAccessibleColumnSelected(int c) {
            return SwgTableView.this.isColumnSelected(c);
        }

        @Override
        public int[] getSelectedAccessibleRows() {
            return SwgTableView.this.getSelectedRows();
        }

        @Override
        public int[] getSelectedAccessibleColumns() {
            return SwgTableView.this.getSelectedColumns();
        }

        public int getAccessibleRowAtIndex(int i) {
            int columnCount = this.getAccessibleColumnCount();
            if (columnCount == 0) {
                return -1;
            }
            return i / columnCount;
        }

        public int getAccessibleColumnAtIndex(int i) {
            int columnCount = this.getAccessibleColumnCount();
            if (columnCount == 0) {
                return -1;
            }
            return i % columnCount;
        }

        public int getAccessibleIndexAt(int r, int c) {
            return r * this.getAccessibleColumnCount() + c;
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable parent;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(JTable t, int r, int c, int i) {
                this.parent = t;
                this.row = r;
                this.column = c;
                this.index = i;
                this.setAccessibleParent(this.parent);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            protected AccessibleContext getCurrentAccessibleContext() {
                Component component;
                TableColumn aColumn = SwgTableView.this.getColumnModel().getColumn(this.column);
                TableCellRenderer renderer = aColumn.getCellRenderer();
                if (renderer == null) {
                    Class<?> columnClass = SwgTableView.this.getColumnClass(this.column);
                    renderer = SwgTableView.this.getDefaultRenderer(columnClass);
                }
                if ((component = renderer.getTableCellRendererComponent(SwgTableView.this, SwgTableView.this.getValueAt(this.row, this.column), false, false, this.row, this.column)) instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            protected Component getCurrentComponent() {
                TableColumn aColumn = SwgTableView.this.getColumnModel().getColumn(this.column);
                TableCellRenderer renderer = aColumn.getCellRenderer();
                if (renderer == null) {
                    Class<?> columnClass = SwgTableView.this.getColumnClass(this.column);
                    renderer = SwgTableView.this.getDefaultRenderer(columnClass);
                }
                return renderer.getTableCellRendererComponent(SwgTableView.this, null, false, false, this.row, this.column);
            }

            @Override
            public String getAccessibleName() {
                String name;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && (name = ac.getAccessibleName()) != null && name != "") {
                    return name;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return (String)SwgTableView.this.getClientProperty("AccessibleName");
            }

            @Override
            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                } else {
                    super.setAccessibleName(s);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                } else {
                    super.setAccessibleDescription(s);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rcell;
                Rectangle rjt;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                AccessibleStateSet as = null;
                if (ac != null) {
                    as = ac.getAccessibleStateSet();
                }
                if (as == null) {
                    as = new AccessibleStateSet();
                }
                if ((rjt = SwgTableView.this.getVisibleRect()).intersects(rcell = SwgTableView.this.getCellRect(this.row, this.column, false))) {
                    as.add(AccessibleState.SHOWING);
                } else if (as.contains(AccessibleState.SHOWING)) {
                    as.remove(AccessibleState.SHOWING);
                }
                if (this.parent.isCellSelected(this.row, this.column)) {
                    as.add(AccessibleState.SELECTED);
                } else if (as.contains(AccessibleState.SELECTED)) {
                    as.remove(AccessibleState.SELECTED);
                }
                if (this.row == SwgTableView.this.getSelectedRow() && this.column == SwgTableView.this.getSelectedColumn()) {
                    as.add(AccessibleState.ACTIVE);
                }
                as.add(AccessibleState.TRANSIENT);
                return as;
            }

            @Override
            public Accessible getAccessibleParent() {
                return this.parent;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.index;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    Accessible accessibleChild = ac.getAccessibleChild(i);
                    ac.setAccessibleParent(this);
                    return accessibleChild;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                } else {
                    super.addPropertyChangeListener(l);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                } else {
                    super.removePropertyChangeListener(l);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            @Override
            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isVisible();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isVisible();
                }
                return false;
            }

            @Override
            public void setVisible(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setVisible(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setVisible(b);
                    }
                }
            }

            @Override
            public boolean isShowing() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    if (ac.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)ac)).isShowing();
                    }
                    return this.isVisible();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isShowing();
                }
                return false;
            }

            @Override
            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point parentLocation = this.parent.getLocationOnScreen();
                    Point componentLocation = this.getLocation();
                    componentLocation.translate(parentLocation.x, parentLocation.y);
                    return componentLocation;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                Rectangle r;
                if (this.parent != null && (r = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return r.getLocation();
                }
                return null;
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellRect(this.row, this.column, false);
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setBounds(r);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                Rectangle r;
                if (this.parent != null && (r = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return r.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }
        }

        private class AccessibleJTableHeaderCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int row;
            private int column;
            private JTableHeader parent;
            private Component rendererComponent;

            public AccessibleJTableHeaderCell(int row, int column, JTableHeader parent, Component rendererComponent) {
                this.row = row;
                this.column = column;
                this.parent = parent;
                this.rendererComponent = rendererComponent;
                this.setAccessibleParent(parent);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                return this.rendererComponent.getAccessibleContext();
            }

            private Component getCurrentComponent() {
                return this.rendererComponent;
            }

            @Override
            public String getAccessibleName() {
                String name;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && (name = ac.getAccessibleName()) != null && name != "") {
                    return ac.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            @Override
            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                } else {
                    super.setAccessibleName(s);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                } else {
                    super.setAccessibleDescription(s);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rcell;
                Rectangle rjt;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                AccessibleStateSet as = null;
                if (ac != null) {
                    as = ac.getAccessibleStateSet();
                }
                if (as == null) {
                    as = new AccessibleStateSet();
                }
                if ((rjt = SwgTableView.this.getVisibleRect()).intersects(rcell = SwgTableView.this.getCellRect(this.row, this.column, false))) {
                    as.add(AccessibleState.SHOWING);
                } else if (as.contains(AccessibleState.SHOWING)) {
                    as.remove(AccessibleState.SHOWING);
                }
                if (SwgTableView.this.isCellSelected(this.row, this.column)) {
                    as.add(AccessibleState.SELECTED);
                } else if (as.contains(AccessibleState.SELECTED)) {
                    as.remove(AccessibleState.SELECTED);
                }
                if (this.row == SwgTableView.this.getSelectedRow() && this.column == SwgTableView.this.getSelectedColumn()) {
                    as.add(AccessibleState.ACTIVE);
                }
                as.add(AccessibleState.TRANSIENT);
                return as;
            }

            @Override
            public Accessible getAccessibleParent() {
                return this.parent;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.column;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    Accessible accessibleChild = ac.getAccessibleChild(i);
                    ac.setAccessibleParent(this);
                    return accessibleChild;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                } else {
                    super.addPropertyChangeListener(l);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                } else {
                    super.removePropertyChangeListener(l);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            @Override
            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isVisible();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isVisible();
                }
                return false;
            }

            @Override
            public void setVisible(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setVisible(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setVisible(b);
                    }
                }
            }

            @Override
            public boolean isShowing() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    if (ac.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)ac)).isShowing();
                    }
                    return this.isVisible();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isShowing();
                }
                return false;
            }

            @Override
            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point parentLocation = this.parent.getLocationOnScreen();
                    Point componentLocation = this.getLocation();
                    componentLocation.translate(parentLocation.x, parentLocation.y);
                    return componentLocation;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                Rectangle r;
                if (this.parent != null && (r = this.parent.getHeaderRect(this.column)) != null) {
                    return r.getLocation();
                }
                return null;
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getHeaderRect(this.column);
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setBounds(r);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                Rectangle r;
                if (this.parent != null && (r = this.parent.getHeaderRect(this.column)) != null) {
                    return r.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(int type, int firstRow, int lastRow, int firstColumn, int lastColumn) {
                this.type = type;
                this.firstRow = firstRow;
                this.lastRow = lastRow;
                this.firstColumn = firstColumn;
                this.lastColumn = lastColumn;
            }

            @Override
            public int getType() {
                return this.type;
            }

            @Override
            public int getFirstRow() {
                return this.firstRow;
            }

            @Override
            public int getLastRow() {
                return this.lastRow;
            }

            @Override
            public int getFirstColumn() {
                return this.firstColumn;
            }

            @Override
            public int getLastColumn() {
                return this.lastColumn;
            }
        }

        private class AccessibleTableHeader
        implements AccessibleTable {
            private JTableHeader header;
            private TableColumnModel headerModel;

            AccessibleTableHeader(JTableHeader header) {
                this.header = header;
                this.headerModel = header.getColumnModel();
            }

            @Override
            public Accessible getAccessibleCaption() {
                return null;
            }

            @Override
            public void setAccessibleCaption(Accessible a) {
            }

            @Override
            public Accessible getAccessibleSummary() {
                return null;
            }

            @Override
            public void setAccessibleSummary(Accessible a) {
            }

            @Override
            public int getAccessibleRowCount() {
                return 1;
            }

            @Override
            public int getAccessibleColumnCount() {
                return this.headerModel.getColumnCount();
            }

            @Override
            public Accessible getAccessibleAt(int row, int column) {
                TableColumn aColumn = this.headerModel.getColumn(column);
                TableCellRenderer renderer = aColumn.getHeaderRenderer();
                if (renderer == null) {
                    renderer = this.header.getDefaultRenderer();
                }
                Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
                return new AccessibleJTableHeaderCell(row, column, SwgTableView.this.getTableHeader(), component);
            }

            @Override
            public int getAccessibleRowExtentAt(int r, int c) {
                return 1;
            }

            @Override
            public int getAccessibleColumnExtentAt(int r, int c) {
                return 1;
            }

            @Override
            public AccessibleTable getAccessibleRowHeader() {
                return null;
            }

            @Override
            public void setAccessibleRowHeader(AccessibleTable table) {
            }

            @Override
            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            @Override
            public void setAccessibleColumnHeader(AccessibleTable table) {
            }

            @Override
            public Accessible getAccessibleRowDescription(int r) {
                return null;
            }

            @Override
            public void setAccessibleRowDescription(int r, Accessible a) {
            }

            @Override
            public Accessible getAccessibleColumnDescription(int c) {
                return null;
            }

            @Override
            public void setAccessibleColumnDescription(int c, Accessible a) {
            }

            @Override
            public boolean isAccessibleSelected(int r, int c) {
                return false;
            }

            @Override
            public boolean isAccessibleRowSelected(int r) {
                return false;
            }

            @Override
            public boolean isAccessibleColumnSelected(int c) {
                return false;
            }

            @Override
            public int[] getSelectedAccessibleRows() {
                return new int[0];
            }

            @Override
            public int[] getSelectedAccessibleColumns() {
                return new int[0];
            }
        }
    }
}

