/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_PostgreSQL;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class SqlContext_PostgreSQL
extends SqlContext {
    public static final String DRIVER_NAME = "org.postgresql.Driver";
    public static final String[] DRIVER_NAMES = new String[]{"org.postgresql.Driver"};
    public static final int CHAR_MAX = -2021;
    public static final int PORT_DEFAULT = 5432;

    public SqlContext_PostgreSQL(SqlConstants.DatabaseProduct productName) {
        super(productName);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 5432;
    }

    @Override
    public String type_TINYINT() {
        return this.type_SMALLINT();
    }

    @Override
    public String type_NUMERIC(int precision, int scale) {
        return "NUMERIC(" + precision + ", " + scale + ")";
    }

    @Override
    public String type_CHAR(int size) {
        if (size <= -2021) {
            return "CHAR(" + size + ")";
        }
        return this.type_LONGVARCHAR();
    }

    @Override
    public String type_LONGVARCHAR() {
        return "TEXT";
    }

    @Override
    public String type_BINARY() {
        return this.type_BLOB();
    }

    @Override
    public String type_BLOB() {
        return "BYTEA";
    }

    @Override
    public void set_BLOB(PreparedStatement ppst, int colmunIndex, Blob blob) throws Exception {
        if (blob == null) {
            this.setNull_BLOB(ppst, colmunIndex);
            return;
        }
        InputStream is = blob.getBinaryStream();
        if (is == null) {
            this.setNull_BLOB(ppst, colmunIndex);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BcStreamUtil.transmit(is, byteArrayOutputStream, 1024);
        is.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        if (byteArrayOutputStream.size() > 0) {
            ppst.setBinaryStream(colmunIndex, (InputStream)byteArrayInputStream, byteArrayOutputStream.size());
        } else {
            this.setNull_BLOB(ppst, colmunIndex);
        }
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, -4);
    }

    @Override
    public String reformForMetadata(CharSequence objectName) throws Exception {
        if (objectName == null) {
            return null;
        }
        return objectName.toString().toLowerCase();
    }

    @Override
    public int dropIndex(SqlConnection dbCon, String tableName, String indexName) throws Exception {
        String query = "DROP INDEX " + indexName;
        BcLogUtil.info("query=" + query);
        return SqlUtil.executeUpdate(dbCon, query);
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public StringBuilder toNumber(String columnName, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TO_NUMBER(");
        sb.append(columnName);
        sb.append(",");
        sb.append("'" + BcStringUtil.fill('9', length) + "'");
        sb.append(")");
        return sb;
    }

    @Override
    public String func_clockTimestamp() throws Exception {
        return "clock_timestamp()";
    }

    @Override
    public String func_transactionTimestamp() throws Exception {
        return "c";
    }

    @Override
    public String func_replace_regexp(String src, String regexp, String replacement) throws Exception {
        return this.func_replace_regexp(src, BcStringUtil.singleQuotation(regexp), BcStringUtil.singleQuotation(replacement), BcStringUtil.singleQuotation(RegexFrag.g.name()));
    }

    @Override
    public String escapeForPatternMatch(String pattern) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            char curChar = pattern.charAt(i);
            switch (curChar) {
                case '%': 
                case '_': {
                    sb.append('\\');
                    sb.append('\\');
                    sb.append(curChar);
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql);
        sb = BcStringUtil.replace(sb, " DECIMAL", " NUMERIC", false);
        return sb.toString();
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs) throws SQLException {
        return new SqlResultSet_PostgreSQL(rs, this);
    }

    public static enum RegexFrag {
        i,
        g;

    }
}

