/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_Oracle;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlStatement_Oracle;
import ext.lib.sql.context.SqlContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import oracle.sql.TIMESTAMP;

public class SqlContext_Oracle
extends SqlContext {
    public static final String DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
    public static final String[] DRIVER_NAMES = new String[]{"oracle.jdbc.driver.OracleDriver"};
    public static final int PORT_DEFAULT = 1521;

    public SqlContext_Oracle(SqlConstants.DatabaseProduct productName) {
        super(productName);
    }

    @Override
    public SqlStatement createStatement(SqlConnection sqlConnection, Statement stmt1) throws SQLException {
        SqlStatement_Oracle stmt2 = new SqlStatement_Oracle(sqlConnection, stmt1, this);
        return stmt2;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 1521;
    }

    public String create_NUMBER(int precision) {
        return String.format("NUMBER(%d)", precision);
    }

    @Override
    public String type_TINYINT() {
        return this.create_NUMBER(DataSize.TINYINT.precision);
    }

    @Override
    public String type_SMALLINT() {
        return this.create_NUMBER(DataSize.SMALLINT.precision);
    }

    @Override
    public String type_INTEGER() {
        return this.create_NUMBER(DataSize.INTEGER.precision);
    }

    @Override
    public String type_BIGINT() {
        return this.create_NUMBER(DataSize.BIGINT.precision);
    }

    @Override
    public String type_REAL() {
        return "BINARY_FLOAT";
    }

    @Override
    public String type_DOUBLE() {
        return "BINARY_DOUBLE";
    }

    @Override
    public String type_NUMERIC(int precision, int scale) {
        return "NUMBER(" + precision + ", " + scale + ")";
    }

    @Override
    public String type_VARCHAR(int size) {
        if (size <= 2000) {
            return "VARCHAR2(" + size + " CHAR)";
        }
        return this.type_LONGVARCHAR();
    }

    @Override
    public String type_LONGVARCHAR() {
        return this.type_VARCHAR(2000);
    }

    @Override
    public String type_TIME() {
        return this.type_DATE();
    }

    @Override
    public String type_BOOLEAN() {
        return this.type_TINYINT();
    }

    @Override
    public String type_BINARY() {
        return "BLOB";
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb1 = new StringBuilder();
        sb1.append(String.valueOf(srcSql) + " OFFSET 0 ROWS FETCH FIRST 1 ROWS ONLY");
        return sb1.toString();
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql);
        sb = BcStringUtil.replace(sb, " BIGINT", " NUMBER(19, 0)", false);
        sb = BcStringUtil.replace(sb, " TEXT", " CLOB", false);
        sb = BcStringUtil.replace(sb, " BYTEA", " BLOB", false);
        return sb.toString();
    }

    @Override
    public Object objectConvert(Object srcObj, Class toClass) throws Exception {
        if (srcObj == null) {
            return super.objectConvert(srcObj, toClass);
        }
        Class<?> fromClass = srcObj.getClass();
        if (fromClass.equals(toClass)) {
            return srcObj;
        }
        Object newObject = null;
        if (TIMESTAMP.class.isAssignableFrom(fromClass)) {
            TIMESTAMP oracleTimestamp = (TIMESTAMP)srcObj;
            Timestamp timestamp = oracleTimestamp.timestampValue();
            newObject = super.objectConvert(timestamp, toClass);
        } else {
            newObject = super.objectConvert(srcObj, toClass);
        }
        return newObject;
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs) throws SQLException {
        return new SqlResultSet_Oracle(rs, this);
    }

    public static enum DataSize {
        TINYINT(3),
        SMALLINT(5),
        INTEGER(10),
        BIGINT(19),
        REAL(23),
        DOUBLE(49);

        public final int precision;

        private DataSize(int precision) {
            this.precision = precision;
        }
    }
}

