/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.log.BcLoggableObject;
import ext.lib.sql.SqlStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class SqlStatementTimeoutMonitor
extends BcLoggableObject {
    protected long checkInterval = 2000L;
    protected List<SqlStatement> statementList = new ArrayList<SqlStatement>();
    protected TimeoutCheckTask timeoutCheckTask = new TimeoutCheckTask();

    public SqlStatementTimeoutMonitor() {
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.timeoutCheckTask, this.checkInterval, this.checkInterval);
    }

    public static SqlStatementTimeoutMonitor getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    public void addStatement(SqlStatement statement) throws Exception {
        this.statementList.add(statement);
    }

    public boolean removeStatement(SqlStatement statement) throws Exception {
        return this.statementList.remove(statement);
    }

    public void statementTimeoutCheck() throws Exception {
        SqlStatement[] statements = this.statementList.toArray(new SqlStatement[0]);
        int i = 0;
        while (i < statements.length) {
            SqlStatement statement = statements[i];
            if (!statement.isClosed() && statement.getTimeout() > 0L) {
                long now = System.currentTimeMillis();
                long elapsedTime = now - statement.getStartTime();
                this.getLogger().info("elapsedTime=" + elapsedTime);
                if (elapsedTime > statement.getTimeout()) {
                    this.getLogger().info("Statement timeout:startTime=" + statement.getStartTime() + " elapsedTime=" + elapsedTime + " sql+" + statement.getSql());
                    try {
                        statement.cancel();
                    }
                    catch (Exception ex) {
                        this.getLogger().debug("Statement timeout check error:statement.hashCode()=" + statement.hashCode());
                        this.getLogger().error(ex);
                    }
                }
            }
            ++i;
        }
    }

    private static final class SingletonHolder {
        private static final SqlStatementTimeoutMonitor instance = new SqlStatementTimeoutMonitor();

        private SingletonHolder() {
        }
    }

    class TimeoutCheckTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                SqlStatementTimeoutMonitor.this.statementTimeoutCheck();
            }
            catch (Exception ex) {
                SqlStatementTimeoutMonitor.this.getLogger().error(ex);
            }
        }
    }
}

